/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.requirement;

import com.extendedclip.deluxemenus.action.ClickHandler;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.requirement.Requirement;
import java.util.List;

public class RequirementList {
    private List<Requirement> requirements;
    private ClickHandler denyHandler;
    private int minimumRequirements;
    private boolean stopAtSuccess;

    public RequirementList(List<Requirement> requirements) {
        this.setRequirements(requirements);
    }

    public boolean evaluate(MenuHolder holder) {
        int successful = 0;
        for (Requirement r : this.getRequirements()) {
            if (r.evaluate(holder)) {
                ++successful;
                if (r.getSuccessHandler() != null) {
                    r.getSuccessHandler().onClick(holder);
                }
                if (!this.stopAtSuccess || successful < this.minimumRequirements) continue;
                break;
            }
            if (r.getDenyHandler() != null) {
                r.getDenyHandler().onClick(holder);
            }
            if (r.isOptional()) continue;
            return false;
        }
        return successful >= this.minimumRequirements;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(List<Requirement> requirements) {
        this.requirements = requirements;
    }

    public ClickHandler getDenyHandler() {
        return this.denyHandler;
    }

    public void setDenyHandler(ClickHandler denyHandler) {
        this.denyHandler = denyHandler;
    }

    public int getMinimumRequirements() {
        return this.minimumRequirements;
    }

    public void setMinimumRequirements(int minimumRequirements) {
        this.minimumRequirements = minimumRequirements;
    }

    public boolean stopAtSuccess() {
        return this.stopAtSuccess;
    }

    public void setStopAtSuccess(boolean stop) {
        this.stopAtSuccess = stop;
    }
}

