/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.libs.nashorn.api.scripting.NashornScriptEngineFactory;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.requirement.Requirement;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import java.util.logging.Level;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;

public class JavascriptRequirement
extends Requirement {
    private final ScriptEngineFactory factory = new NashornScriptEngineFactory();
    private final ServicesManager manager = Bukkit.getServer().getServicesManager();
    private static ScriptEngineManager engine;
    private final String expression;

    public JavascriptRequirement(String expression) {
        this.expression = expression;
        if (engine == null) {
            if (this.manager.isProvidedFor(ScriptEngineManager.class)) {
                RegisteredServiceProvider provider = this.manager.getRegistration(ScriptEngineManager.class);
                engine = (ScriptEngineManager)provider.getProvider();
            } else {
                engine = new ScriptEngineManager();
                this.manager.register(ScriptEngineManager.class, (Object)engine, (Plugin)DeluxeMenus.getInstance(), ServicePriority.Highest);
            }
            engine.registerEngineName("JavaScript", this.factory);
            engine.put("BukkitServer", Bukkit.getServer());
        }
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        String exp = holder.setPlaceholders(this.expression);
        try {
            engine.put("BukkitPlayer", holder.getViewer());
            Object result = engine.getEngineByName("JavaScript").eval(exp);
            if (!(result instanceof Boolean)) {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Requirement javascript <" + this.expression + "> is invalid and does not return a boolean!");
                return false;
            }
            return (Boolean)result;
        }
        catch (NullPointerException | ScriptException exception) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Error in requirement javascript syntax - " + this.expression);
            DeluxeMenus.printStacktrace("Error in requirement javascript syntax - " + this.expression, exception);
            return false;
        }
    }
}

