/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.action.ClickHandler;
import com.extendedclip.deluxemenus.config.DeluxeMenusConfig;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.requirement.RequirementList;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.StringUtils;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class MenuItem
implements Cloneable {
    private Material material;
    private short data;
    private int amount;
    private int customModelData;
    private String dynamicAmount = null;
    private String displayName;
    private boolean displayNameHasPlaceholders;
    private List<String> lore;
    private boolean loreHasPlaceholders;
    private DyeColor baseColor;
    private int slot;
    private int priority;
    private RequirementList viewRequirements;
    private List<ItemFlag> itemFlags;
    private boolean unbreakable;
    private boolean hideAttributes;
    private boolean hideEnchants;
    private boolean hidePotionEffects;
    private boolean hideUnbreakable;
    private boolean updatePlaceholders;
    private Map<Enchantment, Integer> enchantments;
    private List<PotionEffect> potionEffects;
    private boolean isHead;
    private boolean isTextureHead;
    private boolean isHeadDbHead;
    private boolean isBaseHead;
    private boolean isItemsAdder;
    private boolean waterBottle;
    private String handItem;
    private String armorItem;
    private String rgb;
    private String placeholderMaterial;
    private String placeholderData;
    private String headOwner;
    private String itemsAdderItem;
    private EntityType entityType;
    private boolean isBanner;
    private List<Pattern> bannerMeta;
    private boolean isPotion;
    private String nbtString;
    private String nbtInt;
    private List<String> nbtStrings;
    private List<String> nbtInts;
    private ClickHandler clickHandler;
    private ClickHandler leftClickHandler;
    private ClickHandler rightClickHandler;
    private ClickHandler shiftLeftClickHandler;
    private ClickHandler shiftRightClickHandler;
    private ClickHandler middleClickHandler;
    private RequirementList clickRequirements;
    private RequirementList leftClickRequirements;
    private RequirementList rightClickRequirements;
    private RequirementList shiftLeftClickRequirements;
    private RequirementList shiftRightClickRequirements;
    private RequirementList middleClickRequirements;

    public MenuItem clone() {
        try {
            return (MenuItem)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            DeluxeMenus.printStacktrace("Something went wrong while trying to clone menu item.", exception);
            return new MenuItem();
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public short getData() {
        return this.data;
    }

    public void setData(Short data) {
        this.data = data;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        if (this.displayName != null) {
            this.displayNameHasPlaceholders = DeluxeMenusConfig.containsPlaceholders(this.displayName);
        }
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
        if (this.lore != null) {
            boolean has = false;
            for (String line : lore) {
                if (!DeluxeMenusConfig.containsPlaceholders(line)) continue;
                has = true;
                break;
            }
            this.loreHasPlaceholders = has;
        }
    }

    public ClickHandler getLeftClickHandler() {
        return this.leftClickHandler;
    }

    public void setLeftClickHandler(ClickHandler clickHandler) {
        this.leftClickHandler = clickHandler;
    }

    public ClickHandler getRightClickHandler() {
        return this.rightClickHandler;
    }

    public void setRightClickHandler(ClickHandler clickHandler) {
        this.rightClickHandler = clickHandler;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean hasViewRequirement() {
        return this.viewRequirements != null && this.viewRequirements.getRequirements() != null;
    }

    public RequirementList getViewRequirements() {
        return this.viewRequirements;
    }

    public void setViewRequirements(RequirementList r) {
        this.viewRequirements = r;
    }

    public boolean displayNameHasPlaceholders() {
        return this.displayNameHasPlaceholders;
    }

    public boolean loreHasPlaceholders() {
        return this.loreHasPlaceholders;
    }

    public boolean updatePlaceholders() {
        return this.updatePlaceholders;
    }

    public void setUpdatePlaceholders(boolean updatePlaceholders) {
        this.updatePlaceholders = updatePlaceholders;
    }

    public boolean hideAttributes() {
        return this.hideAttributes;
    }

    public void setHideAttributes(boolean hide) {
        this.hideAttributes = hide;
    }

    public List<ItemFlag> itemFlags() {
        return this.itemFlags;
    }

    public void setItemFlags(List<ItemFlag> flags) {
        this.itemFlags = flags;
    }

    public boolean hideEnchants() {
        return this.hideEnchants;
    }

    public void setHideEnchants(boolean hideEnchants) {
        this.hideEnchants = hideEnchants;
    }

    public boolean hidePotionEffects() {
        return this.hidePotionEffects;
    }

    public void setHidePotionEffects(boolean hidePotionEffects) {
        this.hidePotionEffects = hidePotionEffects;
    }

    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        this.enchantments = enchantments;
    }

    public boolean isHead() {
        return this.isHead;
    }

    public void setIsHead(boolean isHead) {
        this.isHead = isHead;
    }

    public String getHeadOwner() {
        return this.headOwner;
    }

    public void setHeadOwner(String headOwner) {
        this.headOwner = headOwner;
    }

    public RequirementList getLeftClickRequirements() {
        return this.leftClickRequirements;
    }

    public void setLeftClickRequirements(RequirementList leftClickRequirements) {
        this.leftClickRequirements = leftClickRequirements;
    }

    public RequirementList getRightClickRequirements() {
        return this.rightClickRequirements;
    }

    public void setRightClickRequirements(RequirementList rightClickRequirements) {
        this.rightClickRequirements = rightClickRequirements;
    }

    public boolean isBanner() {
        return this.isBanner;
    }

    public void setIsBanner(boolean isBanner) {
        this.isBanner = isBanner;
    }

    public List<Pattern> getBannerMeta() {
        return this.bannerMeta;
    }

    public void setBannerMeta(List<Pattern> bannerMeta) {
        this.bannerMeta = bannerMeta;
    }

    public String getDynamicAmount() {
        return this.dynamicAmount;
    }

    public void setDynamicAmount(String dynamicAmount) {
        this.dynamicAmount = dynamicAmount;
    }

    public boolean hideUnbreakable() {
        return this.hideUnbreakable;
    }

    public void setHideUnbreakable(boolean b) {
        this.hideUnbreakable = b;
    }

    public String getRGB() {
        return this.rgb;
    }

    public void setRGB(String rgb) {
        this.rgb = rgb;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean isHeadDbHead() {
        return this.isHeadDbHead;
    }

    public void setHeadDbHead(boolean isHeadDbHead) {
        this.isHeadDbHead = isHeadDbHead;
    }

    public boolean isBaseHead() {
        return this.isBaseHead;
    }

    public void setBaseHead(boolean isBaseHead) {
        this.isBaseHead = isBaseHead;
    }

    public boolean isPlaceholderMaterial() {
        return this.placeholderMaterial != null;
    }

    public String getPlaceholderMaterial() {
        return this.placeholderMaterial;
    }

    public void setPlaceholderMaterial(String placeholderMaterial) {
        this.placeholderMaterial = placeholderMaterial;
    }

    public String getPlaceholderData() {
        return this.placeholderData;
    }

    public void setPlaceholderData(String placeholderData) {
        this.placeholderData = placeholderData;
    }

    public ClickHandler getShiftLeftClickHandler() {
        return this.shiftLeftClickHandler;
    }

    public void setShiftLeftClickHandler(ClickHandler shiftLeftClickHandler) {
        this.shiftLeftClickHandler = shiftLeftClickHandler;
    }

    public ClickHandler getShiftRightClickHandler() {
        return this.shiftRightClickHandler;
    }

    public void setShiftRightClickHandler(ClickHandler shiftRightClickHandler) {
        this.shiftRightClickHandler = shiftRightClickHandler;
    }

    public RequirementList getShiftLeftClickRequirements() {
        return this.shiftLeftClickRequirements;
    }

    public void setShiftLeftClickRequirements(RequirementList shiftLeftClickRequirements) {
        this.shiftLeftClickRequirements = shiftLeftClickRequirements;
    }

    public RequirementList getShiftRightClickRequirements() {
        return this.shiftRightClickRequirements;
    }

    public void setShiftRightClickRequirements(RequirementList shiftRightClickRequirements) {
        this.shiftRightClickRequirements = shiftRightClickRequirements;
    }

    public ClickHandler getMiddleClickHandler() {
        return this.middleClickHandler;
    }

    public void setMiddleClickHandler(ClickHandler middleClickHandler) {
        this.middleClickHandler = middleClickHandler;
    }

    public RequirementList getMiddleClickRequirements() {
        return this.middleClickRequirements;
    }

    public void setMiddleClickRequirements(RequirementList middleClickRequirements) {
        this.middleClickRequirements = middleClickRequirements;
    }

    public String getNbtString() {
        return this.nbtString;
    }

    public void setNbtString(String nbtString) {
        this.nbtString = nbtString;
    }

    public String getNbtInt() {
        return this.nbtInt;
    }

    public void setNbtInt(String nbtInt) {
        this.nbtInt = nbtInt;
    }

    public List<String> getNbtStrings() {
        return this.nbtStrings;
    }

    public void setNbtStrings(List<String> nbtStrings) {
        this.nbtStrings = nbtStrings;
    }

    public List<String> getNbtInts() {
        return this.nbtInts;
    }

    public void setNbtInts(List<String> nbtInts) {
        this.nbtInts = nbtInts;
    }

    public String getHandItem() {
        return this.handItem;
    }

    public void setHandItem(String handItem) {
        this.handItem = handItem;
    }

    public ItemStack getItemStack(MenuHolder holder) {
        String tag;
        String tag2;
        Object parts;
        String rgbString;
        ItemMeta meta;
        int amt;
        ItemStack itemStack;
        block97: {
            Player viewer = holder.getViewer();
            itemStack = null;
            amt = 1;
            if (this.handItem != null) {
                if (this.handItem.equalsIgnoreCase("main_hand")) {
                    if (viewer.getInventory().getItemInMainHand() == null) {
                        return null;
                    }
                    itemStack = viewer.getInventory().getItemInMainHand().clone();
                    amt = itemStack.getAmount();
                } else if (this.handItem.equalsIgnoreCase("off_hand")) {
                    if (viewer.getInventory().getItemInOffHand() == null) {
                        return null;
                    }
                    itemStack = viewer.getInventory().getItemInOffHand().clone();
                    amt = itemStack.getAmount();
                }
            }
            if (this.armorItem != null) {
                if (this.armorItem.equalsIgnoreCase("armor_helmet")) {
                    if (viewer.getInventory().getHelmet() == null) {
                        return null;
                    }
                    itemStack = viewer.getInventory().getHelmet().clone();
                    amt = itemStack.getAmount();
                } else if (this.armorItem.equalsIgnoreCase("armor_chestplate")) {
                    if (viewer.getInventory().getChestplate() == null) {
                        return null;
                    }
                    itemStack = viewer.getInventory().getChestplate().clone();
                    amt = itemStack.getAmount();
                } else if (this.armorItem.equalsIgnoreCase("armor_leggings")) {
                    if (viewer.getInventory().getLeggings() == null) {
                        return null;
                    }
                    itemStack = viewer.getInventory().getLeggings().clone();
                    amt = itemStack.getAmount();
                } else if (this.armorItem.equalsIgnoreCase("armor_boots")) {
                    if (viewer.getInventory().getBoots() == null) {
                        return null;
                    }
                    itemStack = viewer.getInventory().getBoots().clone();
                    amt = itemStack.getAmount();
                }
            }
            if (this.isHead && this.headOwner != null) {
                String ownerName = holder.setPlaceholders(this.headOwner);
                if (this.isHeadDbHead && DeluxeMenus.getInstance().getItemHook("hdb") != null) {
                    itemStack = DeluxeMenus.getInstance().getItemHook("hdb").getItem(ownerName);
                } else if (this.isBaseHead && DeluxeMenus.getInstance().getItemHook("basehead") != null) {
                    itemStack = DeluxeMenus.getInstance().getItemHook("basehead").getItem(ownerName);
                } else if (this.isTextureHead && DeluxeMenus.getInstance().getItemHook("texture") != null) {
                    itemStack = DeluxeMenus.getInstance().getItemHook("texture").getItem(ownerName);
                } else {
                    itemStack = DeluxeMenus.getInstance().getHead().clone();
                    if (!ownerName.isEmpty()) {
                        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                        OfflinePlayer pl = DeluxeMenus.getInstance().getPlayerCache().get(ownerName);
                        if (!VersionHelper.IS_SKULL_OWNER_LEGACY) {
                            skullMeta.setOwningPlayer(pl);
                        } else {
                            skullMeta.setOwner(pl.getName());
                        }
                        itemStack.setItemMeta((ItemMeta)skullMeta);
                    }
                }
            } else if (this.isItemsAdder && this.itemsAdderItem != null) {
                String itemName = holder.setPlaceholders(this.itemsAdderItem);
                ItemHook itemHook = DeluxeMenus.getInstance().getItemHook("itemsadder");
                itemStack = itemHook != null ? itemHook.getItem(itemName) : new ItemStack(Material.STONE);
            } else if (this.isBanner && this.bannerMeta != null) {
                if (this.material == Material.SHIELD) {
                    itemStack = new ItemStack(this.material, amt);
                    meta = itemStack.getItemMeta();
                    BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
                    Banner banner = (Banner)blockStateMeta.getBlockState();
                    if (this.baseColor != null) {
                        banner.setBaseColor(this.baseColor);
                    }
                    banner.setPatterns(this.bannerMeta);
                    banner.update();
                    blockStateMeta.setBlockState((BlockState)banner);
                    itemStack.setItemMeta((ItemMeta)blockStateMeta);
                } else {
                    itemStack = new ItemStack(this.material, amt);
                    meta = (BannerMeta)itemStack.getItemMeta();
                    if (this.baseColor != null) {
                        meta.setBaseColor(this.baseColor);
                    }
                    meta.setPatterns(this.bannerMeta);
                    itemStack.setItemMeta(meta);
                }
            } else if (this.isPotion && this.rgb != null) {
                itemStack = new ItemStack(this.material, amt);
                String rgbString2 = holder.setPlaceholders(this.rgb);
                String[] parts2 = rgbString2.split(",");
                PotionMeta meta2 = (PotionMeta)itemStack.getItemMeta();
                try {
                    meta2.setColor(Color.fromRGB((int)Integer.parseInt(parts2[0].trim()), (int)Integer.parseInt(parts2[1].trim()), (int)Integer.parseInt(parts2[2].trim())));
                    itemStack.setItemMeta((ItemMeta)meta2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.potionEffects != null && !this.potionEffects.isEmpty()) {
                    for (PotionEffect effect : this.potionEffects) {
                        meta2.addCustomEffect(effect, true);
                    }
                    itemStack.setItemMeta((ItemMeta)meta2);
                }
            } else if (this.placeholderMaterial != null) {
                String pMat = holder.setPlaceholders(this.placeholderMaterial);
                if (pMat.equalsIgnoreCase("water_bottle")) {
                    itemStack = this.createWaterBottle(amt);
                } else {
                    Material material = null;
                    try {
                        material = Material.valueOf((String)holder.setPlaceholders(pMat).toUpperCase(Locale.getDefault()));
                    }
                    catch (Exception meta2) {
                        // empty catch block
                    }
                    if (material == null) {
                        return new ItemStack(Material.STONE, 1);
                    }
                    itemStack = new ItemStack(material, amt);
                }
            } else if (this.waterBottle) {
                itemStack = this.createWaterBottle(amt);
            } else if (this.material != null) {
                itemStack = new ItemStack(this.material, amt);
            } else if (itemStack == null) {
                itemStack = new ItemStack(Material.STONE, amt);
            }
            if (itemStack == null) {
                itemStack = new ItemStack(Material.STONE, amt);
            }
            if (this.placeholderData != null) {
                try {
                    this.data = Short.parseShort(holder.setPlaceholders(this.placeholderData));
                }
                catch (Exception exception) {
                    DeluxeMenus.printStacktrace("Invalid placeholder data found: " + holder.setPlaceholders(this.placeholderData) + ".", exception);
                }
            }
            if (this.data > 0) {
                itemStack.setDurability(this.data);
            }
            if (itemStack.getType() == Material.AIR) {
                return itemStack;
            }
            if (this.getDynamicAmount() != null) {
                try {
                    String dAmt = holder.setPlaceholders(this.dynamicAmount);
                    amt = (int)Double.parseDouble(dAmt);
                    if (amt <= 0) {
                        amt = 1;
                    }
                    break block97;
                }
                catch (Exception ex) {
                    if (this.amount != -1) {
                        amt = this.amount;
                    }
                    break block97;
                }
            }
            if (this.amount != -1) {
                amt = this.amount;
            }
        }
        meta = itemStack.getItemMeta();
        if (this.customModelData >= 0 && VersionHelper.IS_CUSTOM_MODEL_DATA) {
            meta.setCustomModelData(Integer.valueOf(this.customModelData));
        }
        if (this.displayName != null) {
            String dName = holder.setPlaceholders(this.displayName);
            meta.setDisplayName(StringUtils.color(dName));
        }
        if (this.lore != null) {
            List l = this.lore.stream().map(holder::setPlaceholders).map(StringUtils::color).map(line -> line.split("\n")).flatMap(Arrays::stream).map(line -> line.split("\\\\n")).flatMap(Arrays::stream).collect(Collectors.toList());
            meta.setLore(l);
        }
        if (this.itemFlags != null && !this.itemFlags.isEmpty()) {
            for (ItemFlag flag : this.itemFlags) {
                meta.addItemFlags(new ItemFlag[]{flag});
            }
        }
        if (this.hideAttributes) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (this.hideEnchants) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (this.hidePotionEffects) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        }
        if (this.unbreakable) {
            meta.setUnbreakable(true);
        }
        if (this.hideUnbreakable) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        if (meta instanceof LeatherArmorMeta && this.rgb != null) {
            rgbString = holder.setPlaceholders(this.rgb);
            parts = rgbString.split(",");
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
            try {
                leatherArmorMeta.setColor(Color.fromRGB((int)Integer.parseInt(((String)parts[0]).trim()), (int)Integer.parseInt(((String)parts[1]).trim()), (int)Integer.parseInt(((String)parts[2]).trim())));
                itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
            }
            catch (Exception exception) {
                DeluxeMenus.printStacktrace("Invalid rgb colors found for leather armor: " + ((String)parts[0]).trim() + ", " + ((String)parts[1]).trim() + ", " + ((String)parts[2]).trim(), exception);
            }
        } else if (meta instanceof FireworkEffectMeta && this.rgb != null) {
            rgbString = holder.setPlaceholders(this.rgb);
            parts = rgbString.split(",");
            FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)meta;
            try {
                fireworkEffectMeta.setEffect(FireworkEffect.builder().withColor(Color.fromRGB((int)Integer.parseInt(((String)parts[0]).trim()), (int)Integer.parseInt(((String)parts[1]).trim()), (int)Integer.parseInt(((String)parts[2]).trim()))).build());
                itemStack.setItemMeta((ItemMeta)fireworkEffectMeta);
            }
            catch (Exception exception) {
                DeluxeMenus.printStacktrace("Invalid rgb colors found for firework or firework star: " + ((String)parts[0]).trim() + ", " + ((String)parts[1]).trim() + ", " + ((String)parts[2]).trim(), exception);
            }
        } else if (meta instanceof EnchantmentStorageMeta && this.enchantments != null) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)meta;
            for (Map.Entry entry : this.enchantments.entrySet()) {
                boolean result = enchantmentStorageMeta.addStoredEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                if (result) continue;
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "Failed to add enchantment " + ((Enchantment)entry.getKey()).getName() + " to item " + itemStack.getType());
            }
            itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        } else {
            itemStack.setItemMeta(meta);
        }
        if (!(meta instanceof EnchantmentStorageMeta) && this.enchantments != null) {
            itemStack.addUnsafeEnchantments(this.enchantments);
        }
        if (amt > 64) {
            amt = 64;
        }
        if (this.entityType != null) {
            itemStack = DeluxeMenus.getInstance().getNms().getAccessor().setEggType(itemStack, this.entityType);
        }
        if (this.getNbtString() != null && DeluxeMenus.getInstance().getNms().getAccessor() != null && (tag2 = holder.setPlaceholders(this.getNbtString())).contains(":")) {
            parts = tag2.split(":", 2);
            itemStack = DeluxeMenus.getInstance().getNms().getAccessor().setTag(itemStack, (String)parts[0], (String)parts[1]);
        }
        if (this.getNbtInt() != null && DeluxeMenus.getInstance().getNms().getAccessor() != null && (tag = holder.setPlaceholders(this.getNbtInt())).contains(":")) {
            parts = tag.split(":");
            itemStack = DeluxeMenus.getInstance().getNms().getAccessor().setTag(itemStack, (String)parts[0], Integer.parseInt((String)parts[1]));
        }
        if (!this.getNbtStrings().isEmpty() && DeluxeMenus.getInstance().getNms().getAccessor() != null) {
            for (String nbtTag : this.getNbtStrings()) {
                String string = holder.setPlaceholders(nbtTag);
                if (!string.contains(":")) continue;
                String[] parts3 = string.split(":", 2);
                itemStack = DeluxeMenus.getInstance().getNms().getAccessor().setTag(itemStack, parts3[0], parts3[1]);
            }
        }
        if (!this.getNbtInts().isEmpty() && DeluxeMenus.getInstance().getNms().getAccessor() != null) {
            for (String nbtTag : this.getNbtInts()) {
                String string = holder.setPlaceholders(nbtTag);
                if (!string.contains(":")) continue;
                String[] parts4 = string.split(":");
                itemStack = DeluxeMenus.getInstance().getNms().getAccessor().setTag(itemStack, parts4[0], Integer.parseInt(parts4[1]));
            }
        }
        itemStack.setAmount(amt);
        return itemStack;
    }

    private ItemStack createWaterBottle(int amount) {
        ItemStack itemStack = new ItemStack(Material.POTION, amount);
        PotionMeta meta = (PotionMeta)itemStack.getItemMeta();
        if (meta != null) {
            PotionData pData = new PotionData(PotionType.WATER);
            meta.setBasePotionData(pData);
            itemStack.setItemMeta((ItemMeta)meta);
        }
        return itemStack;
    }

    public ClickHandler getClickHandler() {
        return this.clickHandler;
    }

    public void setClickHandler(ClickHandler clickHandler) {
        this.clickHandler = clickHandler;
    }

    public RequirementList getClickRequirements() {
        return this.clickRequirements;
    }

    public void setClickRequirements(RequirementList clickRequirements) {
        this.clickRequirements = clickRequirements;
    }

    public boolean isPotion() {
        return this.isPotion;
    }

    public void setPotion(boolean potion) {
        this.isPotion = potion;
    }

    public List<PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }

    public void setPotionEffects(List<PotionEffect> potionEffects) {
        this.potionEffects = potionEffects;
    }

    public boolean isTextureHead() {
        return this.isTextureHead;
    }

    public void setTextureHead(boolean textureHead) {
        this.isTextureHead = textureHead;
    }

    public boolean isWaterBottle() {
        return this.waterBottle;
    }

    public void setWaterBottle(boolean waterBottle) {
        this.waterBottle = waterBottle;
    }

    public String getArmorItem() {
        return this.armorItem;
    }

    public void setArmorItem(String armorItem) {
        this.armorItem = armorItem;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public void setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
    }

    public boolean isItemsAdder() {
        return this.isItemsAdder;
    }

    public void setIsItemsAdder(boolean itemsAdder) {
        this.isItemsAdder = itemsAdder;
    }

    public String getItemsAdderItem() {
        return this.itemsAdderItem;
    }

    public void setItemsAdderItem(String itemsAdderItem) {
        this.itemsAdderItem = itemsAdderItem;
    }

    public DyeColor getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(DyeColor baseColor) {
        this.baseColor = baseColor;
    }
}

