/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.libs.nashorn.api.tree;

import com.extendedclip.deluxemenus.libs.nashorn.api.tree.BlockTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.ExpressionTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.ExpressionTreeImpl;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.FunctionExpressionTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.IdentifierTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.IdentifierTreeImpl;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.ReturnTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.StatementTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.Tree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.TreeVisitor;
import com.extendedclip.deluxemenus.libs.nashorn.internal.ir.FunctionNode;
import java.util.List;

final class FunctionExpressionTreeImpl
extends ExpressionTreeImpl
implements FunctionExpressionTree {
    private final FunctionNode funcNode;
    private final IdentifierTree funcName;
    private final List<? extends ExpressionTree> params;
    private final Tree body;

    FunctionExpressionTreeImpl(FunctionNode node, List<? extends ExpressionTree> params, BlockTree body) {
        super(node);
        this.funcNode = node;
        assert (!this.funcNode.isDeclared() || this.funcNode.isAnonymous()) : "function expression expected";
        FunctionNode.Kind kind = node.getKind();
        this.funcName = node.isAnonymous() || kind == FunctionNode.Kind.GETTER || kind == FunctionNode.Kind.SETTER ? null : new IdentifierTreeImpl(node.getIdent());
        this.params = params;
        if (node.getFlag(0x4000000)) {
            StatementTree first = body.getStatements().get(0);
            assert (first instanceof ReturnTree) : "consise func. expression should have a return statement";
            this.body = ((ReturnTree)first).getExpression();
        } else {
            this.body = body;
        }
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FUNCTION_EXPRESSION;
    }

    @Override
    public IdentifierTree getName() {
        return this.funcName;
    }

    @Override
    public List<? extends ExpressionTree> getParameters() {
        return this.params;
    }

    @Override
    public Tree getBody() {
        return this.body;
    }

    @Override
    public boolean isStrict() {
        return this.funcNode.isStrict();
    }

    @Override
    public boolean isArrow() {
        return this.funcNode.getKind() == FunctionNode.Kind.ARROW;
    }

    @Override
    public boolean isGenerator() {
        return this.funcNode.getKind() == FunctionNode.Kind.GENERATOR;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitFunctionExpression(this, data);
    }
}

