/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.config;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.action.ActionType;
import com.extendedclip.deluxemenus.action.ClickAction;
import com.extendedclip.deluxemenus.action.ClickActionTask;
import com.extendedclip.deluxemenus.action.ClickHandler;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.MenuItem;
import com.extendedclip.deluxemenus.requirement.HasExpRequirement;
import com.extendedclip.deluxemenus.requirement.HasItemRequirement;
import com.extendedclip.deluxemenus.requirement.HasMetaRequirement;
import com.extendedclip.deluxemenus.requirement.HasMoneyRequirement;
import com.extendedclip.deluxemenus.requirement.HasPermissionRequirement;
import com.extendedclip.deluxemenus.requirement.InputResultRequirement;
import com.extendedclip.deluxemenus.requirement.IsNearRequirement;
import com.extendedclip.deluxemenus.requirement.JavascriptRequirement;
import com.extendedclip.deluxemenus.requirement.RegexMatchesRequirement;
import com.extendedclip.deluxemenus.requirement.Requirement;
import com.extendedclip.deluxemenus.requirement.RequirementList;
import com.extendedclip.deluxemenus.requirement.RequirementType;
import com.extendedclip.deluxemenus.requirement.wrappers.ItemWrapper;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.LocationUtils;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class DeluxeMenusConfig {
    public static final java.util.regex.Pattern DELAY_MATCHER = java.util.regex.Pattern.compile("<delay=([^<>]+)>", 2);
    public static final java.util.regex.Pattern CHANCE_MATCHER = java.util.regex.Pattern.compile("<chance=([^<>]+)>", 2);
    public static final java.util.regex.Pattern PLACEHOLDER_PATTERN = java.util.regex.Pattern.compile("%((?<identifier>[a-zA-Z0-9]+)_)(?<parameters>[^%]+)%");
    private static final List<InventoryType> VALID_INVENTORY_TYPES = VersionHelper.getValidInventoryTypes();
    private final String separator = File.separator;
    private final File menuDirectory;
    private final DeluxeMenus plugin;
    private final List<String> exampleMenus = Arrays.asList("basics_menu", "advanced_menu", "requirements_menu");

    public DeluxeMenusConfig(DeluxeMenus plugin) {
        this.plugin = plugin;
        this.menuDirectory = new File(this.plugin.getDataFolder() + this.separator + "gui_menus");
        try {
            if (this.menuDirectory.mkdirs()) {
                DeluxeMenus.debug(DebugLevel.HIGH, Level.INFO, "Individual menus directory did not exist.", "Created directory: plugins" + this.separator + "DeluxeMenus" + this.separator + "gui_menus");
            }
        }
        catch (SecurityException e) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Something went wrong while creating directory: plugins" + this.separator + "DeluxeMenus" + this.separator + "gui_menus");
        }
    }

    public static boolean containsPlaceholders(String text) {
        return PLACEHOLDER_PATTERN.matcher(text).find();
    }

    public boolean loadDefConfig() {
        if (this.checkConfig(null, "config.yml", true) == null) {
            return false;
        }
        FileConfiguration c = this.plugin.getConfig();
        c.options().header("DeluxeMenus " + this.plugin.getDescription().getVersion() + " main configuration file\n\nA full wiki on how to use this plugin can be found at:\nhttps://wiki.helpch.at/clips-plugins/deluxemenus\n");
        c.addDefault("debug", (Object)"HIGHEST");
        c.addDefault("check_updates", (Object)true);
        c.options().copyDefaults(true);
        if (!c.contains("gui_menus")) {
            this.createMenuExamples(c);
        } else {
            this.plugin.saveConfig();
            this.plugin.reloadConfig();
        }
        return true;
    }

    private void createMenuExamples(FileConfiguration c) {
        for (String name : this.exampleMenus) {
            File menuFile = new File(this.menuDirectory.getPath(), name + ".yml");
            try {
                menuFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            this.saveResourceToFile(name + ".yml", menuFile);
            c.set("gui_menus." + name + ".file", (Object)menuFile.getName());
        }
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
    }

    private boolean saveResourceToFile(String resource, File file) {
        try {
            InputStream is = this.plugin.getResource(resource);
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            FileOutputStream os = new FileOutputStream(file);
            ((OutputStream)os).write(buffer);
            return true;
        }
        catch (IOException | NullPointerException ex) {
            ex.printStackTrace();
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "Failed to save default settings for:" + file.getName() + " from resource:" + resource);
            return false;
        }
    }

    public FileConfiguration checkConfig(String folder, String fileName, boolean create) {
        File directory = folder != null ? new File(this.plugin.getDataFolder() + this.separator + folder + this.separator) : new File(this.plugin.getDataFolder() + this.separator);
        try {
            if (!directory.exists()) {
                return null;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        File configFile = new File(directory.getPath(), fileName);
        if (create) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (!configFile.exists()) {
            return null;
        }
        return this.checkConfig(configFile);
    }

    private FileConfiguration checkConfig(File f) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(f);
            return config;
        }
        catch (IOException e) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "Could not read file: " + f.getName());
            DeluxeMenus.printStacktrace("Could not read file: " + f.getName(), e);
            return null;
        }
        catch (InvalidConfigurationException e) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "Detected invalid configuration in file: " + f.getName());
            DeluxeMenus.printStacktrace("Detected invalid configuration in file: " + f.getName(), e);
            return null;
        }
    }

    public boolean loadGUIMenu(String menu) {
        if (this.checkConfig(null, "config.yml", false) == null) {
            return false;
        }
        FileConfiguration c = this.plugin.getConfig();
        if (!c.contains("gui_menus")) {
            return false;
        }
        if (!c.isConfigurationSection("gui_menus")) {
            return false;
        }
        Set keys = c.getConfigurationSection("gui_menus").getKeys(false);
        if (keys.isEmpty()) {
            return false;
        }
        if (!keys.contains(menu)) {
            return false;
        }
        if (c.contains("gui_menus." + menu + ".file")) {
            this.loadMenuFromFile(menu);
        } else {
            this.loadMenu(c, menu, true);
        }
        return true;
    }

    public int loadGUIMenus() {
        if (this.checkConfig(null, "config.yml", false) == null) {
            return 0;
        }
        FileConfiguration c = this.plugin.getConfig();
        if (!c.contains("gui_menus")) {
            return 0;
        }
        if (!c.isConfigurationSection("gui_menus")) {
            return 0;
        }
        Set keys = c.getConfigurationSection("gui_menus").getKeys(false);
        if (keys == null || keys.isEmpty()) {
            return 0;
        }
        for (String key : keys) {
            if (c.contains("gui_menus." + key + ".file")) {
                this.loadMenuFromFile(key);
                continue;
            }
            this.loadMenu(c, key, true);
        }
        return Menu.getLoadedMenuSize();
    }

    public boolean loadMenuFromFile(String menuName) {
        FileConfiguration cfg;
        String fileName = this.plugin.getConfig().getString("gui_menus." + menuName + ".file");
        if (!fileName.endsWith(".yml")) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "Filename specified for menu: " + menuName + " is not a .yml file!", "Make sure that the file name to load this menu from is specified as a .yml file!", "Skipping loading of menu: " + menuName);
            return false;
        }
        File f = new File(this.menuDirectory.getPath(), fileName);
        if (!f.exists()) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, f.getName() + " does not exist!");
            try {
                File folder = f.getParentFile();
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                f.createNewFile();
                if (!this.saveResourceToFile("default_menu.yml", f)) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Failed to create a default menu file for menu: " + menuName, "Skipping loading menu: " + menuName);
                    return false;
                }
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, f.getName() + " created! Add your menu options to this file and use /dm reload to load it!");
            }
            catch (IOException e) {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "Could not create menu file: plugins" + this.separator + "DeluxeMenus" + this.separator + "gui_menus" + this.separator + fileName);
                return false;
            }
        }
        if ((cfg = this.checkConfig(f)) == null) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Menu: " + menuName + " in file: " + fileName + " not loaded.");
            return false;
        }
        if (cfg.getKeys(false) == null || cfg.getKeys(false).isEmpty()) {
            DeluxeMenus.debug(DebugLevel.HIGH, Level.INFO, "Menu config: " + f.getName() + " is empty! Creating default config example...");
            this.saveResourceToFile("default_menu.yml", f);
            return false;
        }
        this.loadMenu(cfg, menuName, false);
        return Menu.getMenu(menuName) != null;
    }

    public void loadMenu(FileConfiguration c, String key, boolean mainConfig) {
        int update;
        ClickHandler closeHandler;
        ClickHandler openHandler;
        Menu menu;
        Map<Integer, TreeMap<Integer, MenuItem>> items;
        Object pre = "gui_menus." + key + ".";
        if (!mainConfig) {
            pre = "";
        }
        if (!c.contains((String)pre + "menu_title")) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "Menu title for menu: " + key + " is not present!", "Skipping menu: " + key);
            return;
        }
        String title = null;
        if (c.isString((String)pre + "menu_title")) {
            title = c.getString((String)pre + "menu_title");
        } else if (c.isList((String)pre + "menu_title")) {
            title = (String)c.getStringList((String)pre + "menu_title").get(0);
        }
        if (title == null || title.isEmpty()) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "Menu title for menu: " + key + " is invalid!", "Skipping menu: " + key);
            return;
        }
        InventoryType type = null;
        if (c.contains((String)pre + "inventory_type")) {
            try {
                InventoryType inventoryType = InventoryType.valueOf((String)c.getString((String)pre + "inventory_type").toUpperCase());
                type = VALID_INVENTORY_TYPES.contains(inventoryType) ? inventoryType : InventoryType.CHEST;
            }
            catch (Exception ex) {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Inventory type for menu: " + key + " is invalid!", "Valid Inventory types: " + Arrays.toString(VALID_INVENTORY_TYPES.toArray()), "Defaulting to CHEST inventory type.");
            }
        }
        if (c.isString((String)pre + "menu_title")) {
            title = c.getString((String)pre + "menu_title");
        } else if (c.isList((String)pre + "menu_title")) {
            title = (String)c.getStringList((String)pre + "menu_title").get(0);
        }
        ArrayList<String> openCommands = new ArrayList<String>();
        if (c.contains((String)pre + "open_command")) {
            if (c.isString((String)pre + "open_command") && !c.getString((String)pre + "open_command").isEmpty()) {
                String cmd = c.getString((String)pre + "open_command");
                if (cmd == null) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "open_command specified for menu: " + key + " is null!", "Skipping menu: " + key);
                    return;
                }
                if (Menu.isMenuCommand(cmd)) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "open_command specified for menu: " + key + " already exists for another menu!", "Skipping menu: " + key);
                    return;
                }
                openCommands.add(cmd.toLowerCase());
            } else if (c.isList((String)pre + "open_command") && !c.getStringList((String)pre + "open_command").isEmpty()) {
                List cmds = c.getStringList((String)pre + "open_command");
                for (String cmd : cmds) {
                    if (Menu.isMenuCommand(cmd)) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "command: " + cmd + " specified for menu: " + key + " already exists for another menu!", "Skipping command: " + cmd + " in menu: " + key);
                        continue;
                    }
                    openCommands.add(cmd.toLowerCase());
                }
            }
        }
        int size = 54;
        if (type == null || type == InventoryType.CHEST) {
            if (!c.contains((String)pre + "size")) {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "Menu size for menu: " + key + " is not present!", "Using default size of 54");
            } else {
                size = c.getInt((String)pre + "size");
                if ((size + 1) % 9 == 0) {
                    ++size;
                }
                if ((size - 1) % 9 == 0) {
                    --size;
                }
                if (size < 9) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.INFO, "Menu size for menu: " + key + " is lower than 9", "Defaulting to 9.");
                    size = 9;
                }
                if (size > 54) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Menu size for menu: " + key + " is higher than 54", "Defaulting to 54.");
                    size = 54;
                }
                if (size % 9 != 0) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Menu size for menu: " + key + " is not a multiple of 9", "Defaulting to 54.");
                    size = 54;
                }
            }
        } else {
            switch (type) {
                case BEACON: 
                case COMPOSTER: {
                    DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, "TYPE IS: " + type + ". Setting size to: 1");
                    size = 1;
                    break;
                }
                case ENCHANTING: 
                case STONECUTTER: {
                    DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, "TYPE IS: " + type + ". Setting size to: 2");
                    size = 2;
                    break;
                }
                case CARTOGRAPHY: 
                case GRINDSTONE: 
                case BLAST_FURNACE: 
                case FURNACE: 
                case SMOKER: 
                case SMITHING: 
                case ANVIL: {
                    DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, "TYPE IS: " + type + ". Setting size to: 3");
                    size = 3;
                    break;
                }
                case LOOM: {
                    DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, "TYPE IS: " + type + ". Setting size to: 4");
                    size = 4;
                    break;
                }
                case BREWING: 
                case HOPPER: {
                    DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, "TYPE IS: " + type + ". Setting size to: 5");
                    size = 5;
                    break;
                }
                case DISPENSER: 
                case DROPPER: {
                    DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, "TYPE IS: " + type + ". Setting size to: 9");
                    size = 9;
                    break;
                }
                case WORKBENCH: {
                    DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, "TYPE IS: " + type + ". Setting size to: 10");
                    size = 10;
                }
            }
        }
        RequirementList orl = null;
        if (c.contains((String)pre + "open_requirement")) {
            orl = this.getRequirements(c, (String)pre + "open_requirement");
        }
        if ((items = this.loadMenuItems(c, key, mainConfig)) == null || items.isEmpty()) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.SEVERE, "Failed to load menu items for menu: " + key, "Skipping menu: " + key);
            return;
        }
        if (openCommands.isEmpty()) {
            menu = new Menu(key, title, items, size);
        } else {
            boolean registerCommand = c.getBoolean((String)pre + "register_command", false);
            List<String> args = null;
            if (c.contains((String)pre + "args")) {
                if (c.isList((String)pre + "args")) {
                    args = c.getStringList((String)pre + "args");
                }
                if (c.isString((String)pre + "args")) {
                    args = Collections.singletonList(c.getString((String)pre + "args"));
                }
            }
            menu = new Menu(key, title, items, size, openCommands, registerCommand, args);
            menu.setArgUsageMessage(c.getString((String)pre + "args_usage_message", null));
        }
        if (type != null) {
            menu.setInventoryType(type);
        }
        if (orl != null && orl.getRequirements() != null) {
            menu.setOpenRequirements(orl);
        }
        if (c.contains((String)pre + "open_commands") && (openHandler = this.getClickHandler(c, (String)pre + "open_commands")) != null) {
            menu.setOpenHandler(openHandler);
        }
        if (c.contains((String)pre + "close_commands") && (closeHandler = this.getClickHandler(c, (String)pre + "close_commands")) != null) {
            menu.setCloseHandler(closeHandler);
        }
        int updateInterval = 10;
        if (c.contains((String)pre + "update_interval") && (update = c.getInt((String)pre + "update_interval")) >= 1) {
            updateInterval = update;
        }
        menu.setUpdateInterval(updateInterval);
    }

    private Map<Integer, TreeMap<Integer, MenuItem>> loadMenuItems(FileConfiguration c, String name, boolean mainConfig) {
        Object itemsPath = "gui_menus." + name + ".items";
        if (!mainConfig) {
            itemsPath = "items";
        }
        if (!c.contains((String)itemsPath) || !c.isConfigurationSection((String)itemsPath)) {
            return null;
        }
        Set itemKeys = c.getConfigurationSection((String)itemsPath).getKeys(false);
        if (itemKeys == null || itemKeys.isEmpty()) {
            return null;
        }
        HashMap<Integer, TreeMap<Integer, MenuItem>> menuItems = new HashMap<Integer, TreeMap<Integer, MenuItem>>();
        for (String key : itemKeys) {
            List enchantments;
            Iterator e3;
            String[] metaParts;
            String[] parts;
            String currentPath = (String)itemsPath + "." + key + ".";
            if (!c.contains(currentPath + "material")) {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Material for item: " + key + " in menu: " + name + " is not present!", "Skipping item: " + key);
                continue;
            }
            MenuItem menuItem = new MenuItem();
            String mat = c.getString(currentPath + "material");
            if (mat.startsWith("placeholder-")) {
                parts = mat.split("-", 2);
                if (parts.length < 2) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Placeholder for material in item: " + key + " in menu " + name + " is not the valid format!", "Valid format: placeholder-<placeholder>", "Skipping item: " + key);
                    continue;
                }
                if (DeluxeMenusConfig.containsPlaceholders(parts[1])) {
                    menuItem.setPlaceholderMaterial(parts[1]);
                }
            } else if (mat.startsWith("texture-")) {
                parts = mat.split("-", 2);
                if (parts.length < 2) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Texture head for item: " + key + " in menu: " + name + " is not the valid format!", "Valid format: texture-<headId>", "Skipping item: " + key);
                    continue;
                }
                menuItem.setHeadOwner(parts[1]);
                menuItem.setIsHead(true);
                menuItem.setTextureHead(true);
            } else if (mat.startsWith("hdb-")) {
                parts = mat.split("-", 2);
                if (parts.length != 2) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "HeadDatabase head for item: " + key + " in menu: " + name + " is not the valid format!", "Valid format: hdb-<headId>", "Skipping item: " + key);
                    continue;
                }
                menuItem.setHeadOwner(parts[1]);
                menuItem.setIsHead(true);
                menuItem.setHeadDbHead(true);
            } else if (mat.startsWith("basehead-")) {
                parts = mat.split("-", 2);
                if (parts.length != 2) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Basehead head for item: " + key + " in menu: " + name + " is not the valid format!", "Valid format: basehead-<base64>", "Skipping item: " + key);
                    continue;
                }
                menuItem.setHeadOwner(parts[1]);
                menuItem.setIsHead(true);
                menuItem.setBaseHead(true);
            } else if (mat.startsWith("head")) {
                parts = mat.split("-", 2);
                if (!mat.contains("-") || parts.length != 2) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Player head for item: " + key + " in menu: " + name + " is not the valid format!", "Valid format: head-<playername/%player_name%>", "Skipping item: " + key);
                    continue;
                }
                menuItem.setHeadOwner(parts[1]);
                menuItem.setIsHead(true);
            } else if (mat.startsWith("itemsadder-")) {
                parts = mat.split("-", 2);
                if (parts.length != 2) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "ItemsAdder name for item: " + key + " in menu: " + name + " is not the valid format!", "Valid format: itemsadder-<item-name>", "Skipping item: " + key);
                    continue;
                }
                menuItem.setItemsAdderItem(parts[1]);
                menuItem.setIsItemsAdder(true);
            } else if (mat.equalsIgnoreCase("main_hand") || mat.equalsIgnoreCase("off_hand")) {
                menuItem.setHandItem(mat);
            } else if (mat.equalsIgnoreCase("armor_helmet") || mat.equalsIgnoreCase("armor_chestplate") || mat.equalsIgnoreCase("armor_leggings") || mat.equalsIgnoreCase("armor_boots")) {
                menuItem.setArmorItem(mat);
            } else if (mat.equalsIgnoreCase("water_bottle")) {
                menuItem.setWaterBottle(true);
            } else {
                Material m = Material.getMaterial((String)mat.toUpperCase());
                if (m == null) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Material for item: " + key + " in menu: " + name + " is not a valid material name!", "Skipping item: " + key);
                    continue;
                }
                menuItem.setMaterial(m);
            }
            menuItem.setBaseColor(c.contains(currentPath + "base_color") && c.isString(currentPath + "base_color") ? DyeColor.valueOf((String)c.getString(currentPath + "base_color", "WHITE").toUpperCase(Locale.getDefault())) : null);
            if (c.contains(currentPath + "entity_type") && c.isString(currentPath + "entity_type")) {
                try {
                    EntityType entityType = EntityType.fromName((String)c.getString(currentPath + "entity_type", ""));
                    if (entityType == null) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "EntityType for item: " + key + " in menu: " + name + " is not a valid entity name!");
                    }
                    menuItem.setEntityType(entityType);
                }
                catch (Exception ignored) {
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "EntityType for item: " + key + " in menu: " + name + " is not a valid entity name!");
                }
            }
            menuItem.setSlot(c.getInt(currentPath + "slot", 0));
            menuItem.setAmount(c.getInt(currentPath + "amount", -1));
            menuItem.setDynamicAmount(c.getString(currentPath + "dynamic_amount", null));
            menuItem.setCustomModelData(c.getInt(currentPath + "model_data", -1));
            menuItem.setDisplayName(c.getString(currentPath + "display_name"));
            if (c.isList(currentPath + "lore")) {
                menuItem.setLore(c.getStringList(currentPath + "lore"));
            }
            menuItem.setRGB(c.getString(currentPath + "rgb", null));
            menuItem.setUnbreakable(c.getBoolean(currentPath + "unbreakable", false));
            menuItem.setUpdatePlaceholders(c.getBoolean(currentPath + "update", false));
            menuItem.setHideAttributes(c.getBoolean(currentPath + "hide_attributes", false));
            menuItem.setHideUnbreakable(c.getBoolean(currentPath + "hide_unbreakable", false));
            menuItem.setHideEnchants(c.getBoolean(currentPath + "hide_enchantments", false));
            menuItem.setHidePotionEffects(c.getBoolean(currentPath + "hide_effects", false));
            menuItem.setNbtString(c.getString(currentPath + "nbt_string", null));
            menuItem.setNbtInt(c.getString(currentPath + "nbt_int", null));
            menuItem.setNbtStrings(c.getStringList(currentPath + "nbt_strings"));
            menuItem.setNbtInts(c.getStringList(currentPath + "nbt_ints"));
            menuItem.setPriority(c.getInt(currentPath + "priority", 1));
            if (c.contains(currentPath + "item_flags")) {
                if (c.isString(currentPath + "item_flags")) {
                    String flagAsString = c.getString(currentPath + "item_flags");
                    try {
                        ItemFlag flag = ItemFlag.valueOf((String)flagAsString.toUpperCase());
                        menuItem.setItemFlags(Collections.singletonList(flag));
                    }
                    catch (IllegalArgumentException | NullPointerException ignored) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Item flag: " + flagAsString + " for item: " + key + " in menu: " + name + " is not a valid item flag!");
                    }
                } else {
                    ArrayList<ItemFlag> flags = new ArrayList<ItemFlag>();
                    for (String flagAsString : c.getStringList(currentPath + "item_flags")) {
                        try {
                            flags.add(ItemFlag.valueOf((String)flagAsString.toUpperCase()));
                        }
                        catch (Exception ignored) {
                            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Item flag: " + flagAsString + " for item: " + key + " in menu: " + name + " is not a valid item flag!");
                        }
                    }
                    if (!flags.isEmpty()) {
                        menuItem.setItemFlags(flags);
                    }
                }
            }
            if (c.contains(currentPath + "data")) {
                if (c.isInt(currentPath + "data")) {
                    menuItem.setData((short)c.getInt(currentPath + "data"));
                } else {
                    String dataString = c.getString(currentPath + "data", "");
                    if (dataString.startsWith("placeholder-")) {
                        String[] parts2 = dataString.split("-", 2);
                        if (parts2.length < 2) {
                            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Placeholder for data in item: " + key + " in menu " + name + " is not the valid format!", "Valid format: placeholder-<placeholder>", "Skipping item: " + key);
                            continue;
                        }
                        if (DeluxeMenusConfig.containsPlaceholders((String)parts2[1])) {
                            menuItem.setPlaceholderData((String)parts2[1]);
                        }
                    }
                }
            }
            if (c.contains(currentPath + "banner_meta") && c.isList(currentPath + "banner_meta")) {
                ArrayList<Pattern> bannerMeta = new ArrayList<Pattern>();
                for (String e2 : c.getStringList(currentPath + "banner_meta")) {
                    PatternType type;
                    DyeColor color;
                    if (!e2.contains(";")) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Banner Meta for item: " + key + ", meta entry: " + e2 + " is invalid! Skipping this entry!");
                        continue;
                    }
                    metaParts = e2.split(";", 2);
                    if (metaParts.length != 2) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Banner Meta for item: " + key + ", meta entry: " + e2 + " is invalid! Skipping this entry!");
                        continue;
                    }
                    try {
                        color = DyeColor.valueOf((String)metaParts[0].toUpperCase());
                        type = PatternType.valueOf((String)metaParts[1].toUpperCase());
                    }
                    catch (IllegalArgumentException exception) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Banner Meta for item: " + key + ", meta entry: " + e2 + " is invalid! Skipping this entry!");
                        DeluxeMenus.printStacktrace("Banner Meta for item: " + key + ", meta entry: " + e2 + " is invalid! Skipping this entry!", exception);
                        continue;
                    }
                    bannerMeta.add(new Pattern(color, type));
                }
                if (!bannerMeta.isEmpty()) {
                    menuItem.setIsBanner(true);
                    menuItem.setBannerMeta(bannerMeta);
                    menuItem.setHidePotionEffects(true);
                }
            }
            if (c.contains(currentPath + "potion_effects") && c.isList(currentPath + "potion_effects")) {
                ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
                for (Iterator e3 : c.getStringList(currentPath + "potion_effects")) {
                    try {
                        if (!((String)((Object)e3)).contains(";")) {
                            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Potion Meta for item: " + key + ", meta entry: " + (String)((Object)e3) + " is invalid! Skipping this entry!");
                            continue;
                        }
                        metaParts = ((String)((Object)e3)).split(";", 3);
                        if (metaParts.length != 3) {
                            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Potion Meta for item: " + key + ", meta entry: " + (String)((Object)e3) + " is invalid! Skipping this entry!");
                            continue;
                        }
                        PotionEffectType type = PotionEffectType.getByName((String)metaParts[0]);
                        int duration = Integer.parseInt(metaParts[1]);
                        int amplifier = Integer.parseInt(metaParts[2]);
                        if (type == null) {
                            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Potion Meta for item: " + key + ", meta entry: " + (String)((Object)e3) + " is invalid! Skipping this entry!");
                            continue;
                        }
                        potionEffects.add(type.createEffect(duration, amplifier));
                    }
                    catch (Exception ex) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Potion Meta for item: " + key + ", meta entry: " + (String)((Object)e3) + " is invalid! Skipping this entry!");
                    }
                }
                if (!potionEffects.isEmpty()) {
                    menuItem.setPotion(true);
                    menuItem.setPotionEffects(potionEffects);
                }
            }
            if (c.contains(currentPath + "enchantments") && !(enchantments = c.getStringList(currentPath + "enchantments")).isEmpty()) {
                HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
                e3 = enchantments.iterator();
                while (e3.hasNext()) {
                    String e4 = (String)e3.next();
                    if (e4.contains(";")) {
                        String[] parts3 = e4.split(";");
                        if (parts3.length == 2) {
                            Enchantment enc = Enchantment.getByName((String)parts3[0].toUpperCase());
                            int level = 1;
                            if (enc != null) {
                                try {
                                    level = Integer.parseInt(parts3[1]);
                                }
                                catch (NumberFormatException ex) {
                                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Enchantment level is incorrect for item " + key + " in menu " + name + "!");
                                }
                                enchants.put(enc, level);
                                continue;
                            }
                            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Enchantment " + parts3[0] + " for item " + key + " in menu " + name + " is not a valid enchantment name!");
                            continue;
                        }
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Enchantment format is incorrect for item " + key + " in GUI " + name + "!", "Correct format: - '<Enchantment name>;<level>");
                        continue;
                    }
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Enchantment format is incorrect for item " + key + " in GUI " + name + "!", "Correct format: - '<Enchantment name>;<level>");
                }
                if (!enchants.isEmpty()) {
                    menuItem.setEnchantments(enchants);
                }
            }
            if (c.contains(currentPath + "view_requirement")) {
                menuItem.setViewRequirements(this.getRequirements(c, currentPath + "view_requirement"));
            }
            if (c.contains(currentPath + "click_commands")) {
                menuItem.setClickHandler(this.getClickHandler(c, currentPath + "click_commands"));
                if (c.contains(currentPath + "click_requirement")) {
                    menuItem.setClickRequirements(this.getRequirements(c, currentPath + "click_requirement"));
                }
            }
            if (c.contains(currentPath + "left_click_commands")) {
                menuItem.setLeftClickHandler(this.getClickHandler(c, currentPath + "left_click_commands"));
                if (c.contains(currentPath + "left_click_requirement")) {
                    menuItem.setLeftClickRequirements(this.getRequirements(c, currentPath + "left_click_requirement"));
                }
            }
            if (c.contains(currentPath + "right_click_commands")) {
                menuItem.setRightClickHandler(this.getClickHandler(c, currentPath + "right_click_commands"));
                if (c.contains(currentPath + "right_click_requirement")) {
                    menuItem.setRightClickRequirements(this.getRequirements(c, currentPath + "right_click_requirement"));
                }
            }
            if (c.contains(currentPath + "shift_left_click_commands")) {
                menuItem.setShiftLeftClickHandler(this.getClickHandler(c, currentPath + "shift_left_click_commands"));
                if (c.contains(currentPath + "shift_left_click_requirement")) {
                    menuItem.setShiftLeftClickRequirements(this.getRequirements(c, currentPath + "shift_left_click_requirement"));
                }
            }
            if (c.contains(currentPath + "shift_right_click_commands")) {
                menuItem.setShiftRightClickHandler(this.getClickHandler(c, currentPath + "shift_right_click_commands"));
                if (c.contains(currentPath + "shift_right_click_requirement")) {
                    menuItem.setShiftRightClickRequirements(this.getRequirements(c, currentPath + "shift_right_click_requirement"));
                }
            }
            if (c.contains(currentPath + "middle_click_commands")) {
                menuItem.setMiddleClickHandler(this.getClickHandler(c, currentPath + "middle_click_commands"));
                if (c.contains(currentPath + "middle_click_requirement")) {
                    menuItem.setMiddleClickRequirements(this.getRequirements(c, currentPath + "middle_click_requirement"));
                }
            }
            ArrayList<Integer> slots = new ArrayList<Integer>();
            if (c.contains(currentPath + "slots") && c.isList(currentPath + "slots")) {
                List confSlots = c.getStringList(currentPath + "slots");
                e3 = confSlots.iterator();
                while (e3.hasNext()) {
                    String slot = (String)e3.next();
                    String[] values = slot.split("-", 2);
                    if (values.length == 2) {
                        for (int i = Integer.parseInt(values[0]); i <= Integer.parseInt(values[1]); ++i) {
                            slots.add(i);
                        }
                        continue;
                    }
                    slots.add(Integer.parseInt(slot));
                }
            } else {
                slots.add(c.getInt(currentPath + "slot", 0));
            }
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                TreeMap slotPriorityMap;
                int slot = (Integer)iterator.next();
                if (!menuItems.containsKey(slot) || menuItems.get(slot) == null) {
                    slotPriorityMap = new TreeMap();
                    menuItems.put(slot, slotPriorityMap);
                } else {
                    slotPriorityMap = (TreeMap)menuItems.get(slot);
                }
                MenuItem clone = menuItem.clone();
                clone.setSlot(slot);
                slotPriorityMap.put(menuItem.getPriority(), clone);
            }
        }
        return menuItems;
    }

    /*
     * Unable to fully structure code
     */
    private RequirementList getRequirements(FileConfiguration c, String path) {
        this.debug(new String[]{"requirement path: " + path});
        requirements = new ArrayList<Requirement>();
        if (!c.contains(path + ".requirements")) {
            this.debug(new String[]{"requirements list was not found"});
            return null;
        }
        this.debug(new String[]{"found requirements list"});
        for (String key : c.getConfigurationSection(path + ".requirements").getKeys(false)) {
            this.debug(new String[]{"requirement: " + key + " from requirements list"});
            rPath = path + ".requirements." + key;
            if (!c.contains(rPath + ".type")) {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"No type set for requirement: " + key + " for path: " + rPath});
                continue;
            }
            type = RequirementType.getType(c.getString(rPath + ".type"));
            if (type == null) {
                DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Requirement type at path: " + rPath + " is not a valid requirement type!"});
                continue;
            }
            this.debug(new String[]{"Requirement type: " + type.name()});
            req = null;
            switch (2.$SwitchMap$com$extendedclip$deluxemenus$requirement$RequirementType[type.ordinal()]) {
                case 1: 
                case 2: {
                    wrapper = new ItemWrapper();
                    if (!c.contains(rPath + ".material")) ** GOTO lbl31
                    try {
                        if (DeluxeMenusConfig.containsPlaceholders(c.getString(rPath + ".material"))) ** GOTO lbl33
                        Material.valueOf((String)c.getString(rPath + ".material").toUpperCase());
                        ** GOTO lbl33
                    }
                    catch (Exception ex) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"has item requirement at path: " + rPath + " does not specify a valid Material name!"});
                        break;
                    }
lbl31:
                    // 1 sources

                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"has item requirement at path: " + rPath + " does not contain a material: entry!"});
                    break;
lbl33:
                    // 2 sources

                    wrapper.setMaterial(c.getString(rPath + ".material"));
                    wrapper.setAmount(c.getInt(rPath + ".amount", 1));
                    wrapper.hasData(c.contains(rPath + ".data") != false && c.isInt(rPath + ".data") != false);
                    wrapper.setData((short)c.getInt(rPath + ".data", 0));
                    if (c.isString(rPath + ".name")) {
                        wrapper.setName(c.getString(rPath + ".name"));
                    }
                    if (c.isString(rPath + ".lore")) {
                        wrapper.setLore(c.getString(rPath + ".lore"));
                    }
                    if (c.isList(rPath + ".lore")) {
                        wrapper.setLoreList(c.getStringList(rPath + ".lore"));
                    }
                    wrapper.setStrict(c.getBoolean(rPath + ".strict", false));
                    wrapper.setArmor(c.getBoolean(rPath + ".armor", false));
                    wrapper.setOffhand(c.getBoolean(rPath + ".offhand", false));
                    if (c.contains(rPath + ".model_data") && c.isInt(rPath + ".model_data")) {
                        wrapper.setCustomData(c.getInt(rPath + ".model_data"));
                    } else {
                        wrapper.setCustomData(c.getInt(rPath + ".modeldata", 0));
                    }
                    if (c.contains(rPath + ".name_contains")) {
                        wrapper.setNameContains(c.getBoolean(rPath + ".name_contains"));
                    } else {
                        wrapper.setNameContains(c.getBoolean(rPath + ".name-contains", false));
                    }
                    if (c.contains(rPath + ".name_ignorecase")) {
                        wrapper.setNameContains(c.getBoolean(rPath + ".name_ignorecase"));
                    } else {
                        wrapper.setNameContains(c.getBoolean(rPath + ".name-ignorecase", false));
                    }
                    if (c.contains(rPath + ".lore_contains")) {
                        wrapper.setLoreContains(c.getBoolean(rPath + ".lore_contains"));
                    } else {
                        wrapper.setLoreContains(c.getBoolean(rPath + ".lore-contains", false));
                    }
                    if (c.contains(rPath + ".lore_ignorecase")) {
                        wrapper.setLoreContains(c.getBoolean(rPath + ".lore_ignorecase"));
                    } else {
                        wrapper.setLoreContains(c.getBoolean(rPath + ".lore-ignorecase", false));
                    }
                    invert = type == RequirementType.DOES_NOT_HAVE_ITEM;
                    req = new HasItemRequirement(wrapper, invert);
                    break;
                }
                case 3: 
                case 4: {
                    if (c.contains(rPath + ".permission")) {
                        invert = type == RequirementType.DOES_NOT_HAVE_PERMISSION;
                        req = new HasPermissionRequirement(c.getString(rPath + ".permission"), invert);
                        break;
                    }
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Permission requirement at path: " + rPath + " does not contain a permission: entry"});
                    break;
                }
                case 5: {
                    if (c.contains(rPath + ".expression")) {
                        req = new JavascriptRequirement(c.getString(rPath + ".expression"));
                        break;
                    }
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Javascript requirement at path: " + rPath + " does not contain an expression: entry"});
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    if (c.contains(rPath + ".input") && c.contains(rPath + ".output")) {
                        req = new InputResultRequirement(type, c.getString(rPath + ".input"), c.getString(rPath + ".output"));
                        break;
                    }
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Requirement at path: " + rPath + " does not contain the input: and/or the output: entries"});
                    break;
                }
                case 17: 
                case 18: {
                    if (c.contains(rPath + ".amount") || c.contains(rPath + ".placeholder")) {
                        invert = type == RequirementType.DOES_NOT_HAVE_MONEY;
                        req = new HasMoneyRequirement(c.getDouble(rPath + ".amount"), invert, c.getString(rPath + ".placeholder", null));
                        break;
                    }
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Money requirement at path: " + rPath + " does not contain an amount: entry"});
                    break;
                }
                case 19: 
                case 20: {
                    if (c.contains(rPath + ".amount")) {
                        if (!DeluxeMenusConfig.containsPlaceholders(c.getString(rPath + ".amount")) && !c.isInt(rPath + ".amount")) {
                            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Value at path: " + rPath + ".amount is not a placeholder or a number"});
                            break;
                        }
                        invert = type == RequirementType.DOES_NOT_HAVE_EXP;
                        req = new HasExpRequirement(c.getString(rPath + ".amount"), invert, c.getBoolean(rPath + ".level"));
                        break;
                    }
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Exp requirement at path: " + rPath + " does not contain an amount: entry"});
                    break;
                }
                case 21: 
                case 22: {
                    if (c.contains(rPath + ".input") && c.contains(rPath + ".regex")) {
                        p = java.util.regex.Pattern.compile(c.getString(rPath + ".regex"));
                        invert = type == RequirementType.REGEX_DOES_NOT_MATCH;
                        req = new RegexMatchesRequirement(p, c.getString(rPath + ".input"), invert);
                        break;
                    }
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Regex requirement at path: " + rPath + " does not contain a input: or regex: entry"});
                    break;
                }
                case 23: 
                case 24: {
                    if (c.contains(rPath + ".location") && c.contains(rPath + ".distance")) {
                        invert = type == RequirementType.IS_NOT_NEAR;
                        loc = LocationUtils.deserializeLocation(c.getString(rPath + ".location"));
                        if (loc == null) {
                            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"requirement at path: " + rPath + " has an invalid location. Valid Format is: <world>,<x>,<y>,<z>"});
                        }
                        req = new IsNearRequirement(loc, c.getInt(rPath + ".distance"), invert);
                        break;
                    }
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Is Near requirement at path: " + rPath + " does not contain a location: or distance: entry"});
                    break;
                }
                case 25: 
                case 26: {
                    if (!VersionHelper.IS_PDC_VERSION) {
                        DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Meta requirement is not available for your server version!"});
                        break;
                    }
                    if (c.contains(rPath + ".key") && c.contains(rPath + ".meta_type") && c.contains(rPath + ".value")) {
                        metaKey = c.getString(rPath + ".key");
                        invert = type == RequirementType.DOES_NOT_HAVE_META;
                        req = new HasMetaRequirement(metaKey, c.getString(rPath + ".meta_type").toUpperCase(), c.getString(rPath + ".value"), invert);
                        break;
                    }
                    DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Meta requirement at path: " + rPath + " does not contain the key:, meta_type: and/or value: entries!"});
                    break;
                }
            }
            if (req == null) continue;
            requirementSuccessHandler = null;
            requirementDenyHandler = null;
            if (c.contains(rPath + ".success_commands")) {
                this.debug(new String[]{"Requirement has success commands"});
                requirementSuccessHandler = this.getClickHandler(c, rPath + ".success_commands");
            }
            if (c.contains(rPath + ".deny_commands")) {
                this.debug(new String[]{"Requirement has deny commands"});
                requirementDenyHandler = this.getClickHandler(c, rPath + ".deny_commands");
            }
            req.setOptional(c.getBoolean(rPath + ".optional", false));
            req.setSuccessHandler(requirementSuccessHandler);
            req.setDenyHandler(requirementDenyHandler);
            requirements.add(req);
        }
        if (requirements.isEmpty()) {
            return null;
        }
        list = new RequirementList(requirements);
        if (c.contains(path + ".deny_commands")) {
            this.debug(new String[]{"global deny handler found"});
            list.setDenyHandler(this.getClickHandler(c, path + ".deny_commands"));
        }
        list.setStopAtSuccess(c.getBoolean(path + ".stop_at_success", false));
        if (c.contains(path + ".minimum_requirements")) {
            list.setMinimumRequirements(c.getInt(path + ".minimum_requirements"));
        } else {
            required = 0;
            for (Requirement req : requirements) {
                if (req.isOptional()) continue;
                required = required++;
            }
            list.setMinimumRequirements(required);
        }
        return list;
    }

    private ClickHandler getClickHandler(FileConfiguration c, String configPath) {
        List commands = c.getStringList(configPath);
        if (commands == null || commands.isEmpty()) {
            return null;
        }
        final ArrayList<ClickAction> actions = new ArrayList<ClickAction>();
        for (String command : commands) {
            Matcher ch;
            ActionType type;
            if (command == null || command.isEmpty() || (type = ActionType.getByStart(command)) == null) continue;
            if ((command = command.replaceFirst(java.util.regex.Pattern.quote(type.getIdentifier()), "")).startsWith(" ")) {
                command = command.trim();
            }
            ClickAction action = new ClickAction(type, command);
            Matcher d = DELAY_MATCHER.matcher(command);
            if (d.find()) {
                action.setDelay(d.group(1));
                command = command.replaceFirst(java.util.regex.Pattern.quote(d.group()), "");
            }
            if ((ch = CHANCE_MATCHER.matcher(command)).find()) {
                action.setChance(ch.group(1));
                command = command.replaceFirst(java.util.regex.Pattern.quote(ch.group()), "");
            }
            action.setExecutable(command);
            actions.add(action);
        }
        ClickHandler handler = null;
        if (!actions.isEmpty()) {
            handler = new ClickHandler(){

                @Override
                public void onClick(@NotNull MenuHolder holder) {
                    for (ClickAction action : actions) {
                        if (!action.checkChance(holder)) continue;
                        if (action.hasDelay()) {
                            new ClickActionTask(DeluxeMenusConfig.this.plugin, holder.getViewer().getName(), action.getType(), holder.setArguments(action.getExecutable())).runTaskLater((Plugin)DeluxeMenusConfig.this.plugin, action.getDelay(holder));
                            continue;
                        }
                        new ClickActionTask(DeluxeMenusConfig.this.plugin, holder.getViewer().getName(), action.getType(), holder.setArguments(action.getExecutable())).runTask((Plugin)DeluxeMenusConfig.this.plugin);
                    }
                }
            };
        }
        return handler;
    }

    public void debug(String ... messages) {
        DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, messages);
    }

    @NotNull
    public DebugLevel debugLevel() {
        String stringLevel = this.plugin.getConfig().getString("debug", "HIGHEST");
        if (stringLevel.equalsIgnoreCase("true")) {
            stringLevel = "LOWEST";
            this.plugin.getConfig().set("debug", (Object)"LOWEST");
        } else if (stringLevel.equalsIgnoreCase("false")) {
            stringLevel = "HIGHEST";
            this.plugin.getConfig().set("debug", (Object)"HIGHEST");
        }
        DebugLevel debugLevel = DebugLevel.getByName(stringLevel);
        return debugLevel == null ? DebugLevel.LOW : debugLevel;
    }

    public File getMenuDirector() {
        return this.menuDirectory;
    }
}

