/*
 * Decompiled with CFR 0.152.
 */
package me.main__.util.multiverse.SerializationConfig;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.main__.util.multiverse.SerializationConfig.IllegalPropertyValueException;
import me.main__.util.multiverse.SerializationConfig.Serializor;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

final class DefaultSerializor<T>
implements Serializor<T, Object> {
    private static final Map<Class<?>, Class<?>> primitiveToWrapperMap = new HashMap();

    DefaultSerializor() {
    }

    @Override
    public Object serialize(Object object) {
        if (object instanceof ConfigurationSerializable || object instanceof Iterable) {
            return object;
        }
        return String.valueOf(object);
    }

    @Override
    public T deserialize(Object serialized, Class<T> anothertype) throws IllegalPropertyValueException {
        try {
            if (String.class.isAssignableFrom(anothertype)) {
                return (T)serialized;
            }
            if (ConfigurationSerializable.class.isAssignableFrom(anothertype)) {
                if (serialized instanceof ConfigurationSerializable) {
                    return (T)serialized;
                }
                return (T)ConfigurationSerialization.deserializeObject((Map)((Map)serialized));
            }
            if (Iterable.class.isAssignableFrom(anothertype) && serialized instanceof Iterable) {
                return (T)serialized;
            }
            Class<Object> type = primitiveToWrapperMap.containsKey(anothertype) ? primitiveToWrapperMap.get(anothertype) : anothertype;
            Method valueOf = type.getMethod("valueOf", String.class);
            return (T)valueOf.invoke(null, serialized);
        }
        catch (Exception e) {
            throw new IllegalPropertyValueException(e);
        }
    }

    public static final Map<Class<?>, Class<?>> getPrimitiveToWrapperMap() {
        return Collections.unmodifiableMap(primitiveToWrapperMap);
    }

    static {
        primitiveToWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapperMap.put(Long.TYPE, Long.class);
        primitiveToWrapperMap.put(Double.TYPE, Double.class);
        primitiveToWrapperMap.put(Float.TYPE, Float.class);
        primitiveToWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveToWrapperMap.put(Short.TYPE, Short.class);
    }
}

