/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.api.BlockSafety;
import com.onarandombox.MultiverseCore.api.Core;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.material.Bed;

public class SimpleBlockSafety
implements BlockSafety {
    private final Core plugin;
    private static final Set<BlockFace> AROUND_BLOCK = EnumSet.noneOf(BlockFace.class);

    public SimpleBlockSafety(Core plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isBlockAboveAir(Location l) {
        Location downOne = l.clone();
        downOne.setY(downOne.getY() - 1.0);
        return downOne.getBlock().getType() == Material.AIR;
    }

    @Override
    public boolean playerCanSpawnHereSafely(World world, double x, double y, double z) {
        Location l = new Location(world, x, y, z);
        return this.playerCanSpawnHereSafely(l);
    }

    @Override
    public boolean playerCanSpawnHereSafely(Location l) {
        if (l == null) {
            return false;
        }
        World world = l.getWorld();
        Location actual = l.clone();
        Location upOne = l.clone();
        Location downOne = l.clone();
        upOne.setY(upOne.getY() + 1.0);
        downOne.setY(downOne.getY() - 1.0);
        if (SimpleBlockSafety.isSolidBlock(world.getBlockAt(actual).getType()) || SimpleBlockSafety.isSolidBlock(upOne.getBlock().getType())) {
            CoreLogging.finer("Error Here (Actual)? (%s)[%s]", actual.getBlock().getType(), SimpleBlockSafety.isSolidBlock(actual.getBlock().getType()));
            CoreLogging.finer("Error Here (upOne)? (%s)[%s]", upOne.getBlock().getType(), SimpleBlockSafety.isSolidBlock(upOne.getBlock().getType()));
            return false;
        }
        if (downOne.getBlock().getType() == Material.LAVA || downOne.getBlock().getType() == Material.STATIONARY_LAVA) {
            CoreLogging.finer("Error Here (downOne)? (%s)[%s]", downOne.getBlock().getType(), SimpleBlockSafety.isSolidBlock(downOne.getBlock().getType()));
            return false;
        }
        if (downOne.getBlock().getType() == Material.FIRE) {
            CoreLogging.finer("There's fire below! (%s)[%s]", actual.getBlock().getType(), SimpleBlockSafety.isSolidBlock(actual.getBlock().getType()));
            return false;
        }
        if (this.isBlockAboveAir(actual)) {
            CoreLogging.finer("Is block above air [%s]", this.isBlockAboveAir(actual));
            CoreLogging.finer("Has 2 blocks of water below [%s]", this.hasTwoBlocksofWaterBelow(actual));
            return this.hasTwoBlocksofWaterBelow(actual);
        }
        return true;
    }

    @Override
    public Location getSafeBedSpawn(Location l) {
        if (l == null) {
            return null;
        }
        Location trySpawn = this.getSafeSpawnAroundABlock(l);
        if (trySpawn != null) {
            return trySpawn;
        }
        Location otherBlock = this.findOtherBedPiece(l);
        if (otherBlock == null) {
            return null;
        }
        return this.getSafeSpawnAroundABlock(otherBlock);
    }

    private Location getSafeSpawnAroundABlock(Location l) {
        for (BlockFace face : AROUND_BLOCK) {
            if (!this.playerCanSpawnHereSafely(l.getBlock().getRelative(face).getLocation())) continue;
            return l.getBlock().getRelative(face).getLocation().add(0.5, 0.0, 0.5);
        }
        return null;
    }

    private Location findOtherBedPiece(Location checkLoc) {
        if (checkLoc.getBlock().getType() != Material.BED_BLOCK) {
            return null;
        }
        Bed b = new Bed(Material.BED_BLOCK, checkLoc.getBlock().getData());
        if (b.isHeadOfBed()) {
            return checkLoc.getBlock().getRelative(b.getFacing().getOppositeFace()).getLocation();
        }
        return checkLoc.getBlock().getRelative(b.getFacing()).getLocation();
    }

    @Override
    public Location getTopBlock(Location l) {
        Location check = l.clone();
        check.setY(127.0);
        while (check.getY() > 0.0) {
            if (this.playerCanSpawnHereSafely(check)) {
                return check;
            }
            check.setY(check.getY() - 1.0);
        }
        return null;
    }

    @Override
    public Location getBottomBlock(Location l) {
        Location check = l.clone();
        check.setY(0.0);
        while (check.getY() < 127.0) {
            if (this.playerCanSpawnHereSafely(check)) {
                return check;
            }
            check.setY(check.getY() + 1.0);
        }
        return null;
    }

    private static boolean isSolidBlock(Material type) {
        switch (type) {
            case AIR: {
                return false;
            }
            case SNOW: {
                return false;
            }
            case TRAP_DOOR: {
                return false;
            }
            case TORCH: {
                return false;
            }
            case YELLOW_FLOWER: {
                return false;
            }
            case RED_ROSE: {
                return false;
            }
            case RED_MUSHROOM: {
                return false;
            }
            case BROWN_MUSHROOM: {
                return false;
            }
            case REDSTONE: {
                return false;
            }
            case REDSTONE_WIRE: {
                return false;
            }
            case RAILS: {
                return false;
            }
            case POWERED_RAIL: {
                return false;
            }
            case REDSTONE_TORCH_ON: {
                return false;
            }
            case REDSTONE_TORCH_OFF: {
                return false;
            }
            case DEAD_BUSH: {
                return false;
            }
            case SAPLING: {
                return false;
            }
            case STONE_BUTTON: {
                return false;
            }
            case LEVER: {
                return false;
            }
            case LONG_GRASS: {
                return false;
            }
            case PORTAL: {
                return false;
            }
            case STONE_PLATE: {
                return false;
            }
            case WOOD_PLATE: {
                return false;
            }
            case SEEDS: {
                return false;
            }
            case SUGAR_CANE_BLOCK: {
                return false;
            }
            case WALL_SIGN: {
                return false;
            }
            case SIGN_POST: {
                return false;
            }
            case WOODEN_DOOR: {
                return false;
            }
            case STATIONARY_WATER: {
                return false;
            }
            case WATER: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEntitiyOnTrack(Location l) {
        Material currentBlock = l.getBlock().getType();
        return currentBlock == Material.POWERED_RAIL || currentBlock == Material.DETECTOR_RAIL || currentBlock == Material.RAILS;
    }

    private boolean hasTwoBlocksofWaterBelow(Location l) {
        if (l.getBlockY() < 0) {
            return false;
        }
        Location oneBelow = l.clone();
        oneBelow.subtract(0.0, 1.0, 0.0);
        if (oneBelow.getBlock().getType() == Material.WATER || oneBelow.getBlock().getType() == Material.STATIONARY_WATER) {
            Location twoBelow = oneBelow.clone();
            twoBelow.subtract(0.0, 1.0, 0.0);
            return oneBelow.getBlock().getType() == Material.WATER || oneBelow.getBlock().getType() == Material.STATIONARY_WATER;
        }
        if (oneBelow.getBlock().getType() != Material.AIR) {
            return false;
        }
        return this.hasTwoBlocksofWaterBelow(oneBelow);
    }

    @Override
    public boolean canSpawnCartSafely(Minecart cart) {
        if (this.isBlockAboveAir(cart.getLocation())) {
            return true;
        }
        return this.isEntitiyOnTrack(this.plugin.getLocationManipulation().getNextBlock((Vehicle)cart));
    }

    @Override
    public boolean canSpawnVehicleSafely(Vehicle vehicle) {
        return this.isBlockAboveAir(vehicle.getLocation());
    }

    static {
        AROUND_BLOCK.add(BlockFace.NORTH);
        AROUND_BLOCK.add(BlockFace.NORTH_EAST);
        AROUND_BLOCK.add(BlockFace.EAST);
        AROUND_BLOCK.add(BlockFace.SOUTH_EAST);
        AROUND_BLOCK.add(BlockFace.SOUTH);
        AROUND_BLOCK.add(BlockFace.SOUTH_WEST);
        AROUND_BLOCK.add(BlockFace.WEST);
        AROUND_BLOCK.add(BlockFace.NORTH_WEST);
    }
}

