/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.listeners;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class MVWorldListener
implements Listener {
    private MultiverseCore plugin;
    private MVWorldManager worldManager;

    public MVWorldListener(MultiverseCore plugin) {
        this.plugin = plugin;
        this.worldManager = plugin.getMVWorldManager();
    }

    @EventHandler
    public void unloadWorld(WorldUnloadEvent event) {
        World world;
        if (event.isCancelled()) {
            return;
        }
        if (event.getWorld() instanceof World && (world = event.getWorld()) != null) {
            this.plugin.getMVWorldManager().unloadWorld(world.getName(), false);
        }
    }

    @EventHandler
    public void loadWorld(WorldLoadEvent event) {
        World world = event.getWorld();
        if (world != null) {
            MultiverseWorld mvWorld;
            if (this.plugin.getMVWorldManager().getUnloadedWorlds().contains(world.getName())) {
                this.plugin.getMVWorldManager().loadWorld(world.getName());
            }
            if ((mvWorld = this.plugin.getMVWorldManager().getMVWorld(world)) != null) {
                world.setPVP(mvWorld.isPVPEnabled());
                world.setDifficulty(mvWorld.getDifficulty());
            }
        }
    }
}

