/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.destination;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVDestination;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class CannonDestination
implements MVDestination {
    private final String coordRegex = "(-?[\\d]+\\.?[\\d]*),(-?[\\d]+\\.?[\\d]*),(-?[\\d]+\\.?[\\d]*)";
    private boolean isValid;
    private Location location;
    private double speed;
    private static final int SPLIT_SIZE = 6;

    @Override
    public Vector getVelocity() {
        double pitchRadians = Math.toRadians(this.location.getPitch());
        double yawRadians = Math.toRadians(this.location.getYaw());
        double x = Math.sin(yawRadians) * this.speed * -1.0;
        double y = Math.sin(pitchRadians) * this.speed * -1.0;
        double z = Math.cos(yawRadians) * this.speed;
        x = Math.cos(pitchRadians) * x;
        z = Math.cos(pitchRadians) * z;
        return new Vector(x, y, z);
    }

    @Override
    public String getIdentifier() {
        return "ca";
    }

    @Override
    public boolean isThisType(JavaPlugin plugin, String destination) {
        if (!(plugin instanceof MultiverseCore)) {
            return false;
        }
        List<String> parsed = Arrays.asList(destination.split(":"));
        if (parsed.size() != 6) {
            return false;
        }
        if (!parsed.get(0).equalsIgnoreCase("ca")) {
            return false;
        }
        if (!((MultiverseCore)plugin).getMVWorldManager().isMVWorld(parsed.get(1))) {
            return false;
        }
        if (!parsed.get(2).matches("(-?[\\d]+\\.?[\\d]*),(-?[\\d]+\\.?[\\d]*),(-?[\\d]+\\.?[\\d]*)")) {
            return false;
        }
        try {
            Float.parseFloat(parsed.get(3));
            Float.parseFloat(parsed.get(4));
            Float.parseFloat(parsed.get(5));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public Location getLocation(Entity e) {
        return this.location;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setDestination(JavaPlugin plugin, String destination) {
        if (!(plugin instanceof MultiverseCore)) {
            return;
        }
        List<String> parsed = Arrays.asList(destination.split(":"));
        if (parsed.size() != 6) {
            this.isValid = false;
            return;
        }
        if (!parsed.get(0).equalsIgnoreCase(this.getIdentifier())) {
            this.isValid = false;
            return;
        }
        if (!((MultiverseCore)plugin).getMVWorldManager().isMVWorld(parsed.get(1))) {
            this.isValid = false;
            return;
        }
        this.location = new Location(((MultiverseCore)plugin).getMVWorldManager().getMVWorld(parsed.get(1)).getCBWorld(), 0.0, 0.0, 0.0);
        if (!parsed.get(2).matches(this.coordRegex)) {
            this.isValid = false;
            return;
        }
        double[] coords = new double[3];
        String[] coordString = parsed.get(2).split(",");
        for (int i = 0; i < 3; ++i) {
            try {
                coords[i] = Double.parseDouble(coordString[i]);
                continue;
            }
            catch (NumberFormatException e) {
                this.isValid = false;
                return;
            }
        }
        this.location.setX(coords[0]);
        this.location.setY(coords[1]);
        this.location.setZ(coords[2]);
        try {
            this.location.setPitch(Float.parseFloat(parsed.get(3)));
            this.location.setYaw(Float.parseFloat(parsed.get(4)));
            this.speed = Math.abs(Float.parseFloat(parsed.get(5)));
        }
        catch (NumberFormatException e) {
            this.isValid = false;
            return;
        }
        this.isValid = true;
    }

    @Override
    public String getType() {
        return "Cannon!";
    }

    @Override
    public String getName() {
        return "Cannon (" + this.location.getX() + ", " + this.location.getY() + ", " + this.location.getZ() + ":" + this.location.getPitch() + ":" + this.location.getYaw() + ":" + this.speed + ")";
    }

    public void setDestination(Location location, double speed) {
        if (location != null) {
            this.location = location;
            this.speed = Math.abs(speed);
            this.isValid = true;
        }
        this.isValid = false;
    }

    @Override
    public String getRequiredPermission() {
        return "multiverse.access." + this.location.getWorld().getName();
    }

    @Override
    public boolean useSafeTeleporter() {
        return false;
    }

    @Override
    public String toString() {
        if (this.isValid) {
            return "ca:" + this.location.getWorld().getName() + ":" + this.location.getX() + "," + this.location.getY() + "," + this.location.getZ() + ":" + this.location.getPitch() + ":" + this.location.getYaw() + ":" + this.speed;
        }
        return "i:Invalid Destination";
    }
}

