/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.teams;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import kernitus.plugin.OldCombatMechanics.utilities.packet.team.TeamPacket;
import kernitus.plugin.OldCombatMechanics.utilities.teams.CollisionRule;
import kernitus.plugin.OldCombatMechanics.utilities.teams.TeamAction;
import org.bukkit.entity.Player;

public class TeamUtils {
    private static final AtomicInteger TEAM_NAME_COUNTER = new AtomicInteger();

    public static boolean targetsPlayer(TeamPacket packet, Player player) {
        return packet.getPlayerNames().contains(player.getName());
    }

    public static TeamPacket craftTeamCreatePacket(Player player, CollisionRule collisionRule) {
        String teamName = "OCM-" + TEAM_NAME_COUNTER.getAndIncrement() + "";
        return TeamPacket.create(TeamAction.CREATE, collisionRule, teamName, Collections.singletonList(player));
    }

    public static boolean isOcmTeam(TeamPacket team) {
        return team.getName().startsWith("OCM-");
    }

    public static void disband(String teamName, Player player) {
        TeamPacket packet = TeamPacket.create(TeamAction.DISBAND, CollisionRule.NEVER, teamName, Collections.singletonList(player));
        packet.send(player);
    }
}

