/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.type.ClassType;
import org.bukkit.Bukkit;

public class Reflector {
    private static String version;
    private static int majorVersion;
    private static int minorVersion;
    private static int patchVersion;
    private static final Function<Method, List<String>> getParameterNames;

    public static String getVersion() {
        return version;
    }

    public static boolean versionIsNewerOrEqualAs(int major, int minor, int patch) {
        if (Reflector.getMajorVersion() < major) {
            return false;
        }
        if (Reflector.getMinorVersion() < minor) {
            return false;
        }
        return Reflector.getPatchVersion() >= patch;
    }

    private static int getMajorVersion() {
        return majorVersion;
    }

    private static int getMinorVersion() {
        return minorVersion;
    }

    private static int getPatchVersion() {
        return patchVersion;
    }

    public static Class<?> getClass(ClassType type, String name) {
        return Reflector.getClass(type.qualifyClassName(name));
    }

    public static Class<?> getClass(String fqn) {
        try {
            return Class.forName(fqn);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Couldn't load class " + fqn, e);
        }
    }

    public static Method getMethod(Class<?> clazz, String name) {
        return Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals(name)).findFirst().orElse(null);
    }

    public static Method getMethod(Class<?> clazz, String name, int parameterCount) {
        return Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals(name) && method.getParameterCount() == parameterCount).findFirst().orElse(null);
    }

    public static Method getMethod(Class<?> clazz, Class<?> returnType, String ... parameterTypeSimpleNames) {
        List<String> typeNames = Arrays.asList(parameterTypeSimpleNames);
        return Arrays.stream(clazz.getMethods()).filter(method -> method.getReturnType() == returnType).filter(it -> getParameterNames.apply((Method)it).equals(typeNames)).findFirst().orElse(null);
    }

    public static Method getMethod(Class<?> clazz, String name, String ... parameterTypeSimpleNames) {
        List<String> typeNames = Arrays.asList(parameterTypeSimpleNames);
        return Stream.concat(Arrays.stream(clazz.getDeclaredMethods()), Arrays.stream(clazz.getMethods())).filter(it -> it.getName().equals(name)).filter(it -> getParameterNames.apply((Method)it).equals(typeNames)).peek(it -> it.setAccessible(true)).findFirst().orElse(null);
    }

    public static Method getMethodByGenericReturnType(TypeVariable<?> typeVar, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!method.getGenericReturnType().getTypeName().equals(typeVar.getName())) continue;
            return method;
        }
        throw new RuntimeException("Method with type " + typeVar + " not found");
    }

    public static <T> T invokeMethod(Method method, Object handle, Object ... params) {
        try {
            Object t = method.invoke(handle, params);
            return (T)t;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, U, R> BiFunction<T, U, R> memoiseMethodInvocation(Class<T> clazz, String name, String ... argTypes) {
        Method method = Reflector.getMethod(clazz, name, argTypes);
        return (t, u) -> {
            if (u instanceof Object[] && ((Object[])u).length == 0) {
                return Reflector.invokeMethod(method, t, new Object[0]);
            }
            return Reflector.invokeMethod(method, t, u);
        };
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getFieldByType(Class<?> clazz, String simpleClassName) {
        for (Field declaredField : clazz.getDeclaredFields()) {
            if (!declaredField.getType().getSimpleName().equals(simpleClassName)) continue;
            declaredField.setAccessible(true);
            return declaredField;
        }
        throw new RuntimeException("Field with type " + simpleClassName + " not found");
    }

    public static Field getInaccessibleField(Class<?> clazz, String fieldName) {
        Field field = Reflector.getField(clazz, fieldName);
        field.setAccessible(true);
        return field;
    }

    public static Object getDeclaredFieldValueByType(Object object, String simpleClassName) throws Exception {
        for (Field declaredField : object.getClass().getDeclaredFields()) {
            if (!declaredField.getType().getSimpleName().equals(simpleClassName)) continue;
            declaredField.setAccessible(true);
            return declaredField.get(object);
        }
        throw new NoSuchFieldException("Couldn't find field with type " + simpleClassName + " in " + object.getClass());
    }

    public static Object getFieldValue(Field field, Object handle) {
        field.setAccessible(true);
        try {
            return field.get(handle);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Field field, Object handle, Object value) {
        field.setAccessible(true);
        try {
            field.set(handle, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Constructor<?> getConstructor(Class<?> clazz, int numParams) {
        return Stream.concat(Arrays.stream(clazz.getDeclaredConstructors()), Arrays.stream(clazz.getConstructors())).filter(constructor -> constructor.getParameterCount() == numParams).peek(it -> it.setAccessible(true)).findFirst().orElse(null);
    }

    public static Constructor<?> getConstructor(Class<?> clazz, String ... parameterTypeSimpleNames) {
        Function<Constructor, List> getParameterNames = constructor -> Arrays.stream(constructor.getParameters()).map(Parameter::getType).map(Class::getSimpleName).collect(Collectors.toList());
        List<String> typeNames = Arrays.asList(parameterTypeSimpleNames);
        return Stream.concat(Arrays.stream(clazz.getDeclaredConstructors()), Arrays.stream(clazz.getConstructors())).filter(constructor -> ((List)getParameterNames.apply((Constructor)constructor)).equals(typeNames)).peek(it -> it.setAccessible(true)).findFirst().orElse(null);
    }

    public static boolean inheritsFrom(Class<?> toCheck, Class<?> inheritedClass) {
        if (inheritedClass.isAssignableFrom(toCheck)) {
            return true;
        }
        for (Class<?> implementedInterface : toCheck.getInterfaces()) {
            if (!Reflector.inheritsFrom(implementedInterface, inheritedClass)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getUnchecked(UncheckedReflectionSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void doUnchecked(UncheckedReflectionRunnable runnable) {
        try {
            runnable.run();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            version = Bukkit.getServer().getClass().getName().split("\\.")[3];
            String[] splitVersion = Reflector.getVersion().replaceAll("[^\\d_]", "").split("_");
            majorVersion = Integer.parseInt(splitVersion[0]);
            minorVersion = Integer.parseInt(splitVersion[1]);
            patchVersion = splitVersion.length < 3 ? 0 : Integer.parseInt(splitVersion[2]);
        }
        catch (Exception e) {
            System.err.println("Failed to load Reflector");
            e.printStackTrace();
        }
        getParameterNames = method -> Arrays.stream(method.getParameters()).map(Parameter::getType).map(Class::getSimpleName).collect(Collectors.toList());
    }

    public static interface UncheckedReflectionRunnable {
        public void run() throws ReflectiveOperationException;
    }

    public static interface UncheckedReflectionSupplier<T> {
        public T get() throws ReflectiveOperationException;
    }
}

