/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.packet.team;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.utilities.packet.PacketHelper;
import kernitus.plugin.OldCombatMechanics.utilities.packet.team.TeamPacket;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.type.ClassType;
import kernitus.plugin.OldCombatMechanics.utilities.teams.CollisionRule;
import kernitus.plugin.OldCombatMechanics.utilities.teams.TeamAction;
import org.bukkit.entity.Player;

public class V17TeamPacket
extends TeamPacket {
    protected V17TeamPacket(Object nmsPacket) {
        super(nmsPacket);
    }

    @Override
    public TeamPacket withCollisionRule(CollisionRule collisionRule) {
        return new V17TeamPacket(PacketAccess.setCollisionRule(this.getNmsPacket(), collisionRule));
    }

    @Override
    public Collection<String> getPlayerNames() {
        return PacketAccess.getPlayerNames(this.getNmsPacket());
    }

    @Override
    public TeamPacket withAction(TeamAction action) {
        return new V17TeamPacket(PacketAccess.setAction(this.getNmsPacket(), action));
    }

    @Override
    public TeamAction getAction() {
        return PacketAccess.getAction(this.getNmsPacket());
    }

    @Override
    public String getName() {
        return PacketAccess.getName(this.getNmsPacket());
    }

    public static TeamPacket create(TeamAction action, CollisionRule collisionRule, String name, Collection<Player> players) {
        return new V17TeamPacket(PacketAccess.createTeamPacket(action, collisionRule, name, players));
    }

    private static class OptionalDataClassHelper {
        private static final Class<?> PACKET_CLASS = PacketHelper.getPacketClass(PacketHelper.PacketType.PlayOut, "ScoreboardTeam");
        private static final Class<?> DATA_CLASS = Reflector.getClass(PACKET_CLASS.getName() + "$b");
        private static final Class<?> NAME_TAG_VISIBILITY_CLASS = Reflector.getClass(ClassType.NMS, "world.scores.ScoreboardTeamBase$EnumNameTagVisibility");
        private static final Class<?> TEAM_PUSH_CLASS = Reflector.getClass(ClassType.NMS, "world.scores.ScoreboardTeamBase$EnumTeamPush");
        private static final Method getDisplayName = Reflector.getMethod(DATA_CLASS, "a", 0);
        private static final Method getPackOptionData = Reflector.getMethod(DATA_CLASS, "b", 0);
        private static final Method getNameTagVisibility = Reflector.getMethod(DATA_CLASS, "d", 0);
        private static final Method getCollisionRule = Reflector.getMethod(DATA_CLASS, "e", 0);
        private static final Method getColor = Reflector.getMethod(DATA_CLASS, "c", 0);
        private static final Method getPrefix = Reflector.getMethod(DATA_CLASS, "f", 0);
        private static final Method getSuffix = Reflector.getMethod(DATA_CLASS, "g", 0);
        private static final Method nameTagVisibilityValueOf = Reflector.getMethod(NAME_TAG_VISIBILITY_CLASS, "a", 1);
        private static final Method teamPushValueOf = Reflector.getMethod(TEAM_PUSH_CLASS, "a", 1);

        private OptionalDataClassHelper() {
        }

        static Object getDisplayName(Object dataClass) {
            return Reflector.invokeMethod(getDisplayName, dataClass, new Object[0]);
        }

        static int getPackOptionData(Object dataClass) {
            return (Integer)Reflector.invokeMethod(getPackOptionData, dataClass, new Object[0]);
        }

        static String getNameTagVisibility(Object dataClass) {
            return (String)Reflector.invokeMethod(getNameTagVisibility, dataClass, new Object[0]);
        }

        static String getCollisionRule(Object dataClass) {
            return (String)Reflector.invokeMethod(getCollisionRule, dataClass, new Object[0]);
        }

        static Object getColor(Object dataClass) {
            return Reflector.invokeMethod(getColor, dataClass, new Object[0]);
        }

        static Object getPrefix(Object dataClass) {
            return Reflector.invokeMethod(getPrefix, dataClass, new Object[0]);
        }

        static Object getSuffix(Object dataClass) {
            return Reflector.invokeMethod(getSuffix, dataClass, new Object[0]);
        }

        static Object parseNameTagVisibility(String asString) {
            return Reflector.invokeMethod(nameTagVisibilityValueOf, null, asString);
        }

        static Object parseTeamPush(String asString) {
            return Reflector.invokeMethod(teamPushValueOf, null, asString);
        }
    }

    private static class ScoreboardTeamWither {
        private final Object displayName;
        private final int packOptionData;
        private final String nameTagVisibility;
        private String collisionRule;
        private final Object color;
        private final Object prefix;
        private final Object suffix;

        public ScoreboardTeamWither(Object displayName, int packOptionData, String nameTagVisibility, String collisionRule, Object color, Object prefix, Object suffix) {
            this.displayName = displayName;
            this.packOptionData = packOptionData;
            this.nameTagVisibility = nameTagVisibility;
            this.collisionRule = collisionRule;
            this.color = color;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public ScoreboardTeamWither withCollisionRule(CollisionRule collisionRule) {
            this.collisionRule = collisionRule.getName();
            return this;
        }

        public Object build() {
            Object team = PacketAccess.createScoreboardTeam("ocm-dummy");
            Reflector.invokeMethod(ScoreboardTeamMethods.getInstance().setDisplayName, team, this.displayName);
            Reflector.invokeMethod(ScoreboardTeamMethods.getInstance().setAllowFriendlyFire, team, (this.packOptionData & 1) != 0);
            Reflector.invokeMethod(ScoreboardTeamMethods.getInstance().setCanSeeFriendlyInvisibles, team, (this.packOptionData & 2) != 0);
            Object parsedNameTagVisibility = OptionalDataClassHelper.parseNameTagVisibility(this.nameTagVisibility);
            if (parsedNameTagVisibility != null) {
                Reflector.invokeMethod(ScoreboardTeamMethods.getInstance().setNameTagVisibility, team, parsedNameTagVisibility);
            }
            Reflector.invokeMethod(ScoreboardTeamMethods.getInstance().setCollisionRule, team, OptionalDataClassHelper.parseTeamPush(this.collisionRule));
            Reflector.invokeMethod(ScoreboardTeamMethods.getInstance().setColor, team, this.color);
            Reflector.invokeMethod(ScoreboardTeamMethods.getInstance().setPrefix, team, this.prefix);
            Reflector.invokeMethod(ScoreboardTeamMethods.getInstance().setSuffix, team, this.suffix);
            return team;
        }

        public static ScoreboardTeamWither from(Object dataClass) {
            return new ScoreboardTeamWither(OptionalDataClassHelper.getDisplayName(dataClass), OptionalDataClassHelper.getPackOptionData(dataClass), OptionalDataClassHelper.getNameTagVisibility(dataClass), OptionalDataClassHelper.getCollisionRule(dataClass), OptionalDataClassHelper.getColor(dataClass), OptionalDataClassHelper.getPrefix(dataClass), OptionalDataClassHelper.getSuffix(dataClass));
        }
    }

    private static class ScoreboardTeamMethodsV18
    extends ScoreboardTeamMethods {
        public ScoreboardTeamMethodsV18() {
            this.setDisplayName = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "a", "IChatBaseComponent");
            this.setAllowFriendlyFire = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "a", "boolean");
            this.setCanSeeFriendlyInvisibles = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "b", "boolean");
            this.setNameTagVisibility = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "a", "EnumNameTagVisibility");
            this.setCollisionRule = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "a", "EnumTeamPush");
            this.setColor = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "a", "EnumChatFormat");
            this.setPrefix = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "b", "IChatBaseComponent");
            this.setSuffix = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "c", "IChatBaseComponent");
        }
    }

    private static class ScoreboardTeamMethodsV17
    extends ScoreboardTeamMethods {
        public ScoreboardTeamMethodsV17() {
            this.setDisplayName = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "setDisplayName");
            this.setAllowFriendlyFire = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "setAllowFriendlyFire");
            this.setCanSeeFriendlyInvisibles = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "setCanSeeFriendlyInvisibles");
            this.setNameTagVisibility = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "setNameTagVisibility");
            this.setCollisionRule = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "setCollisionRule");
            this.setColor = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "setColor");
            this.setPrefix = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "setPrefix");
            this.setSuffix = Reflector.getMethod(SCOREBOARD_TEAM_CLASS, "setSuffix");
        }
    }

    private static abstract class ScoreboardTeamMethods {
        protected static final Class<?> SCOREBOARD_TEAM_CLASS = Reflector.getClass(ClassType.NMS, "world.scores.ScoreboardTeam");
        private static final ScoreboardTeamMethods INSTANCE = ScoreboardTeamMethods.selectInstance();
        protected Method setDisplayName;
        protected Method setAllowFriendlyFire;
        protected Method setCanSeeFriendlyInvisibles;
        protected Method setNameTagVisibility;
        protected Method setCollisionRule;
        protected Method setColor;
        protected Method setPrefix;
        protected Method setSuffix;

        private ScoreboardTeamMethods() {
        }

        public static ScoreboardTeamMethods getInstance() {
            return INSTANCE;
        }

        private static ScoreboardTeamMethods selectInstance() {
            if (Reflector.versionIsNewerOrEqualAs(1, 18, 0)) {
                return new ScoreboardTeamMethodsV18();
            }
            return new ScoreboardTeamMethodsV17();
        }
    }

    private static class PacketAccess {
        private static final Field fieldPlayerNames;
        private static final Field fieldAction;
        private static final Field fieldName;
        private static final Field fieldDataOptional;
        private static final Constructor<?> constructorTeamPacket;
        private static final Constructor<?> constructorDataClass;
        private static final Constructor<?> constructorScoreboard;
        private static final Constructor<?> constructorScoreboardTeam;

        private PacketAccess() {
        }

        public static TeamAction getAction(Object packet) {
            return Reflector.getUnchecked(() -> TeamAction.fromId((Integer)fieldAction.get(packet)));
        }

        public static Object setAction(Object packet, TeamAction action) {
            return Reflector.getUnchecked(() -> constructorTeamPacket.newInstance(PacketAccess.getName(packet), action.getMinecraftId(), fieldDataOptional.get(packet), PacketAccess.getPlayerNames(packet)));
        }

        public static String getName(Object packet) {
            return Reflector.getUnchecked(() -> (String)fieldName.get(packet));
        }

        public static Collection<String> getPlayerNames(Object packet) {
            Collection identifiers = Reflector.getUnchecked(() -> (Collection)fieldPlayerNames.get(packet));
            if (identifiers == null) {
                return Collections.emptyList();
            }
            return identifiers;
        }

        public static Object setCollisionRule(Object packet, CollisionRule rule) {
            return Reflector.getUnchecked(() -> {
                Object data;
                Optional structOptional = (Optional)fieldDataOptional.get(packet);
                if (structOptional.isPresent()) {
                    data = constructorDataClass.newInstance(ScoreboardTeamWither.from(structOptional.get()).withCollisionRule(rule).build());
                } else {
                    Object scoreboardTeam = PacketAccess.createScoreboardTeam(PacketAccess.getName(packet));
                    data = constructorDataClass.newInstance(ScoreboardTeamWither.from(constructorDataClass.newInstance(scoreboardTeam)).withCollisionRule(rule).build());
                }
                return constructorTeamPacket.newInstance(PacketAccess.getName(packet), PacketAccess.getAction(packet).getMinecraftId(), Optional.of(data), PacketAccess.getPlayerNames(packet));
            });
        }

        public static Object createTeamPacket(TeamAction action, CollisionRule collisionRule, String name, Collection<Player> players) {
            Object packet = Reflector.getUnchecked(() -> constructorTeamPacket.newInstance(name, action.getMinecraftId(), Optional.empty(), players.stream().map(Player::getName).collect(Collectors.toList())));
            return PacketAccess.setCollisionRule(packet, collisionRule);
        }

        static Object createScoreboardTeam(String name) {
            return Reflector.getUnchecked(() -> {
                Object scoreboard = constructorScoreboard.newInstance(new Object[0]);
                return constructorScoreboardTeam.newInstance(scoreboard, name);
            });
        }

        static {
            Class<?> packetClass = PacketHelper.getPacketClass(PacketHelper.PacketType.PlayOut, "ScoreboardTeam");
            Class<?> dataClass = Reflector.getClass(packetClass.getName() + "$b");
            fieldPlayerNames = Reflector.getInaccessibleField(packetClass, "j");
            fieldAction = Reflector.getInaccessibleField(packetClass, "h");
            fieldName = Reflector.getInaccessibleField(packetClass, "i");
            fieldDataOptional = Reflector.getFieldByType(packetClass, "Optional");
            constructorTeamPacket = Reflector.getConstructor(packetClass, 4);
            Class<?> scoreboardTeamClass = Reflector.getClass(ClassType.NMS, "world.scores.ScoreboardTeam");
            Class<?> scoreboardClass = Reflector.getClass(ClassType.NMS, "world.scores.Scoreboard");
            constructorDataClass = Reflector.getConstructor(dataClass, scoreboardTeamClass.getSimpleName());
            constructorScoreboard = Reflector.getConstructor(scoreboardClass, 0);
            constructorScoreboardTeam = Reflector.getConstructor(scoreboardTeamClass, 2);
        }
    }
}

