/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.packet.sound;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import kernitus.plugin.OldCombatMechanics.utilities.packet.ImmutablePacket;
import kernitus.plugin.OldCombatMechanics.utilities.packet.PacketHelper;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.type.ClassType;

public class SoundPacket
implements ImmutablePacket {
    private static final Class<?> PACKET_CLASS = PacketHelper.getPacketClass(PacketHelper.PacketType.PlayOut, "NamedSoundEffect");
    private static final PacketAccess PACKET_ACCESS = PacketAccess.getAccess();
    private final Object nmsPacket;

    private SoundPacket(ImmutablePacket packet) {
        this.nmsPacket = packet.getNmsPacket();
    }

    public String getSoundName() {
        return PACKET_ACCESS.getSoundName(this.getNmsPacket());
    }

    @Override
    public Object getNmsPacket() {
        return this.nmsPacket;
    }

    public static Optional<SoundPacket> from(ImmutablePacket packet) {
        if (packet.getPacketClass() == PACKET_CLASS) {
            return Optional.of(new SoundPacket(packet));
        }
        return Optional.empty();
    }

    static /* synthetic */ Class access$200() {
        return PACKET_CLASS;
    }

    private static class PacketAccessPreV1_19_3
    implements PacketAccess {
        private static final Class<?> SOUND_EFFECT_CLASS = Reflector.getClass(ClassType.NMS, "sounds.SoundEffect");
        private final Field soundEffectField = Reflector.getFieldByType(SoundPacket.access$200(), "SoundEffect");
        private final Field minecraftKeyField = Reflector.getFieldByType(SOUND_EFFECT_CLASS, "MinecraftKey");

        private PacketAccessPreV1_19_3() {
        }

        @Override
        public String getSoundName(Object packet) {
            Object soundEffect = Reflector.getUnchecked(() -> this.soundEffectField.get(packet));
            Object minecraftLey = Reflector.getUnchecked(() -> this.minecraftKeyField.get(soundEffect));
            return minecraftLey.toString();
        }
    }

    private static class PacketAccessV1_19_3
    implements PacketAccess {
        private static final Class<?> SOUND_EFFECT_CLASS = Reflector.getClass(ClassType.NMS, "sounds.SoundEffect");
        private final Field soundEffectHolderField = Reflector.getFieldByType(SoundPacket.access$200(), "Holder");
        private final Method soundEffectMethod;
        private final Field minecraftKeyField;

        private PacketAccessV1_19_3() {
            Class<?> holderClass = Reflector.getClass(ClassType.NMS, "core.Holder");
            this.soundEffectMethod = Reflector.getMethodByGenericReturnType(holderClass.getTypeParameters()[0], holderClass);
            this.minecraftKeyField = Reflector.getFieldByType(SOUND_EFFECT_CLASS, "MinecraftKey");
        }

        @Override
        public String getSoundName(Object packet) {
            Object holder = Reflector.getUnchecked(() -> this.soundEffectHolderField.get(packet));
            Object soundEffect = Reflector.getUnchecked(() -> this.soundEffectMethod.invoke(holder, new Object[0]));
            Object minecraftLey = Reflector.getUnchecked(() -> this.minecraftKeyField.get(soundEffect));
            return minecraftLey.toString();
        }
    }

    private static interface PacketAccess {
        public String getSoundName(Object var1);

        public static PacketAccess getAccess() {
            try {
                return new PacketAccessPreV1_19_3();
            }
            catch (Throwable igored) {
                try {
                    return new PacketAccessV1_19_3();
                }
                catch (Throwable e) {
                    throw new RuntimeException("Sound packet init failed", e);
                }
            }
        }
    }
}

