/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.packet.mitm;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.packet.PacketHelper;
import kernitus.plugin.OldCombatMechanics.utilities.packet.PacketSender;
import kernitus.plugin.OldCombatMechanics.utilities.packet.mitm.PacketEvent;
import kernitus.plugin.OldCombatMechanics.utilities.packet.mitm.PacketListener;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.entity.Player;

class PacketInjector
extends ChannelDuplexHandler {
    private volatile boolean isClosed;
    private Channel channel;
    private final List<PacketListener> packetListeners = new CopyOnWriteArrayList<PacketListener>();
    private final WeakReference<Player> playerWeakReference;
    private boolean detectedNonNMSPacket = false;

    PacketInjector(Player player) {
        Objects.requireNonNull(player, "player can not be null!");
        this.playerWeakReference = new WeakReference<Player>(player);
        try {
            this.attach(player);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void attach(Player player) throws Exception {
        Object playerConnection = PacketSender.getInstance().getConnection(player);
        if (playerConnection == null) {
            PacketInjector.debug("Could not get playerConnection for player(%s)! Did PacketSender fail to load? (%d)", player.getName(), ((Object)((Object)this)).hashCode());
            return;
        }
        Object manager = Reflector.getDeclaredFieldValueByType(playerConnection, "NetworkManager");
        this.channel = (Channel)Reflector.getDeclaredFieldValueByType(manager, "Channel");
        if (this.channel.pipeline().get("ocm_handler") != null) {
            PacketInjector.debug("Old listener lingered around", new Object[0]);
            ChannelHandler old = this.channel.pipeline().get("ocm_handler");
            if (old instanceof PacketInjector) {
                PacketInjector.debug("Detaching old listener", new Object[0]);
                ((PacketInjector)old).detach();
            }
            this.channel.pipeline().remove("ocm_handler");
        }
        try {
            this.channel.pipeline().addBefore("packet_handler", "ocm_handler", (ChannelHandler)this);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("No base handler found. Was the player instantly disconnected?");
        }
    }

    void detach() {
        PacketInjector.debug("Detaching injector... (%d)", ((Object)((Object)this)).hashCode());
        if (this.channel == null) {
            PacketInjector.debug("Could not detach injector because it was never fully attached! (%d)", ((Object)((Object)this)).hashCode());
            return;
        }
        if (this.isClosed || !this.channel.isOpen()) {
            PacketInjector.debug("Closed(%b) or channel closed(%b) already! (%d)", this.isClosed, !this.channel.isOpen(), ((Object)((Object)this)).hashCode());
            return;
        }
        this.channel.eventLoop().submit(() -> {
            this.channel.pipeline().remove((ChannelHandler)this);
            this.channel = null;
            this.isClosed = true;
            this.playerWeakReference.clear();
            this.packetListeners.clear();
            PacketInjector.debug("Injector successfully detached (%d)", ((Object)((Object)this)).hashCode());
        });
    }

    void addPacketListener(PacketListener packetListener) {
        Objects.requireNonNull(packetListener, "packetListener can not be null");
        if (this.isClosed) {
            throw new IllegalStateException("Channel already closed. Adding of listener invalid");
        }
        this.packetListeners.remove(packetListener);
        this.packetListeners.add(packetListener);
    }

    void removePacketListener(PacketListener packetListener) {
        this.packetListeners.remove(packetListener);
    }

    int getListenerAmount() {
        return this.packetListeners.size();
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object packet, ChannelPromise channelPromise) throws Exception {
        if (this.playerWeakReference == null || this.playerWeakReference.get() == null) {
            PacketInjector.debug("playerWeakReference or its value is null. This should NOT happen at this stage. (write@%d)", ((Object)((Object)this)).hashCode());
            this.detach();
            super.write(channelHandlerContext, packet, channelPromise);
            return;
        }
        if (!PacketHelper.isNmsPacket(packet)) {
            if (!this.detectedNonNMSPacket) {
                Messenger.warn("Received a packet that is not NMS: %s %s", packet.getClass(), packet);
                this.detectedNonNMSPacket = true;
            }
            super.write(channelHandlerContext, packet, channelPromise);
            return;
        }
        PacketEvent event = new PacketEvent(PacketHelper.wrap(packet), PacketEvent.ConnectionDirection.TO_CLIENT, (Player)this.playerWeakReference.get());
        for (PacketListener packetListener : this.packetListeners) {
            try {
                if (this.isClosed) continue;
                packetListener.onPacketSend(event);
            }
            catch (Exception e) {
                Messenger.warn(e, "Error in a packet listener (send).", new Object[0]);
            }
        }
        if (!event.isCancelled()) {
            super.write(channelHandlerContext, packet, channelPromise);
        }
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object packet) throws Exception {
        if (this.playerWeakReference == null || this.playerWeakReference.get() == null) {
            PacketInjector.debug("playerWeakReference or its value is null. This should NOT happen at this stage. (read@%d)", ((Object)((Object)this)).hashCode());
            this.detach();
            super.channelRead(channelHandlerContext, packet);
            return;
        }
        if (!PacketHelper.isNmsPacket(packet)) {
            PacketInjector.debug("Received a packet THAT IS NO PACKET: " + packet.getClass() + " " + packet, new Object[0]);
            return;
        }
        PacketEvent event = new PacketEvent(PacketHelper.wrap(packet), PacketEvent.ConnectionDirection.TO_SERVER, (Player)this.playerWeakReference.get());
        for (PacketListener packetListener : this.packetListeners) {
            try {
                if (this.isClosed) continue;
                packetListener.onPacketReceived(event);
            }
            catch (Exception e) {
                Messenger.warn(e, "Error in a packet listener (receive).", new Object[0]);
            }
        }
        if (!event.isCancelled()) {
            super.channelRead(channelHandlerContext, packet);
        }
    }

    private static void debug(String message, Object ... formatArgs) {
        Messenger.debug("PacketInjector: " + message, formatArgs);
    }
}

