/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.damage;

import java.util.Optional;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.damage.DamageUtils;
import kernitus.plugin.OldCombatMechanics.utilities.damage.MobDamage;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionEffects;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class OCMEntityDamageByEntityEvent
extends Event
implements Cancellable {
    private boolean cancelled;
    private static final HandlerList handlers = new HandlerList();
    private final Entity damager;
    private final Entity damagee;
    private final EntityDamageEvent.DamageCause cause;
    private final double rawDamage;
    private ItemStack weapon;
    private int sharpnessLevel;
    private boolean hasWeakness;
    private int strengthLevel;
    private int weaknessLevel;
    private double baseDamage = 0.0;
    private double mobEnchantmentsDamage = 0.0;
    private double sharpnessDamage = 0.0;
    private double criticalMultiplier = 1.0;
    private double strengthModifier = 0.0;
    private double weaknessModifier = 0.0;
    private boolean isStrengthModifierMultiplier = false;
    private boolean isStrengthModifierAddend = true;
    private boolean isWeaknessModifierMultiplier = false;
    private boolean was1_8Crit = false;
    private boolean wasSprinting = false;

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public OCMEntityDamageByEntityEvent(Entity damager, Entity damagee, EntityDamageEvent.DamageCause cause, double rawDamage) {
        this.damager = damager;
        this.damagee = damagee;
        this.cause = cause;
        this.rawDamage = rawDamage;
        if (!(damager instanceof LivingEntity)) {
            this.setCancelled(true);
            return;
        }
        LivingEntity livingDamager = (LivingEntity)damager;
        this.weapon = livingDamager.getEquipment().getItemInMainHand();
        if (this.weapon == null) {
            this.weapon = new ItemStack(Material.AIR);
        }
        EntityType damageeType = damagee.getType();
        Messenger.debug((CommandSender)livingDamager, "Raw attack damage: " + rawDamage, new Object[0]);
        this.mobEnchantmentsDamage = MobDamage.getEntityEnchantmentsDamage(damageeType, this.weapon);
        this.sharpnessLevel = this.weapon.getEnchantmentLevel(Enchantment.DAMAGE_ALL);
        this.sharpnessDamage = DamageUtils.getNewSharpnessDamage(this.sharpnessLevel);
        if (damager instanceof HumanEntity) {
            float cooldown = DamageUtils.getAttackCooldown.apply((HumanEntity)damager, Float.valueOf(0.5f)).floatValue();
            this.mobEnchantmentsDamage *= (double)cooldown;
            this.sharpnessDamage *= (double)cooldown;
        }
        Messenger.debug((CommandSender)livingDamager, "Mob: " + this.mobEnchantmentsDamage + " Sharpness: " + this.sharpnessDamage, new Object[0]);
        double tempDamage = rawDamage - this.mobEnchantmentsDamage - this.sharpnessDamage;
        Messenger.debug((CommandSender)livingDamager, "No ench damage: " + tempDamage, new Object[0]);
        if (livingDamager instanceof Player && DamageUtils.isCriticalHit1_8((HumanEntity)livingDamager)) {
            this.was1_8Crit = true;
            Messenger.debug((CommandSender)livingDamager, "1.8 Critical hit detected", new Object[0]);
            if (DamageUtils.isCriticalHit1_9((Player)livingDamager)) {
                Messenger.debug((CommandSender)livingDamager, "1.9 Critical hit detected", new Object[0]);
                Messenger.debug("1.9 Critical hit detected", new Object[0]);
                this.criticalMultiplier = 1.5;
                tempDamage /= 1.5;
            }
        }
        if (damager instanceof HumanEntity) {
            float cooldown = DamageUtils.getAttackCooldown.apply((HumanEntity)damager, Float.valueOf(0.5f)).floatValue();
            tempDamage /= (double)(0.2f + cooldown * cooldown * 0.8f);
        }
        this.strengthLevel = PotionEffects.get(livingDamager, PotionEffectType.INCREASE_DAMAGE).map(PotionEffect::getAmplifier).orElse(-1) + 1;
        this.strengthModifier = this.strengthLevel * 3;
        Messenger.debug((CommandSender)livingDamager, "Strength Modifier: " + this.strengthModifier, new Object[0]);
        Optional<Integer> weaknessAmplifier = PotionEffects.get(livingDamager, PotionEffectType.WEAKNESS).map(PotionEffect::getAmplifier);
        this.hasWeakness = weaknessAmplifier.isPresent() && (weaknessAmplifier.get() == -1 || weaknessAmplifier.get() == 0);
        this.weaknessLevel = weaknessAmplifier.orElse(-1) + 1;
        this.weaknessModifier = this.weaknessLevel * -4;
        Messenger.debug((CommandSender)livingDamager, "Weakness Modifier: " + this.weaknessModifier, new Object[0]);
        this.baseDamage = tempDamage + this.weaknessModifier - this.strengthModifier;
        Messenger.debug((CommandSender)livingDamager, "Base tool damage: " + this.baseDamage, new Object[0]);
    }

    public Entity getDamager() {
        return this.damager;
    }

    public Entity getDamagee() {
        return this.damagee;
    }

    public EntityDamageEvent.DamageCause getCause() {
        return this.cause;
    }

    public double getRawDamage() {
        return this.rawDamage;
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public int getSharpnessLevel() {
        return this.sharpnessLevel;
    }

    public double getStrengthModifier() {
        return this.strengthModifier;
    }

    public void setStrengthModifier(double strengthModifier) {
        this.strengthModifier = strengthModifier;
    }

    public int getStrengthLevel() {
        return this.strengthLevel;
    }

    public boolean hasWeakness() {
        return this.hasWeakness;
    }

    public int getWeaknessLevel() {
        return this.weaknessLevel;
    }

    public double getWeaknessModifier() {
        return this.weaknessModifier;
    }

    public void setWeaknessModifier(double weaknessModifier) {
        this.weaknessModifier = weaknessModifier;
    }

    public void setWeaknessLevel(int weaknessLevel) {
        this.weaknessLevel = weaknessLevel;
    }

    public boolean isStrengthModifierMultiplier() {
        return this.isStrengthModifierMultiplier;
    }

    public void setIsStrengthModifierMultiplier(boolean isStrengthModifierMultiplier) {
        this.isStrengthModifierMultiplier = isStrengthModifierMultiplier;
    }

    public void setIsStrengthModifierAddend(boolean isStrengthModifierAddend) {
        this.isStrengthModifierAddend = isStrengthModifierAddend;
    }

    public boolean isWeaknessModifierMultiplier() {
        return this.isWeaknessModifierMultiplier;
    }

    public void setIsWeaknessModifierMultiplier(boolean weaknessModifierMultiplier) {
        this.isWeaknessModifierMultiplier = weaknessModifierMultiplier;
    }

    public boolean isStrengthModifierAddend() {
        return this.isStrengthModifierAddend;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(double baseDamage) {
        this.baseDamage = baseDamage;
    }

    public double getMobEnchantmentsDamage() {
        return this.mobEnchantmentsDamage;
    }

    public void setMobEnchantmentsDamage(double mobEnchantmentsDamage) {
        this.mobEnchantmentsDamage = mobEnchantmentsDamage;
    }

    public double getSharpnessDamage() {
        return this.sharpnessDamage;
    }

    public void setSharpnessDamage(double sharpnessDamage) {
        this.sharpnessDamage = sharpnessDamage;
    }

    public double getCriticalMultiplier() {
        return this.criticalMultiplier;
    }

    public void setCriticalMultiplier(double criticalMultiplier) {
        this.criticalMultiplier = criticalMultiplier;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean wasSprinting() {
        return this.wasSprinting;
    }

    public void setWasSprinting(boolean wasSprinting) {
        this.wasSprinting = wasSprinting;
    }

    public boolean was1_8Crit() {
        return this.was1_8Crit;
    }

    public void setWas1_8Crit(boolean was1_8Crit) {
        this.was1_8Crit = was1_8Crit;
    }
}

