/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.damage;

import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.damage.DamageUtils;
import kernitus.plugin.OldCombatMechanics.utilities.damage.OCMEntityDamageByEntityEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class EntityDamageByEntityListener
extends OCMModule {
    private static EntityDamageByEntityListener INSTANCE;
    private boolean enabled;
    private final Map<UUID, Double> lastDamages;

    public EntityDamageByEntityListener(OCMMain plugin) {
        super(plugin, "entity-damage-listener");
        INSTANCE = this;
        this.lastDamages = new WeakHashMap<UUID, Double>();
    }

    public static EntityDamageByEntityListener getINSTANCE() {
        return INSTANCE;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        Entity damagee = event.getEntity();
        Double lastStoredDamage = this.lastDamages.get(damagee.getUniqueId());
        if (lastStoredDamage != null && damagee instanceof LivingEntity) {
            LivingEntity livingDamagee = (LivingEntity)damagee;
            livingDamagee.setLastDamage(lastStoredDamage.doubleValue());
        }
        OCMEntityDamageByEntityEvent e = new OCMEntityDamageByEntityEvent(damager, damagee, event.getCause(), event.getDamage());
        this.plugin.getServer().getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return;
        }
        double newDamage = e.getBaseDamage();
        this.debug("Base: " + e.getBaseDamage(), (CommandSender)damager);
        this.debug("Base: " + e.getBaseDamage());
        double weaknessModifier = e.getWeaknessModifier() * (double)e.getWeaknessLevel();
        double weaknessAddend = e.isWeaknessModifierMultiplier() ? newDamage * weaknessModifier : weaknessModifier;
        this.debug("Weak: " + weaknessAddend);
        this.debug("Weak: " + weaknessAddend, (CommandSender)damager);
        this.debug("Strength level: " + e.getStrengthLevel());
        this.debug("Strength level: " + e.getStrengthLevel(), (CommandSender)damager);
        double strengthModifier = e.getStrengthModifier() * (double)e.getStrengthLevel();
        newDamage = !e.isStrengthModifierMultiplier() ? (newDamage += strengthModifier) : (e.isStrengthModifierAddend() ? (newDamage *= (strengthModifier += 1.0)) : (newDamage *= strengthModifier));
        this.debug("Strength: " + strengthModifier);
        this.debug("Strength: " + strengthModifier, (CommandSender)damager);
        newDamage += weaknessAddend;
        if (damager instanceof HumanEntity) {
            float cooldown = DamageUtils.getAttackCooldown.apply((HumanEntity)damager, Float.valueOf(0.5f)).floatValue();
            this.debug("Scale by attack delay: " + newDamage + " *= 0.2 + " + cooldown + "^2 * 0.8");
            newDamage *= (double)(0.2f + cooldown * cooldown * 0.8f);
        }
        double criticalMultiplier = e.getCriticalMultiplier();
        this.debug("Crit " + newDamage + " *= " + criticalMultiplier);
        newDamage *= criticalMultiplier;
        double enchantmentDamage = e.getMobEnchantmentsDamage() + e.getSharpnessDamage();
        if (damager instanceof HumanEntity) {
            float cooldown = DamageUtils.getAttackCooldown.apply((HumanEntity)damager, Float.valueOf(0.5f)).floatValue();
            this.debug("Scale enchantments by attack delay: " + enchantmentDamage + " *= " + cooldown);
            enchantmentDamage *= (double)cooldown;
        }
        this.debug("Mob " + e.getMobEnchantmentsDamage() + " Sharp: " + e.getSharpnessDamage() + " Scaled: " + enchantmentDamage, (CommandSender)damager);
        this.debug("New Damage: " + (newDamage += enchantmentDamage), (CommandSender)damager);
        event.setDamage(newDamage);
        this.debug("Set final damage to: " + newDamage);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void afterEntityDamage(EntityDamageByEntityEvent event) {
        double newLastDamage;
        Entity damager = event.getDamager();
        Entity damagee = event.getEntity();
        double newDamage = newLastDamage = event.getDamage();
        if (damagee instanceof LivingEntity) {
            LivingEntity livingDamagee = (LivingEntity)damagee;
            if ((float)livingDamagee.getNoDamageTicks() > (float)livingDamagee.getMaximumNoDamageTicks() / 2.0f) {
                double lastDamage = livingDamagee.getLastDamage();
                if (newDamage <= lastDamage) {
                    event.setCancelled(true);
                    this.debug("Was fake overdamage, cancelling " + newDamage + " <= " + lastDamage);
                    return;
                }
                this.debug("Overdamage: " + newDamage + " - " + lastDamage);
                this.debug("Last damage " + lastDamage + " new damage: " + newLastDamage + " applied: " + (newDamage -= livingDamagee.getLastDamage()) + " ticks: " + livingDamagee.getNoDamageTicks() + " /" + livingDamagee.getMaximumNoDamageTicks());
            }
            this.lastDamages.put(damagee.getUniqueId(), newLastDamage);
            if (newDamage < 0.0) {
                this.debug("Damage was " + newDamage + " setting to 0", (CommandSender)damager);
                newDamage = 0.0;
            }
            event.setDamage(newDamage);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                ((LivingEntity)damagee).setLastDamage(0.0);
                this.debug("Set last damage to 0", (CommandSender)damagee);
            }, 1L);
        }
    }
}

