/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities;

import java.util.Objects;
import java.util.logging.Level;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.utilities.TextUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class Messenger {
    public static final String HORIZONTAL_BAR = ChatColor.STRIKETHROUGH + "----------------------------------------------------";
    static boolean DEBUG_ENABLED = false;
    private static OCMMain plugin;

    public static void initialise(OCMMain plugin) {
        Messenger.plugin = plugin;
    }

    public static void info(String message, Object ... args) {
        plugin.getLogger().info(TextUtils.stripColour(String.format(message, args)));
    }

    public static void warn(Throwable e, String message, Object ... args) {
        plugin.getLogger().log(Level.WARNING, TextUtils.stripColour(String.format(message, args)), e);
    }

    public static void warn(String message, Object ... args) {
        plugin.getLogger().log(Level.WARNING, TextUtils.stripColour(String.format(message, args)));
    }

    public static void send(CommandSender sender, String message, Object ... args) {
        Objects.requireNonNull(sender, "sender cannot be null!");
        Objects.requireNonNull(message, "message cannot be null!");
        sender.sendMessage(TextUtils.colourise(String.format(message, args)));
    }

    private static void sendWithPrefix(CommandSender sender, String message, String prefix, Object ... args) {
        Messenger.send(sender, prefix + " " + message, args);
    }

    public static void sendNormalMessage(CommandSender sender, String message, Object ... args) {
        Messenger.sendWithPrefix(sender, message, "&6[OCM]&r", args);
    }

    private static void sendDebugMessage(CommandSender sender, String message, Object ... args) {
        Messenger.sendWithPrefix(sender, message, "&1[Debug]&r", args);
    }

    public static void debug(String message, Throwable throwable) {
        if (DEBUG_ENABLED) {
            plugin.getLogger().log(Level.INFO, message, throwable);
        }
    }

    public static void debug(String message, Object ... args) {
        if (DEBUG_ENABLED) {
            Messenger.info("[DEBUG] " + message, args);
        }
    }

    public static void debug(CommandSender sender, String message, Object ... args) {
        if (DEBUG_ENABLED) {
            Messenger.sendDebugMessage(sender, message, args);
        }
    }
}

