/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.potions.GenericPotionDurations;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionDurations;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionType;

public class ConfigUtils {
    public static Map<String, Double> loadDoubleMap(ConfigurationSection section) {
        Objects.requireNonNull(section, "section cannot be null!");
        return section.getKeys(false).stream().filter(((Predicate<String>)arg_0 -> ((ConfigurationSection)section).isDouble(arg_0)).or(arg_0 -> ((ConfigurationSection)section).isInt(arg_0))).collect(Collectors.toMap(key -> key, arg_0 -> ((ConfigurationSection)section).getDouble(arg_0)));
    }

    public static List<Material> loadMaterialList(ConfigurationSection section, String key) {
        Objects.requireNonNull(section, "section cannot be null!");
        Objects.requireNonNull(key, "key cannot be null!");
        if (!section.isList(key)) {
            return new ArrayList<Material>();
        }
        return section.getStringList(key).stream().map(Material::matchMaterial).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static HashMap<PotionType, PotionDurations> loadPotionDurationsList(ConfigurationSection section) {
        Objects.requireNonNull(section, "section cannot be null!");
        HashMap<PotionType, PotionDurations> durationsHashMap = new HashMap<PotionType, PotionDurations>();
        ConfigurationSection durationsSection = section.getConfigurationSection("potion-durations");
        for (String potionName : durationsSection.getKeys(false)) {
            ConfigurationSection potionSection = durationsSection.getConfigurationSection(potionName);
            ConfigurationSection drinkable = potionSection.getConfigurationSection("drinkable");
            ConfigurationSection splash = potionSection.getConfigurationSection("splash");
            potionName = potionName.toUpperCase(Locale.ROOT);
            try {
                PotionType potionType = PotionType.valueOf((String)potionName);
                durationsHashMap.put(potionType, new PotionDurations(ConfigUtils.getGenericDurations(drinkable), ConfigUtils.getGenericDurations(splash)));
            }
            catch (IllegalArgumentException e) {
                Messenger.debug("Skipping loading " + potionName + " potion", new Object[0]);
            }
        }
        return durationsHashMap;
    }

    private static GenericPotionDurations getGenericDurations(ConfigurationSection section) {
        return new GenericPotionDurations(section.getInt("base"), section.getInt("II"), section.getInt("extended"));
    }
}

