/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.updater;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.List;
import kernitus.plugin.OldCombatMechanics.updater.VersionChecker;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;

public class SpigetUpdateChecker {
    private static final String USER_AGENT = "OldCombatMechanics";
    private static final String VERSIONS_URL = "https://api.spiget.org/v2/resources/19510/versions?size=15000";
    private static final String UPDATES_URL = "https://api.spiget.org/v2/resources/19510/updates?size=15000";
    private static final String UPDATE_URL = "https://www.spigotmc.org/resources/oldcombatmechanics.19510/update?update=";
    private static final String DOWNLOAD_URL = "https://api.spiget.org/v2/resources/19510/download";
    private String latestVersion = "";

    public boolean isUpdateAvailable() {
        try {
            List<VersionPojo> versions = this.getVersions(VERSIONS_URL);
            if (versions.isEmpty()) {
                return false;
            }
            VersionPojo currentVersion = versions.get(versions.size() - 1);
            this.latestVersion = currentVersion.getName();
            return VersionChecker.shouldUpdate(this.latestVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getUpdateURL() {
        try {
            List<VersionPojo> versions = this.getVersions(UPDATES_URL);
            if (versions.isEmpty()) {
                return "Error getting update URL";
            }
            VersionPojo currentVersion = versions.get(versions.size() - 1);
            return UPDATE_URL + currentVersion.getId();
        }
        catch (Exception e) {
            return "Error getting update URL";
        }
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public boolean downloadLatestVersion(File updateFolderFile, String fileName) {
        updateFolderFile.mkdirs();
        File downloadFile = new File(updateFolderFile, fileName);
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(DOWNLOAD_URL).openConnection();
            connection.addRequestProperty("User-Agent", USER_AGENT);
            try (FileOutputStream fileOutputStream = new FileOutputStream(downloadFile);
                 ReadableByteChannel readableByteChannel = Channels.newChannel(connection.getInputStream());
                 FileChannel fileChannel = fileOutputStream.getChannel();){
                fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            }
            catch (Exception e) {
                downloadFile.delete();
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            Messenger.warn("Tried to download plugin update, but an error occurred", new Object[0]);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private List<VersionPojo> getVersions(String urlString) {
        try {
            InputStreamReader reader = this.fetchPage(urlString);
            Type pojoType = new TypeToken<List<VersionPojo>>(){}.getType();
            List parsedVersions = (List)new Gson().fromJson((Reader)reader, pojoType);
            if (parsedVersions == null) {
                System.err.println("JSON was at EOF when checking for spiget updates!");
                return Collections.emptyList();
            }
            return parsedVersions;
        }
        catch (JsonSyntaxException | IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private InputStreamReader fetchPage(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", USER_AGENT);
        InputStream inputStream = connection.getInputStream();
        return new InputStreamReader(inputStream);
    }

    private static class VersionPojo {
        private String name;
        private String id;

        private VersionPojo() {
        }

        String getName() {
            return this.name;
        }

        String getId() {
            return this.id;
        }
    }
}

