/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.MathsHelper;
import me.vagdedes.spartan.api.API;
import me.vagdedes.spartan.system.Enums;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ModulePlayerRegen
extends OCMModule {
    private final Map<UUID, Long> healTimes = new WeakHashMap<UUID, Long>();
    private boolean spartanInstalled;

    public ModulePlayerRegen(OCMMain plugin) {
        super(plugin, "old-player-regen");
        this.initSpartan();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onRegen(EntityRegainHealthEvent e) {
        if (e.getEntityType() != EntityType.PLAYER || e.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        Player p = (Player)e.getEntity();
        if (!this.isEnabled(p.getWorld())) {
            return;
        }
        UUID playerId = p.getUniqueId();
        e.setCancelled(true);
        float previousExhaustion = p.getExhaustion();
        float previousSaturation = p.getSaturation();
        long currentTime = System.currentTimeMillis();
        boolean hasLastHealTime = this.healTimes.containsKey(playerId);
        long lastHealTime = this.healTimes.computeIfAbsent(playerId, id -> currentTime);
        this.debug("Exh: " + previousExhaustion + " Sat: " + previousSaturation + " Time: " + (currentTime - lastHealTime), (CommandSender)p);
        if (hasLastHealTime && currentTime - lastHealTime <= this.module().getLong("interval")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> p.setExhaustion(previousExhaustion), 1L);
            return;
        }
        double maxHealth = p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        double playerHealth = p.getHealth();
        if (playerHealth < maxHealth) {
            p.setHealth(MathsHelper.clamp(playerHealth + (double)this.module().getInt("amount"), 0.0, maxHealth));
            this.healTimes.put(playerId, currentTime);
            if (this.spartanInstalled) {
                this.disableSpartanRegenCheck(p);
            }
        }
        float exhaustionToApply = (float)this.module().getDouble("exhaustion");
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            p.setExhaustion(previousExhaustion + exhaustionToApply);
            this.debug("Exh before: " + previousExhaustion + " Now: " + p.getExhaustion() + " Sat now: " + previousSaturation, (CommandSender)p);
        }, 1L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.healTimes.remove(e.getPlayer().getUniqueId());
    }

    private void disableSpartanRegenCheck(Player player) {
        API.cancelCheck((Player)player, (Enums.HackType)Enums.HackType.FastHeal, (int)1);
    }

    private void initSpartan() {
        this.spartanInstalled = Bukkit.getPluginManager().getPlugin("Spartan") != null;
    }
}

