/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ModulePlayerKnockback
extends OCMModule {
    private double knockbackHorizontal;
    private double knockbackVertical;
    private double knockbackVerticalLimit;
    private double knockbackExtraHorizontal;
    private double knockbackExtraVertical;
    private boolean netheriteKnockbackResistance;
    private final Map<UUID, Vector> playerKnockbackHashMap = new WeakHashMap<UUID, Vector>();

    public ModulePlayerKnockback(OCMMain plugin) {
        super(plugin, "old-player-knockback");
        this.reload();
    }

    @Override
    public void reload() {
        this.knockbackHorizontal = this.module().getDouble("knockback-horizontal", 0.4);
        this.knockbackVertical = this.module().getDouble("knockback-vertical", 0.4);
        this.knockbackVerticalLimit = this.module().getDouble("knockback-vertical-limit", 0.4);
        this.knockbackExtraHorizontal = this.module().getDouble("knockback-extra-horizontal", 0.5);
        this.knockbackExtraVertical = this.module().getDouble("knockback-extra-vertical", 0.1);
        this.netheriteKnockbackResistance = this.module().getBoolean("enable-knockback-resistance", false) && Reflector.versionIsNewerOrEqualAs(1, 16, 0);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.playerKnockbackHashMap.remove(e.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerVelocityEvent(PlayerVelocityEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (!this.playerKnockbackHashMap.containsKey(uuid)) {
            return;
        }
        event.setVelocity(this.playerKnockbackHashMap.get(uuid));
        this.playerKnockbackHashMap.remove(uuid);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player) || this.netheriteKnockbackResistance) {
            return;
        }
        AttributeInstance attribute = ((Player)entity).getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
        attribute.getModifiers().forEach(arg_0 -> ((AttributeInstance)attribute).removeModifier(arg_0));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageEntity(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (!(damager instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)damager;
        if (!this.isEnabled(attacker.getWorld())) {
            return;
        }
        Entity damagee = event.getEntity();
        if (!(damagee instanceof Player)) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            return;
        }
        if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) > 0.0) {
            return;
        }
        Player victim = (Player)damagee;
        Location attackerLocation = attacker.getLocation();
        Location victimLocation = victim.getLocation();
        double d0 = attackerLocation.getX() - victimLocation.getX();
        double d1 = attackerLocation.getZ() - victimLocation.getZ();
        while (d0 * d0 + d1 * d1 < 1.0E-4) {
            d0 = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        double magnitude = Math.sqrt(d0 * d0 + d1 * d1);
        Vector playerVelocity = victim.getVelocity();
        playerVelocity.setX(playerVelocity.getX() / 2.0 - d0 / magnitude * this.knockbackHorizontal);
        playerVelocity.setY(playerVelocity.getY() / 2.0 + this.knockbackVertical);
        playerVelocity.setZ(playerVelocity.getZ() / 2.0 - d1 / magnitude * this.knockbackHorizontal);
        EntityEquipment equipment = attacker.getEquipment();
        if (equipment != null) {
            ItemStack heldItem = equipment.getItemInMainHand().getType() == Material.AIR ? equipment.getItemInOffHand() : equipment.getItemInMainHand();
            int bonusKnockback = heldItem.getEnchantmentLevel(Enchantment.KNOCKBACK);
            if (attacker instanceof Player && ((Player)attacker).isSprinting()) {
                ++bonusKnockback;
            }
            if (playerVelocity.getY() > this.knockbackVerticalLimit) {
                playerVelocity.setY(this.knockbackVerticalLimit);
            }
            if (bonusKnockback > 0) {
                playerVelocity.add(new Vector(-Math.sin(attacker.getLocation().getYaw() * (float)Math.PI / 180.0f) * (double)bonusKnockback * this.knockbackExtraHorizontal, this.knockbackExtraVertical, Math.cos(attacker.getLocation().getYaw() * (float)Math.PI / 180.0f) * (double)bonusKnockback * this.knockbackExtraHorizontal));
            }
        }
        if (this.netheriteKnockbackResistance) {
            double resistance = 1.0 - victim.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).getValue();
            playerVelocity.multiply(new Vector(resistance, 1.0, resistance));
        }
        UUID victimId = victim.getUniqueId();
        this.playerKnockbackHashMap.put(victimId, playerVelocity);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.playerKnockbackHashMap.remove(victimId), 1L);
    }
}

