/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.ConfigUtils;
import kernitus.plugin.OldCombatMechanics.utilities.damage.OCMEntityDamageByEntityEvent;
import kernitus.plugin.OldCombatMechanics.utilities.potions.GenericPotionDurations;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionDurations;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ModuleOldPotionEffects
extends OCMModule {
    private static final Set<PotionType> EXCLUDED_POTION_TYPES = EnumSet.of(PotionType.INSTANT_DAMAGE, new PotionType[]{PotionType.INSTANT_HEAL, PotionType.AWKWARD, PotionType.MUNDANE, PotionType.THICK, PotionType.UNCRAFTABLE, PotionType.WATER});
    private Map<PotionType, PotionDurations> durations;

    public ModuleOldPotionEffects(OCMMain plugin) {
        super(plugin, "old-potion-effects");
        try {
            EXCLUDED_POTION_TYPES.add(PotionType.TURTLE_MASTER);
        }
        catch (NoSuchFieldError e) {
            this.debug("Skipping excluding a potion (probably older server version)");
        }
        this.reload();
    }

    @Override
    public void reload() {
        this.durations = ConfigUtils.loadPotionDurationsList(this.module());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerDrinksPotion(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (!this.isEnabled(player.getWorld())) {
            return;
        }
        ItemStack potionItem = event.getItem();
        if (potionItem.getType() != Material.POTION) {
            return;
        }
        this.adjustPotion(potionItem, false);
        event.setItem(potionItem);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPotionDispense(BlockDispenseEvent event) {
        if (!this.isEnabled(event.getBlock().getWorld())) {
            return;
        }
        ItemStack item = event.getItem();
        Material material = item.getType();
        if (material == Material.SPLASH_POTION || material == Material.LINGERING_POTION) {
            this.adjustPotion(item, true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPotionThrow(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.isEnabled(player.getWorld())) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        Material material = item.getType();
        if (material == Material.SPLASH_POTION || material == Material.LINGERING_POTION) {
            this.adjustPotion(item, true);
        }
    }

    private void adjustPotion(ItemStack potionItem, boolean splash) {
        int amplifier;
        PotionMeta potionMeta = (PotionMeta)potionItem.getItemMeta();
        if (potionMeta == null) {
            return;
        }
        PotionData potionData = potionMeta.getBasePotionData();
        PotionType potionType = potionData.getType();
        if (EXCLUDED_POTION_TYPES.contains(potionType)) {
            return;
        }
        int duration = this.getPotionDuration(potionData, splash);
        int n = amplifier = potionData.isUpgraded() ? 1 : 0;
        if (potionType == PotionType.WEAKNESS) {
            amplifier = -1;
        }
        PotionEffectType effectType = Objects.requireNonNull(potionType.getEffectType());
        potionMeta.addCustomEffect(new PotionEffect(effectType, duration, amplifier), false);
        potionMeta.setBasePotionData(new PotionData(PotionType.WATER));
        potionItem.setItemMeta((ItemMeta)potionMeta);
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageByEntity(OCMEntityDamageByEntityEvent event) {
        double strengthModifier;
        Entity damager = event.getDamager();
        if (!this.isEnabled(damager.getWorld())) {
            return;
        }
        if (event.hasWeakness()) {
            event.setIsWeaknessModifierMultiplier(this.module().getBoolean("weakness.multiplier"));
            double newWeaknessModifier = this.module().getDouble("weakness.modifier");
            event.setWeaknessModifier(newWeaknessModifier);
            event.setWeaknessLevel(1);
            this.debug("Old weakness modifier: " + event.getWeaknessLevel() + " New: " + newWeaknessModifier, (CommandSender)damager);
        }
        if ((strengthModifier = event.getStrengthModifier()) > 0.0) {
            event.setIsStrengthModifierMultiplier(this.module().getBoolean("strength.multiplier"));
            event.setIsStrengthModifierAddend(this.module().getBoolean("strength.addend"));
            double newStrengthModifier = this.module().getDouble("strength.modifier");
            event.setStrengthModifier(newStrengthModifier);
            this.debug("Old strength modifier: " + strengthModifier + " New: " + newStrengthModifier, (CommandSender)damager);
        }
    }

    private int getPotionDuration(PotionData potionData, boolean splash) {
        GenericPotionDurations potionDurations;
        PotionType potionType = potionData.getType();
        GenericPotionDurations genericPotionDurations = potionDurations = splash ? this.durations.get(potionType).getSplash() : this.durations.get(potionType).getDrinkable();
        int duration = potionData.isExtended() ? potionDurations.getExtendedTime() : (potionData.isUpgraded() ? potionDurations.getIITime() : potionDurations.getBaseTime());
        this.debug("Potion type: " + potionType.name() + " Duration: " + (duration *= 20));
        return duration;
    }
}

