/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ModuleOldBrewingStand
extends OCMModule {
    public ModuleOldBrewingStand(OCMMain plugin) {
        super(plugin, "old-brewing-stand");
    }

    @EventHandler
    public void onBrew(BrewEvent e) {
        final Block block = e.getBlock();
        if (!this.isEnabled(block.getWorld())) {
            return;
        }
        if (Reflector.versionIsNewerOrEqualAs(1, 17, 0)) {
            new BukkitRunnable(){

                public void run() {
                    ModuleOldBrewingStand.this.refuel(block.getState());
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        } else {
            this.refuel(block.getState());
        }
    }

    private void refuel(BlockState blockState) {
        if (!(blockState instanceof BrewingStand)) {
            return;
        }
        BrewingStand brewingStand = (BrewingStand)blockState;
        brewingStand.setFuelLevel(20);
        brewingStand.update();
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent e) {
        if (!this.isEnabled(e.getPlayer().getWorld())) {
            return;
        }
        Inventory inventory = e.getInventory();
        Location location = inventory.getLocation();
        if (location == null) {
            return;
        }
        Block block = location.getBlock();
        this.refuel(block.getState());
    }
}

