/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ModuleOldArmourDurability
extends OCMModule {
    private final Map<UUID, List<ItemStack>> explosionDamaged = new WeakHashMap<UUID, List<ItemStack>>();

    public ModuleOldArmourDurability(OCMMain plugin) {
        super(plugin, "old-armour-durability");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemDamage(PlayerItemDamageEvent e) {
        Player player = e.getPlayer();
        if (!this.isEnabled(player.getWorld())) {
            return;
        }
        ItemStack item = e.getItem();
        Material itemType = item.getType();
        if (Arrays.stream(player.getInventory().getArmorContents()).noneMatch(armourPiece -> armourPiece != null && armourPiece.getType() == itemType && armourPiece.getType() != Material.ELYTRA)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (this.explosionDamaged.containsKey(uuid)) {
            List<ItemStack> armour = this.explosionDamaged.get(uuid);
            List matchedPieces = armour.stream().filter(piece -> piece.equals((Object)item)).collect(Collectors.toList());
            armour.removeAll(matchedPieces);
            this.debug("Item matched explosion, ignoring...", (CommandSender)player);
            if (!matchedPieces.isEmpty()) {
                return;
            }
        }
        int reduction = this.module().getInt("reduction");
        int damageChance = 60 + 40 / (item.getEnchantmentLevel(Enchantment.DURABILITY) + 1);
        Random random = new Random();
        int randomInt = random.nextInt(100);
        if (randomInt >= damageChance) {
            reduction = 0;
        }
        this.debug("Item damaged: " + itemType + " Damage: " + e.getDamage() + " Changed to: " + reduction, (CommandSender)player);
        e.setDamage(reduction);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerExplosionDamage(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getEntityType() != EntityType.PLAYER) {
            return;
        }
        EntityDamageEvent.DamageCause cause = e.getCause();
        if (cause != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && cause != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        final Player player = (Player)e.getEntity();
        final UUID uuid = player.getUniqueId();
        List armour = Arrays.stream(player.getInventory().getArmorContents()).filter(Objects::nonNull).collect(Collectors.toList());
        this.explosionDamaged.put(uuid, armour);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                ModuleOldArmourDurability.this.explosionDamaged.remove(uuid);
                ModuleOldArmourDurability.this.debug("Removed from explosion set!", (CommandSender)player);
            }
        };
        runnable.runTaskLater((Plugin)this.plugin, 1L);
        this.debug("Detected explosion!", (CommandSender)player);
    }
}

