/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.SpigotFunctionChooser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ModuleDisableProjectileRandomness
extends OCMModule {
    private static double EPSILON;
    private static final SpigotFunctionChooser<Vector, Double, Vector> rotateAroundY;

    public ModuleDisableProjectileRandomness(OCMMain plugin) {
        super(plugin, "disable-projectile-randomness");
        this.reload();
    }

    @Override
    public void reload() {
        EPSILON = this.module().getDouble("epsilon");
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent e) {
        Projectile projectile = e.getEntity();
        ProjectileSource shooter = projectile.getShooter();
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (!this.isEnabled(player.getWorld())) {
                return;
            }
            this.debug("Making projectile go straight", (CommandSender)player);
            Vector playerDirection = player.getLocation().getDirection().normalize();
            Vector projectileDirection = projectile.getVelocity();
            double originalMagnitude = projectileDirection.length();
            projectileDirection.normalize();
            if (!this.fuzzyVectorEquals(projectileDirection, playerDirection)) {
                if (this.fuzzyVectorEquals(projectileDirection, rotateAroundY.apply(playerDirection, 0.17))) {
                    this.debug("10\u00b0 Offset", (CommandSender)player);
                } else if (this.fuzzyVectorEquals(projectileDirection, rotateAroundY.apply(playerDirection, -0.35))) {
                    this.debug("-10\u00b0 Offset", (CommandSender)player);
                }
            }
            playerDirection.multiply(originalMagnitude);
            projectile.setVelocity(playerDirection);
        }
    }

    private boolean fuzzyVectorEquals(Vector a, Vector b) {
        return Math.abs(a.getX() - b.getX()) < EPSILON && Math.abs(a.getZ() - b.getZ()) < EPSILON;
    }

    static {
        rotateAroundY = SpigotFunctionChooser.apiCompatCall((vector, angle) -> vector.rotateAroundY(angle.doubleValue()), (vector, angle) -> {
            double angleCos = Math.cos(angle);
            double angleSin = Math.sin(angle);
            double x = angleCos * vector.getX() + angleSin * vector.getZ();
            double z = -angleSin * vector.getX() + angleCos * vector.getZ();
            return vector.setX(x).setZ(z);
        });
    }
}

