/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Config;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.packet.mitm.PacketAdapter;
import kernitus.plugin.OldCombatMechanics.utilities.packet.mitm.PacketEvent;
import kernitus.plugin.OldCombatMechanics.utilities.packet.mitm.PacketManager;
import kernitus.plugin.OldCombatMechanics.utilities.packet.sound.SoundPacket;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;

public class ModuleAttackSounds
extends OCMModule {
    private final SoundListener soundListener = new SoundListener();
    private final Set<String> blockedSounds = new HashSet<String>(this.getBlockedSounds());

    public ModuleAttackSounds(OCMMain plugin) {
        super(plugin, "disable-attack-sounds");
        OCMMain.getInstance().addEnableListener(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                PacketManager.getInstance().addListener(this.soundListener, player);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogin(PlayerJoinEvent e) {
        PacketManager.getInstance().addListener(this.soundListener, e.getPlayer());
    }

    @Override
    public void reload() {
        this.blockedSounds.clear();
        this.blockedSounds.addAll(this.getBlockedSounds());
    }

    private Collection<String> getBlockedSounds() {
        return this.module().getStringList("blocked-sounds");
    }

    private class SoundListener
    extends PacketAdapter {
        private boolean disabledDueToError;

        private SoundListener() {
        }

        @Override
        public void onPacketSend(PacketEvent packetEvent) {
            if (this.disabledDueToError || !ModuleAttackSounds.this.isEnabled(packetEvent.getPlayer().getWorld())) {
                return;
            }
            try {
                SoundPacket.from(packetEvent.getPacket()).filter(it -> ModuleAttackSounds.this.blockedSounds.contains(it.getSoundName())).ifPresent(packet -> {
                    packetEvent.setCancelled(true);
                    if (Config.debugEnabled()) {
                        ModuleAttackSounds.this.debug("Blocked sound " + packet.getSoundName(), (CommandSender)packetEvent.getPlayer());
                    }
                });
            }
            catch (Exception | ExceptionInInitializerError e) {
                this.disabledDueToError = true;
                Messenger.warn(e, "Error detecting sound packets. Please report it along with the following exception on github.", new Object[0]);
            }
        }
    }
}

