/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ModuleAttackCooldown
extends OCMModule {
    public ModuleAttackCooldown(OCMMain plugin) {
        super(plugin, "disable-attack-cooldown");
    }

    @Override
    public void reload() {
        Bukkit.getOnlinePlayers().forEach(this::adjustAttackSpeed);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerLogin(PlayerJoinEvent e) {
        this.adjustAttackSpeed(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        this.adjustAttackSpeed(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        ModuleAttackCooldown.setAttackSpeed(player, PVPMode.NEW_PVP.getBaseAttackSpeed());
    }

    private void adjustAttackSpeed(Player player) {
        World world = player.getWorld();
        double attackSpeed = this.isEnabled(world) ? this.module().getDouble("generic-attack-speed") : PVPMode.NEW_PVP.getBaseAttackSpeed();
        ModuleAttackCooldown.setAttackSpeed(player, attackSpeed);
    }

    public static void setAttackSpeed(Player player, double attackSpeed) {
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED);
        if (attribute == null) {
            return;
        }
        double baseValue = attribute.getBaseValue();
        if (baseValue != attackSpeed) {
            Messenger.debug(String.format("Setting attack speed for player %s to %.2f (was: %.2f)", player.getName(), attackSpeed, baseValue), new Object[0]);
            attribute.setBaseValue(attackSpeed);
            player.saveData();
        }
    }

    public static void setAttackSpeed(Player player, PVPMode mode) {
        ModuleAttackCooldown.setAttackSpeed(player, mode.getBaseAttackSpeed());
    }

    public static enum PVPMode {
        OLD_PVP("1.8", 40.0),
        NEW_PVP("1.9+", 4.0);

        private final String name;
        private final double baseAttackSpeed;

        private PVPMode(String name, double baseAttackSpeed) {
            this.name = name;
            this.baseAttackSpeed = baseAttackSpeed;
        }

        public String getName() {
            return this.name;
        }

        public double getBaseAttackSpeed() {
            return this.baseAttackSpeed;
        }

        public static PVPMode getModeForPlayer(Player player) {
            Objects.requireNonNull(player, "player cannot be null!");
            double baseAttackSpeed = player.getAttribute(Attribute.GENERIC_ATTACK_SPEED).getBaseValue();
            return PVPMode.getByBaseAttackSpeed(baseAttackSpeed).orElse(OLD_PVP);
        }

        private static Optional<PVPMode> getByBaseAttackSpeed(double speed) {
            return Arrays.stream(PVPMode.values()).filter(pvpMode -> pvpMode.getBaseAttackSpeed() == speed).findFirst();
        }
    }
}

