/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.identity;

import java.util.Locale;
import java.util.UUID;
import java.util.stream.Stream;
import me.lucko.luckperms.lib.adventure.identity.IdentityImpl;
import me.lucko.luckperms.lib.adventure.identity.NilIdentity;
import me.lucko.luckperms.lib.adventure.key.Key;
import me.lucko.luckperms.lib.adventure.pointer.Pointer;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.util.examination.Examinable;
import me.lucko.luckperms.lib.adventure.util.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public interface Identity
extends Examinable {
    public static final Pointer<String> NAME = Pointer.pointer(String.class, Key.key("adventure", "name"));
    public static final Pointer<UUID> UUID = Pointer.pointer(UUID.class, Key.key("adventure", "uuid"));
    public static final Pointer<Component> DISPLAY_NAME = Pointer.pointer(Component.class, Key.key("adventure", "display_name"));
    public static final Pointer<Locale> LOCALE = Pointer.pointer(Locale.class, Key.key("adventure", "locale"));

    @NotNull
    public static Identity nil() {
        return NilIdentity.INSTANCE;
    }

    @NotNull
    public static Identity identity(@NotNull UUID uuid) {
        if (uuid.equals(NilIdentity.NIL_UUID)) {
            return NilIdentity.INSTANCE;
        }
        return new IdentityImpl(uuid);
    }

    @NotNull
    public UUID uuid();

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("uuid", this.uuid()));
    }
}

