/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import javax.annotation.Nullable;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class GameModeFlag
extends FlagValueChangeHandler<GameMode> {
    public static final Factory FACTORY = new Factory();
    private GameMode originalGameMode;
    private GameMode setGameMode;

    public GameModeFlag(Session session) {
        super(session, DefaultFlag.GAME_MODE);
    }

    public GameMode getOriginalGameMode() {
        return this.originalGameMode;
    }

    public GameMode getSetGameMode() {
        return this.setGameMode;
    }

    private void updateGameMode(Player player, @Nullable GameMode newValue, World world) {
        if (!this.getSession().getManager().hasBypass(player, world) && newValue != null) {
            if (player.getGameMode() != newValue) {
                this.originalGameMode = player.getGameMode();
                player.setGameMode(newValue);
            } else if (this.originalGameMode == null) {
                this.originalGameMode = player.getServer().getDefaultGameMode();
            }
        } else if (this.originalGameMode != null) {
            GameMode mode = this.originalGameMode;
            this.originalGameMode = null;
            player.setGameMode(mode);
        }
    }

    @Override
    protected void onInitialValue(Player player, ApplicableRegionSet set, GameMode value) {
        this.updateGameMode(player, value, player.getWorld());
    }

    @Override
    protected boolean onSetValue(Player player, Location from, Location to, ApplicableRegionSet toSet, GameMode currentValue, GameMode lastValue, MoveType moveType) {
        this.updateGameMode(player, currentValue, to.getWorld());
        return true;
    }

    @Override
    protected boolean onAbsentValue(Player player, Location from, Location to, ApplicableRegionSet toSet, GameMode lastValue, MoveType moveType) {
        this.updateGameMode(player, null, player.getWorld());
        return true;
    }

    public static class Factory
    extends Handler.Factory<GameModeFlag> {
        @Override
        public GameModeFlag create(Session session) {
            return new GameModeFlag(session);
        }
    }
}

