/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.commands.CommandUtils;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class EntryFlag
extends Handler {
    public static final Factory FACTORY = new Factory();
    private static final long MESSAGE_THRESHOLD = 2000L;
    private long lastMessage;

    public EntryFlag(Session session) {
        super(session);
    }

    @Override
    public boolean onCrossBoundary(Player player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
        boolean allowed = toSet.testState(localPlayer, DefaultFlag.ENTRY);
        if (!this.getSession().getManager().hasBypass(player, to.getWorld()) && !allowed && moveType.isCancellable()) {
            String message = toSet.queryValue(localPlayer, DefaultFlag.ENTRY_DENY_MESSAGE);
            long now = System.currentTimeMillis();
            if (now - this.lastMessage > 2000L && message != null && !message.isEmpty()) {
                player.sendMessage(CommandUtils.replaceColorMacros(message));
                this.lastMessage = now;
            }
            return false;
        }
        return true;
    }

    public static class Factory
    extends Handler.Factory<EntryFlag> {
        @Override
        public EntryFlag create(Session session) {
            return new EntryFlag(session);
        }
    }
}

