/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sk89q.worldguard.bukkit.RegionQuery;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.util.Locations;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.SessionManager;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Session {
    private final SessionManager manager;
    private final HashMap<Class<?>, Handler> handlers = Maps.newLinkedHashMap();
    private Location lastValid;
    private Set<ProtectedRegion> lastRegionSet;
    private final AtomicBoolean needRefresh = new AtomicBoolean(false);

    public Session(SessionManager manager) {
        Preconditions.checkNotNull((Object)manager, (Object)"manager");
        this.manager = manager;
    }

    void register(Handler handler) {
        this.handlers.put(handler.getClass(), handler);
    }

    public WorldGuardPlugin getPlugin() {
        return this.getManager().getPlugin();
    }

    public SessionManager getManager() {
        return this.manager;
    }

    @Nullable
    public <T extends Handler> T getHandler(Class<T> type) {
        return (T)this.handlers.get(type);
    }

    void initialize(Player player) {
        RegionQuery query = this.getManager().getPlugin().getRegionContainer().createQuery();
        Location location = player.getLocation();
        ApplicableRegionSet set = query.getApplicableRegions(location);
        this.lastValid = location;
        this.lastRegionSet = set.getRegions();
        for (Handler handler : this.handlers.values()) {
            handler.initialize(player, location, set);
        }
    }

    void tick(Player player) {
        RegionQuery query = this.getManager().getPlugin().getRegionContainer().createQuery();
        Location location = player.getLocation();
        ApplicableRegionSet set = query.getApplicableRegions(location);
        for (Handler handler : this.handlers.values()) {
            handler.tick(player, set);
        }
    }

    void resetState(Player player) {
        this.initialize(player);
        this.needRefresh.set(true);
    }

    public boolean isInvincible(Player player) {
        boolean invincible = false;
        for (Handler handler : this.handlers.values()) {
            StateFlag.State state = handler.getInvincibility(player);
            if (state == null) continue;
            switch (state) {
                case DENY: {
                    return false;
                }
                case ALLOW: {
                    invincible = true;
                }
            }
        }
        return invincible;
    }

    @Nullable
    public Location testMoveTo(Player player, Location to, MoveType moveType) {
        return this.testMoveTo(player, to, moveType, false);
    }

    @Nullable
    public Location testMoveTo(Player player, Location to, MoveType moveType, boolean forced) {
        RegionQuery query = this.getManager().getPlugin().getRegionContainer().createQuery();
        if (!forced && this.needRefresh.getAndSet(false)) {
            forced = true;
        }
        if (forced || Locations.isDifferentBlock(this.lastValid, to)) {
            ApplicableRegionSet toSet = query.getApplicableRegions(to);
            for (Handler handler : this.handlers.values()) {
                if (handler.testMoveTo(player, this.lastValid, to, toSet, moveType) || !moveType.isCancellable()) continue;
                return this.lastValid;
            }
            Sets.SetView entered = Sets.difference(toSet.getRegions(), this.lastRegionSet);
            Sets.SetView exited = Sets.difference(this.lastRegionSet, toSet.getRegions());
            for (Handler handler : this.handlers.values()) {
                if (handler.onCrossBoundary(player, this.lastValid, to, toSet, (Set<ProtectedRegion>)entered, (Set<ProtectedRegion>)exited, moveType) || !moveType.isCancellable()) continue;
                return this.lastValid;
            }
            this.lastValid = to;
            this.lastRegionSet = toSet.getRegions();
        }
        return null;
    }
}

