/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.domains;

import com.google.common.base.Preconditions;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.domains.Domain;
import com.sk89q.worldguard.domains.GroupDomain;
import com.sk89q.worldguard.domains.PlayerDomain;
import com.sk89q.worldguard.util.ChangeTracked;
import com.sk89q.worldguard.util.profile.Profile;
import com.sk89q.worldguard.util.profile.cache.ProfileCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public class DefaultDomain
implements Domain,
ChangeTracked {
    private PlayerDomain playerDomain = new PlayerDomain();
    private GroupDomain groupDomain = new GroupDomain();

    public DefaultDomain() {
    }

    public DefaultDomain(DefaultDomain existing) {
        this.setPlayerDomain(existing.getPlayerDomain());
        this.setGroupDomain(existing.getGroupDomain());
    }

    public PlayerDomain getPlayerDomain() {
        return this.playerDomain;
    }

    public void setPlayerDomain(PlayerDomain playerDomain) {
        Preconditions.checkNotNull((Object)playerDomain);
        this.playerDomain = new PlayerDomain(playerDomain);
    }

    public GroupDomain getGroupDomain() {
        return this.groupDomain;
    }

    public void setGroupDomain(GroupDomain groupDomain) {
        Preconditions.checkNotNull((Object)groupDomain);
        this.groupDomain = new GroupDomain(groupDomain);
    }

    public void addPlayer(String name) {
        this.playerDomain.addPlayer(name);
    }

    public void removePlayer(String name) {
        this.playerDomain.removePlayer(name);
    }

    public void removePlayer(UUID uuid) {
        this.playerDomain.removePlayer(uuid);
    }

    public void addPlayer(UUID uniqueId) {
        this.playerDomain.addPlayer(uniqueId);
    }

    public void removePlayer(LocalPlayer player) {
        this.playerDomain.removePlayer(player);
    }

    public void addPlayer(LocalPlayer player) {
        this.playerDomain.addPlayer(player);
    }

    public void addAll(DefaultDomain other) {
        Preconditions.checkNotNull((Object)other);
        for (String player : other.getPlayers()) {
            this.addPlayer(player);
        }
        for (UUID uuid : other.getUniqueIds()) {
            this.addPlayer(uuid);
        }
        for (String group : other.getGroups()) {
            this.addGroup(group);
        }
    }

    public void removeAll(DefaultDomain other) {
        Preconditions.checkNotNull((Object)other);
        for (String player : other.getPlayers()) {
            this.removePlayer(player);
        }
        for (UUID uuid : other.getUniqueIds()) {
            this.removePlayer(uuid);
        }
        for (String group : other.getGroups()) {
            this.removeGroup(group);
        }
    }

    public Set<String> getPlayers() {
        return this.playerDomain.getPlayers();
    }

    public Set<UUID> getUniqueIds() {
        return this.playerDomain.getUniqueIds();
    }

    public void addGroup(String name) {
        this.groupDomain.addGroup(name);
    }

    public void removeGroup(String name) {
        this.groupDomain.removeGroup(name);
    }

    public Set<String> getGroups() {
        return this.groupDomain.getGroups();
    }

    @Override
    public boolean contains(LocalPlayer player) {
        return this.playerDomain.contains(player) || this.groupDomain.contains(player);
    }

    @Override
    public boolean contains(UUID uniqueId) {
        return this.playerDomain.contains(uniqueId);
    }

    @Override
    public boolean contains(String playerName) {
        return this.playerDomain.contains(playerName);
    }

    @Override
    public int size() {
        return this.groupDomain.size() + this.playerDomain.size();
    }

    @Override
    public void clear() {
        this.playerDomain.clear();
        this.groupDomain.clear();
    }

    public void removeAll() {
        this.clear();
    }

    public String toPlayersString() {
        return this.toPlayersString(null);
    }

    public String toPlayersString(@Nullable ProfileCache cache) {
        StringBuilder str = new StringBuilder();
        ArrayList<String> output = new ArrayList<String>();
        for (String string : this.playerDomain.getPlayers()) {
            output.add("name:" + string);
        }
        if (cache != null) {
            Iterator<UUID> results = cache.getAllPresent(this.playerDomain.getUniqueIds());
            for (UUID uuid : this.playerDomain.getUniqueIds()) {
                Profile profile = (Profile)results.get(uuid);
                if (profile != null) {
                    output.add(profile.getName() + "*");
                    continue;
                }
                output.add("uuid:" + uuid);
            }
        } else {
            for (UUID uUID : this.playerDomain.getUniqueIds()) {
                output.add("uuid:" + uUID);
            }
        }
        Collections.sort(output, String.CASE_INSENSITIVE_ORDER);
        Iterator it = output.iterator();
        while (it.hasNext()) {
            str.append((String)it.next());
            if (!it.hasNext()) continue;
            str.append(", ");
        }
        return str.toString();
    }

    public String toGroupsString() {
        StringBuilder str = new StringBuilder();
        Iterator<String> it = this.groupDomain.getGroups().iterator();
        while (it.hasNext()) {
            str.append("*");
            str.append(it.next());
            if (!it.hasNext()) continue;
            str.append(", ");
        }
        return str.toString();
    }

    public String toUserFriendlyString() {
        StringBuilder str = new StringBuilder();
        if (this.playerDomain.size() > 0) {
            str.append(this.toPlayersString());
        }
        if (this.groupDomain.size() > 0) {
            if (str.length() > 0) {
                str.append("; ");
            }
            str.append(this.toGroupsString());
        }
        return str.toString();
    }

    public String toUserFriendlyString(ProfileCache cache) {
        StringBuilder str = new StringBuilder();
        if (this.playerDomain.size() > 0) {
            str.append(this.toPlayersString(cache));
        }
        if (this.groupDomain.size() > 0) {
            if (str.length() > 0) {
                str.append("; ");
            }
            str.append(this.toGroupsString());
        }
        return str.toString();
    }

    @Override
    public boolean isDirty() {
        return this.playerDomain.isDirty() || this.groupDomain.isDirty();
    }

    @Override
    public void setDirty(boolean dirty) {
        this.playerDomain.setDirty(dirty);
        this.groupDomain.setDirty(dirty);
    }

    public String toString() {
        return "{players=" + this.playerDomain + ", groups=" + this.groupDomain + '}';
    }
}

