/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.player.ProcessPlayerEvent;
import com.sk89q.worldguard.bukkit.util.Events;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.GameModeFlag;
import com.sk89q.worldguard.util.command.CommandFilter;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.TravelAgent;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class WorldGuardPlayerListener
implements Listener {
    private static final Logger log = Logger.getLogger(WorldGuardPlayerListener.class.getCanonicalName());
    private static final Pattern opPattern = Pattern.compile("^/(?:bukkit:)?op(?:\\s.*)?$", 2);
    private WorldGuardPlugin plugin;

    public WorldGuardPlayerListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        GameModeFlag handler;
        Player player = event.getPlayer();
        WorldConfiguration wcfg = this.plugin.getGlobalStateManager().get(player.getWorld());
        Session session = this.plugin.getSessionManager().getIfPresent(player);
        if (session != null && (handler = session.getHandler(GameModeFlag.class)) != null && wcfg.useRegions && !this.plugin.getGlobalRegionManager().hasBypass(player, player.getWorld())) {
            GameMode expected = handler.getSetGameMode();
            if (handler.getOriginalGameMode() != null && expected != null && expected != event.getNewGameMode()) {
                log.info("Game mode change on " + player.getName() + " has been blocked due to the region GAMEMODE flag");
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (cfg.activityHaltToggle) {
            player.sendMessage(ChatColor.YELLOW + "Intensive server activity has been HALTED.");
            int removed = 0;
            for (Entity entity : world.getEntities()) {
                if (!BukkitUtil.isIntensiveEntity(entity)) continue;
                entity.remove();
                ++removed;
            }
            if (removed > 10) {
                log.info("Halt-Act: " + removed + " entities (>10) auto-removed from " + player.getWorld().toString());
            }
        }
        if (wcfg.fireSpreadDisableToggle) {
            player.sendMessage(ChatColor.YELLOW + "Fire spread is currently globally disabled for this world.");
        }
        Events.fire(new ProcessPlayerEvent(player));
        this.plugin.getSessionManager().get(player);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        WorldConfiguration wcfg = this.plugin.getGlobalStateManager().get(player.getWorld());
        if (wcfg.useRegions) {
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (!this.plugin.getGlobalRegionManager().allows(DefaultFlag.SEND_CHAT, player.getLocation(), localPlayer)) {
                player.sendMessage(ChatColor.RED + "You don't have permission to chat in this region!");
                event.setCancelled(true);
                return;
            }
            Iterator i = event.getRecipients().iterator();
            while (i.hasNext()) {
                Player rPlayer = (Player)i.next();
                if (this.plugin.getGlobalRegionManager().allows(DefaultFlag.RECEIVE_CHAT, rPlayer.getLocation(), this.plugin.wrapPlayer(rPlayer))) continue;
                i.remove();
            }
            if (event.getRecipients().size() == 0) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        String hostKey = cfg.hostKeys.get(player.getUniqueId().toString());
        if (hostKey == null) {
            hostKey = cfg.hostKeys.get(player.getName().toLowerCase());
        }
        if (hostKey != null) {
            String hostname = event.getHostname();
            int colonIndex = hostname.indexOf(58);
            if (colonIndex != -1) {
                hostname = hostname.substring(0, colonIndex);
            }
            if (!(hostname.equals(hostKey) || cfg.hostKeysAllowFMLClients && hostname.equals(hostKey + "\u0000FML\u0000"))) {
                event.disallow(PlayerLoginEvent.Result.KICK_OTHER, "You did not join with the valid host key!");
                log.warning("WorldGuard host key check: " + player.getName() + " joined with '" + hostname + "' but '" + hostKey + "' was expected. Kicked!");
                return;
            }
        }
        if (cfg.deopOnJoin) {
            player.setOp(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            this.handleBlockRightClick(event);
        } else if (event.getAction() == Action.PHYSICAL) {
            this.handlePhysicalInteract(event);
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.removeInfiniteStacks && !this.plugin.hasPermission((CommandSender)player, "worldguard.override.infinite-stack")) {
            int slot = player.getInventory().getHeldItemSlot();
            ItemStack heldItem = player.getInventory().getItem(slot);
            if (heldItem != null && heldItem.getAmount() < 0) {
                player.getInventory().setItem(slot, null);
                player.sendMessage(ChatColor.RED + "Infinite stack removed.");
            }
        }
    }

    private void handleBlockRightClick(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getClickedBlock();
        World world = block.getWorld();
        int type = block.getTypeId();
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if ((type == 54 || type == 84 || type == 23 || type == 61 || type == 62 || type == 117 || type == 116) && wcfg.removeInfiniteStacks && !this.plugin.hasPermission((CommandSender)player, "worldguard.override.infinite-stack")) {
            for (int slot = 0; slot < 40; ++slot) {
                ItemStack heldItem = player.getInventory().getItem(slot);
                if (heldItem == null || heldItem.getAmount() >= 0) continue;
                player.getInventory().setItem(slot, null);
                player.sendMessage(ChatColor.RED + "Infinite stack in slot #" + slot + " removed.");
            }
        }
        if (wcfg.useRegions) {
            ApplicableRegionSet set = this.plugin.getRegionContainer().createQuery().getApplicableRegions(block.getLocation());
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (item != null && item.getTypeId() == wcfg.regionWand && this.plugin.hasPermission((CommandSender)player, "worldguard.region.wand")) {
                if (set.size() > 0) {
                    player.sendMessage(ChatColor.YELLOW + "Can you build? " + (set.canBuild(localPlayer) ? "Yes" : "No"));
                    StringBuilder str = new StringBuilder();
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        str.append(((ProtectedRegion)it.next()).getId());
                        if (!it.hasNext()) continue;
                        str.append(", ");
                    }
                    player.sendMessage(ChatColor.YELLOW + "Applicable regions: " + str.toString());
                } else {
                    player.sendMessage(ChatColor.YELLOW + "WorldGuard: No defined regions here!");
                }
                event.setCancelled(true);
            }
        }
    }

    private void handlePhysicalInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (block.getTypeId() == 60 && wcfg.disablePlayerCropTrampling) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        LocalPlayer localPlayer;
        ApplicableRegionSet set;
        com.sk89q.worldedit.Location spawn;
        Player player = event.getPlayer();
        Location location = player.getLocation();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(player.getWorld());
        if (wcfg.useRegions && (spawn = (com.sk89q.worldedit.Location)(set = this.plugin.getRegionContainer().createQuery().getApplicableRegions(location)).getFlag(DefaultFlag.SPAWN_LOC, localPlayer = this.plugin.wrapPlayer(player))) != null) {
            event.setRespawnLocation(com.sk89q.worldedit.bukkit.BukkitUtil.toLocation((com.sk89q.worldedit.Location)spawn));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(player.getWorld());
        if (wcfg.removeInfiniteStacks && !this.plugin.hasPermission((CommandSender)player, "worldguard.override.infinite-stack")) {
            int newSlot = event.getNewSlot();
            ItemStack heldItem = player.getInventory().getItem(newSlot);
            if (heldItem != null && heldItem.getAmount() < 0) {
                player.getInventory().setItem(newSlot, null);
                player.sendMessage(ChatColor.RED + "Infinite stack removed.");
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        World world = event.getFrom().getWorld();
        Player player = event.getPlayer();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.useRegions) {
            ApplicableRegionSet set = this.plugin.getRegionContainer().createQuery().getApplicableRegions(event.getTo());
            ApplicableRegionSet setFrom = this.plugin.getRegionContainer().createQuery().getApplicableRegions(event.getFrom());
            LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
            if (cfg.usePlayerTeleports && null != this.plugin.getSessionManager().get(player).testMoveTo(player, event.getTo(), MoveType.TELEPORT)) {
                event.setCancelled(true);
                return;
            }
            if (!(event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL || this.plugin.getGlobalRegionManager().hasBypass(localPlayer, world) || set.allows(DefaultFlag.ENDERPEARL, localPlayer) && setFrom.allows(DefaultFlag.ENDERPEARL, localPlayer))) {
                player.sendMessage(ChatColor.DARK_RED + "You're not allowed to go there.");
                event.setCancelled(true);
                return;
            }
            try {
                if (event.getCause() == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT && !this.plugin.getGlobalRegionManager().hasBypass(localPlayer, world)) {
                    boolean allowFrom = setFrom.allows(DefaultFlag.CHORUS_TELEPORT, localPlayer);
                    boolean allowTo = set.allows(DefaultFlag.CHORUS_TELEPORT, localPlayer);
                    if (!allowFrom || !allowTo) {
                        player.sendMessage(ChatColor.DARK_RED + "You're not allowed to teleport " + (!allowFrom ? "from here." : "there."));
                        event.setCancelled(true);
                        return;
                    }
                }
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerPortal(PlayerPortalEvent event) {
        if (event.getTo() == null) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getTo().getWorld());
        if (!wcfg.regionNetherPortalProtection) {
            return;
        }
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            return;
        }
        if (!event.useTravelAgent()) {
            return;
        }
        TravelAgent pta = event.getPortalTravelAgent();
        if (pta == null) {
            return;
        }
        if (pta.findPortal(event.getTo()) != null) {
            return;
        }
        int radius = pta.getCreationRadius();
        Location min = event.getTo().clone().subtract((double)radius, (double)radius, (double)radius);
        Location max = event.getTo().clone().add((double)radius, (double)radius, (double)radius);
        World world = event.getTo().getWorld();
        ProtectedCuboidRegion check = new ProtectedCuboidRegion("__portalcheck__", BukkitUtil.toVector(min.getBlock()), BukkitUtil.toVector(max.getBlock()));
        if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().hasBypass(event.getPlayer(), world)) {
            RegionManager mgr = this.plugin.getRegionContainer().get(event.getTo().getWorld());
            if (mgr == null) {
                return;
            }
            ApplicableRegionSet set = mgr.getApplicableRegions(check);
            if (!set.testState(this.plugin.wrapPlayer(event.getPlayer()), DefaultFlag.BUILD)) {
                event.getPlayer().sendMessage(ChatColor.RED + "Destination is in a protected area.");
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Set blockedCommands;
        ApplicableRegionSet set;
        Set allowedCommands;
        CommandFilter test;
        Player player = event.getPlayer();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        World world = player.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().hasBypass(player, world) && !(test = new CommandFilter(allowedCommands = (Set)((Object)(set = this.plugin.getRegionContainer().createQuery().getApplicableRegions(player.getLocation())).queryValue(localPlayer, DefaultFlag.ALLOWED_CMDS)), blockedCommands = (Set)((Object)set.queryValue(localPlayer, DefaultFlag.BLOCKED_CMDS)))).apply(event.getMessage())) {
            player.sendMessage(ChatColor.RED + event.getMessage() + " is not allowed in this area.");
            event.setCancelled(true);
            return;
        }
        if (cfg.blockInGameOp && opPattern.matcher(event.getMessage()).matches()) {
            player.sendMessage(ChatColor.RED + "/op can only be used in console (as set by a WG setting).");
            event.setCancelled(true);
            return;
        }
    }
}

