/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.google.common.base.Preconditions;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

class AbstractListener
implements Listener {
    private final WorldGuardPlugin plugin;

    public AbstractListener(WorldGuardPlugin plugin) {
        Preconditions.checkNotNull((Object)((Object)plugin));
        this.plugin = plugin;
    }

    public void registerEvents() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    protected WorldGuardPlugin getPlugin() {
        return this.plugin;
    }

    protected ConfigurationManager getConfig() {
        return this.plugin.getGlobalStateManager();
    }

    protected WorldConfiguration getWorldConfig(World world) {
        return this.plugin.getGlobalStateManager().get(world);
    }

    protected WorldConfiguration getWorldConfig(Player player) {
        return this.getWorldConfig(player.getWorld());
    }

    protected boolean isRegionSupportEnabled(World world) {
        return this.getWorldConfig((World)world).useRegions;
    }
}

