/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.io.Files;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.commands.AsyncCommandHelper;
import com.sk89q.worldguard.bukkit.commands.CommandUtils;
import com.sk89q.worldguard.bukkit.commands.DebuggingCommands;
import com.sk89q.worldguard.bukkit.util.logging.LoggerToChatHandler;
import com.sk89q.worldguard.bukkit.util.report.ConfigReport;
import com.sk89q.worldguard.bukkit.util.report.PerformanceReport;
import com.sk89q.worldguard.bukkit.util.report.PluginReport;
import com.sk89q.worldguard.bukkit.util.report.SchedulerReport;
import com.sk89q.worldguard.bukkit.util.report.ServerReport;
import com.sk89q.worldguard.bukkit.util.report.ServicesReport;
import com.sk89q.worldguard.bukkit.util.report.WorldReport;
import com.sk89q.worldguard.util.profiler.SamplerBuilder;
import com.sk89q.worldguard.util.profiler.ThreadIdFilter;
import com.sk89q.worldguard.util.profiler.ThreadNameFilter;
import com.sk89q.worldguard.util.report.ReportList;
import com.sk89q.worldguard.util.report.SystemInfoReport;
import com.sk89q.worldguard.util.task.Task;
import com.sk89q.worldguard.util.task.TaskStateComparator;
import java.io.File;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldGuardCommands {
    private static final Logger log = Logger.getLogger(WorldGuardCommands.class.getCanonicalName());
    private final WorldGuardPlugin plugin;
    @Nullable
    private SamplerBuilder.Sampler activeSampler;

    public WorldGuardCommands(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"version"}, desc="Get the WorldGuard version", max=0)
    public void version(CommandContext args, CommandSender sender) throws CommandException {
        sender.sendMessage(ChatColor.YELLOW + "WorldGuard " + this.plugin.getDescription().getVersion());
        sender.sendMessage(ChatColor.YELLOW + "http://www.sk89q.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(aliases={"reload"}, desc="Reload WorldGuard configuration", max=0)
    @CommandPermissions(value={"worldguard.reload"})
    public void reload(CommandContext args, CommandSender sender) throws CommandException {
        List<Task<?>> tasks = this.plugin.getSupervisor().getTasks();
        if (!tasks.isEmpty()) {
            throw new CommandException("There are currently pending tasks. Use /wg running to monitor these tasks first.");
        }
        LoggerToChatHandler handler = null;
        Logger minecraftLogger = null;
        if (sender instanceof Player) {
            handler = new LoggerToChatHandler(sender);
            handler.setLevel(Level.ALL);
            minecraftLogger = Logger.getLogger("com.sk89q.worldguard");
            minecraftLogger.addHandler(handler);
        }
        try {
            ConfigurationManager config = this.plugin.getGlobalStateManager();
            config.unload();
            config.load();
            for (World world : Bukkit.getServer().getWorlds()) {
                config.get(world);
            }
            this.plugin.getRegionContainer().reload();
            sender.sendMessage("WorldGuard configuration reloaded.");
        }
        catch (Throwable t) {
            sender.sendMessage("Error while reloading: " + t.getMessage());
        }
        finally {
            if (minecraftLogger != null) {
                minecraftLogger.removeHandler(handler);
            }
        }
    }

    @Command(aliases={"report"}, desc="Writes a report on WorldGuard", flags="p", max=0)
    @CommandPermissions(value={"worldguard.report"})
    public void report(CommandContext args, CommandSender sender) throws CommandException {
        ReportList report = new ReportList("Report");
        report.add(new SystemInfoReport());
        report.add(new ServerReport());
        report.add(new PluginReport());
        report.add(new SchedulerReport());
        report.add(new ServicesReport());
        report.add(new WorldReport());
        report.add(new PerformanceReport());
        report.add(new ConfigReport(this.plugin));
        String result = report.toString();
        try {
            File dest = new File(this.plugin.getDataFolder(), "report.txt");
            Files.write((CharSequence)result, (File)dest, (Charset)Charset.forName("UTF-8"));
            sender.sendMessage(ChatColor.YELLOW + "WorldGuard report written to " + dest.getAbsolutePath());
        }
        catch (IOException e) {
            throw new CommandException("Failed to write report: " + e.getMessage());
        }
        if (args.hasFlag('p')) {
            this.plugin.checkPermission(sender, "worldguard.report.pastebin");
            CommandUtils.pastebin(this.plugin, sender, result, "WorldGuard report: %s.report");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(aliases={"profile"}, usage="[<minutes>]", desc="Profile the CPU usage of the server", min=0, max=1, flags="t:p")
    @CommandPermissions(value={"worldguard.profile"})
    public void profile(CommandContext args, final CommandSender sender) throws CommandException {
        SamplerBuilder.Sampler sampler;
        int minutes;
        boolean pastebin;
        String threadName = args.getFlag('t');
        if (args.hasFlag('p')) {
            this.plugin.checkPermission(sender, "worldguard.report.pastebin");
            pastebin = true;
        } else {
            pastebin = false;
        }
        Object threadFilter = threadName == null ? new ThreadIdFilter(Thread.currentThread().getId()) : (threadName.equals("*") ? Predicates.alwaysTrue() : new ThreadNameFilter(threadName));
        if (args.argsLength() == 0) {
            minutes = 5;
        } else {
            minutes = args.getInteger(0);
            if (minutes < 1) {
                throw new CommandException("You must run the profile for at least 1 minute.");
            }
            if (minutes > 10) {
                throw new CommandException("You can profile for, at maximum, 10 minutes.");
            }
        }
        WorldGuardCommands worldGuardCommands = this;
        synchronized (worldGuardCommands) {
            if (this.activeSampler != null) {
                throw new CommandException("A profile is currently in progress! Please use /wg stopprofile to stop the current profile.");
            }
            SamplerBuilder builder = new SamplerBuilder();
            builder.setThreadFilter((Predicate<ThreadInfo>)threadFilter);
            builder.setRunTime(minutes, TimeUnit.MINUTES);
            sampler = this.activeSampler = builder.start();
        }
        AsyncCommandHelper.wrap(sampler.getFuture(), this.plugin, sender).formatUsing(minutes).registerWithSupervisor("Running CPU profiler for %d minute(s)...").sendMessageAfterDelay("(Please wait... profiling for %d minute(s)...)").thenTellErrorsOnly("CPU profiling failed.");
        sampler.getFuture().addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WorldGuardCommands worldGuardCommands = WorldGuardCommands.this;
                synchronized (worldGuardCommands) {
                    WorldGuardCommands.this.activeSampler = null;
                }
            }
        }, MoreExecutors.directExecutor());
        Futures.addCallback(sampler.getFuture(), (FutureCallback)new FutureCallback<SamplerBuilder.Sampler>(){

            public void onSuccess(SamplerBuilder.Sampler result) {
                String output = result.toString();
                try {
                    File dest = new File(WorldGuardCommands.this.plugin.getDataFolder(), "profile.txt");
                    Files.write((CharSequence)output, (File)dest, (Charset)Charset.forName("UTF-8"));
                    sender.sendMessage(ChatColor.YELLOW + "CPU profiling data written to " + dest.getAbsolutePath());
                }
                catch (IOException e) {
                    sender.sendMessage(ChatColor.RED + "Failed to write CPU profiling data: " + e.getMessage());
                }
                if (pastebin) {
                    CommandUtils.pastebin(WorldGuardCommands.this.plugin, sender, output, "Profile result: %s.profile");
                }
            }

            public void onFailure(Throwable throwable) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(aliases={"stopprofile"}, usage="", desc="Stop a running profile", min=0, max=0)
    @CommandPermissions(value={"worldguard.profile"})
    public void stopProfile(CommandContext args, CommandSender sender) throws CommandException {
        WorldGuardCommands worldGuardCommands = this;
        synchronized (worldGuardCommands) {
            if (this.activeSampler == null) {
                throw new CommandException("No CPU profile is currently running.");
            }
            this.activeSampler.cancel();
            this.activeSampler = null;
        }
        sender.sendMessage("The running CPU profile has been stopped.");
    }

    @Command(aliases={"flushstates", "clearstates"}, usage="[player]", desc="Flush the state manager", max=1)
    @CommandPermissions(value={"worldguard.flushstates"})
    public void flushStates(CommandContext args, CommandSender sender) throws CommandException {
        if (args.argsLength() == 0) {
            this.plugin.getSessionManager().resetAllStates();
            sender.sendMessage("Cleared all states.");
        } else {
            Player player = this.plugin.getServer().getPlayer(args.getString(0));
            if (player != null) {
                this.plugin.getSessionManager().resetState(player);
                sender.sendMessage("Cleared states for player \"" + player.getName() + "\".");
            }
        }
    }

    @Command(aliases={"running", "queue"}, desc="List running tasks", max=0)
    @CommandPermissions(value={"worldguard.running"})
    public void listRunningTasks(CommandContext args, CommandSender sender) throws CommandException {
        List<Task<?>> tasks = this.plugin.getSupervisor().getTasks();
        if (!tasks.isEmpty()) {
            Collections.sort(tasks, new TaskStateComparator());
            StringBuilder builder = new StringBuilder();
            builder.append(ChatColor.GRAY);
            builder.append("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            builder.append(" Running tasks ");
            builder.append("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            builder.append("\n").append(ChatColor.GRAY).append("Note: Some 'running' tasks may be waiting to be start.");
            for (Task<?> task : tasks) {
                builder.append("\n");
                builder.append(ChatColor.BLUE).append("(").append(task.getState().name()).append(") ");
                builder.append(ChatColor.YELLOW);
                builder.append(CommandUtils.getOwnerName(task.getOwner()));
                builder.append(": ");
                builder.append(ChatColor.WHITE);
                builder.append(task.getName());
            }
            sender.sendMessage(builder.toString());
        } else {
            sender.sendMessage(ChatColor.YELLOW + "There are currently no running tasks.");
        }
    }

    @Command(aliases={"debug"}, desc="Debugging commands")
    @NestedCommand(value={DebuggingCommands.class})
    public void debug(CommandContext args, CommandSender sender) {
    }
}

