/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.commands.CommandUtils;
import com.sk89q.worldguard.bukkit.event.debug.CancelLogging;
import com.sk89q.worldguard.bukkit.event.debug.LoggingBlockBreakEvent;
import com.sk89q.worldguard.bukkit.event.debug.LoggingBlockPlaceEvent;
import com.sk89q.worldguard.bukkit.event.debug.LoggingEntityDamageByEntityEvent;
import com.sk89q.worldguard.bukkit.event.debug.LoggingPlayerInteractEvent;
import com.sk89q.worldguard.util.report.CancelReport;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.BlockIterator;

public class DebuggingCommands {
    private static final Logger log = Logger.getLogger(DebuggingCommands.class.getCanonicalName());
    private static final int MAX_TRACE_DISTANCE = 20;
    private final WorldGuardPlugin plugin;

    public DebuggingCommands(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"testbreak"}, usage="[player]", desc="Simulate a block break", min=1, max=1, flags="ts")
    @CommandPermissions(value={"worldguard.debug.event"})
    public void fireBreakEvent(CommandContext args, CommandSender sender) throws CommandException {
        Player target = this.plugin.matchSinglePlayer(sender, args.getString(0));
        Block block = this.traceBlock(sender, target, args.hasFlag('t'));
        sender.sendMessage(ChatColor.AQUA + "Testing BLOCK BREAK at " + ChatColor.DARK_AQUA + block);
        LoggingBlockBreakEvent event = new LoggingBlockBreakEvent(block, target);
        this.testEvent(sender, target, event, args.hasFlag('s'));
    }

    @Command(aliases={"testplace"}, usage="[player]", desc="Simulate a block place", min=1, max=1, flags="ts")
    @CommandPermissions(value={"worldguard.debug.event"})
    public void firePlaceEvent(CommandContext args, CommandSender sender) throws CommandException {
        Player target = this.plugin.matchSinglePlayer(sender, args.getString(0));
        Block block = this.traceBlock(sender, target, args.hasFlag('t'));
        sender.sendMessage(ChatColor.AQUA + "Testing BLOCK PLACE at " + ChatColor.DARK_AQUA + block);
        LoggingBlockPlaceEvent event = new LoggingBlockPlaceEvent(block, block.getState(), block.getRelative(BlockFace.DOWN), target.getItemInHand(), target, true);
        this.testEvent(sender, target, event, args.hasFlag('s'));
    }

    @Command(aliases={"testinteract"}, usage="[player]", desc="Simulate a block interact", min=1, max=1, flags="ts")
    @CommandPermissions(value={"worldguard.debug.event"})
    public void fireInteractEvent(CommandContext args, CommandSender sender) throws CommandException {
        Player target = this.plugin.matchSinglePlayer(sender, args.getString(0));
        Block block = this.traceBlock(sender, target, args.hasFlag('t'));
        sender.sendMessage(ChatColor.AQUA + "Testing BLOCK INTERACT at " + ChatColor.DARK_AQUA + block);
        LoggingPlayerInteractEvent event = new LoggingPlayerInteractEvent(target, Action.RIGHT_CLICK_BLOCK, target.getItemInHand(), block, BlockFace.SOUTH);
        this.testEvent(sender, target, event, args.hasFlag('s'));
    }

    @Command(aliases={"testdamage"}, usage="[player]", desc="Simulate an entity damage", min=1, max=1, flags="ts")
    @CommandPermissions(value={"worldguard.debug.event"})
    public void fireDamageEvent(CommandContext args, CommandSender sender) throws CommandException {
        Player target = this.plugin.matchSinglePlayer(sender, args.getString(0));
        Entity entity = this.traceEntity(sender, target, args.hasFlag('t'));
        sender.sendMessage(ChatColor.AQUA + "Testing ENTITY DAMAGE on " + ChatColor.DARK_AQUA + entity);
        LoggingEntityDamageByEntityEvent event = new LoggingEntityDamageByEntityEvent((Entity)target, entity, EntityDamageEvent.DamageCause.ENTITY_ATTACK, 1.0);
        this.testEvent(sender, target, event, args.hasFlag('s'));
    }

    private <T extends Event> void testEvent(CommandSender receiver, Player target, T event, boolean stacktraceMode) throws CommandPermissionsException {
        boolean isConsole = receiver instanceof ConsoleCommandSender;
        if (!receiver.equals(target)) {
            if (!isConsole) {
                log.info(receiver.getName() + " is simulating an event on " + target.getName());
            }
            target.sendMessage(ChatColor.RED + "(Please ignore any messages that may immediately follow.)");
        }
        Bukkit.getPluginManager().callEvent(event);
        int start = new Exception().getStackTrace().length;
        CancelReport report = new CancelReport(event, ((CancelLogging)event).getCancels(), start);
        report.setDetectingPlugin(!stacktraceMode);
        String result = report.toString();
        if (stacktraceMode) {
            receiver.sendMessage(ChatColor.GRAY + "The report was printed to console.");
            log.info("Event report for " + receiver.getName() + ":\n\n" + result);
            this.plugin.checkPermission(receiver, "worldguard.debug.pastebin");
            CommandUtils.pastebin(this.plugin, receiver, result, "Event debugging report: %s.txt");
        } else {
            receiver.sendMessage(result.replaceAll("(?m)^", ChatColor.AQUA.toString()));
            if (result.length() >= 500 && !isConsole) {
                receiver.sendMessage(ChatColor.GRAY + "The report was also printed to console.");
                log.info("Event report for " + receiver.getName() + ":\n\n" + result);
            }
        }
    }

    private Player getSource(CommandSender sender, Player target, boolean fromTarget) throws CommandException {
        if (fromTarget) {
            return target;
        }
        if (sender instanceof Player) {
            return (Player)sender;
        }
        throw new CommandException("If this command is not to be used in-game, use -t to run the test from the viewpoint of the given player rather than yourself.");
    }

    private Block traceBlock(CommandSender sender, Player target, boolean fromTarget) throws CommandException {
        Player source = this.getSource(sender, target, fromTarget);
        BlockIterator it = new BlockIterator((LivingEntity)source);
        for (int i = 0; it.hasNext() && i < 20; ++i) {
            Block block = it.next();
            if (block.getType() == Material.AIR) continue;
            return block;
        }
        throw new CommandException("Not currently looking at a block that is close enough.");
    }

    private Entity traceEntity(CommandSender sender, Player target, boolean fromTarget) throws CommandException {
        Player source = this.getSource(sender, target, fromTarget);
        BlockIterator it = new BlockIterator((LivingEntity)source);
        for (int i = 0; it.hasNext() && i < 20; ++i) {
            Entity[] entities;
            Block block = it.next();
            for (Entity entity : entities = block.getChunk().getEntities()) {
                if (entity.equals(target) || !(entity.getLocation().distanceSquared(block.getLocation()) < 10.0)) continue;
                return entity;
            }
        }
        throw new CommandException("Not currently looking at an entity that is close enough.");
    }
}

