/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.plugin.commands;

import com.google.common.collect.Lists;
import eu.decentsoftware.holograms.api.Lang;
import eu.decentsoftware.holograms.api.commands.CommandBase;
import eu.decentsoftware.holograms.api.commands.CommandHandler;
import eu.decentsoftware.holograms.api.commands.CommandInfo;
import eu.decentsoftware.holograms.api.commands.DecentCommand;
import eu.decentsoftware.holograms.api.commands.TabCompleteHandler;
import eu.decentsoftware.holograms.api.convertor.IConvertor;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.message.Message;
import eu.decentsoftware.holograms.api.utils.scheduler.S;
import eu.decentsoftware.holograms.plugin.Validator;
import eu.decentsoftware.holograms.plugin.commands.FeatureSubCommand;
import eu.decentsoftware.holograms.plugin.commands.HologramSubCommand;
import eu.decentsoftware.holograms.plugin.commands.LineSubCommand;
import eu.decentsoftware.holograms.plugin.commands.PageSubCommand;
import eu.decentsoftware.holograms.plugin.convertors.ConvertorResult;
import eu.decentsoftware.holograms.plugin.convertors.ConvertorType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandInfo(aliases={"holograms", "hologram", "dh", "holo"}, permission="dh.default", usage="/dh <args>", description="The main DecentHolograms Command.")
public class HologramsCommand
extends DecentCommand {
    public HologramsCommand() {
        super("decentholograms");
        this.addSubCommand(new HelpSubCommand());
        this.addSubCommand(new ReloadSubCommand());
        this.addSubCommand(new ListSubCommand());
        this.addSubCommand(new HologramSubCommand());
        this.addSubCommand(new LineSubCommand());
        this.addSubCommand(new FeatureSubCommand());
        this.addSubCommand(new PageSubCommand());
        this.addSubCommand(new ConvertSubCommand());
        this.addSubCommand(new VersionSubCommand());
        this.addSubCommand(new HologramSubCommand.HologramCreateSub());
        this.addSubCommand(new HologramSubCommand.HologramDeleteSub());
        this.addSubCommand(new HologramSubCommand.HologramCloneSub());
        this.addSubCommand(new HologramSubCommand.HologramEnableSub());
        this.addSubCommand(new HologramSubCommand.HologramDisableSub());
        this.addSubCommand(new HologramSubCommand.HologramAlignSub());
        this.addSubCommand(new HologramSubCommand.HologramCenterSub());
        this.addSubCommand(new HologramSubCommand.HologramInfoSub());
        this.addSubCommand(new HologramSubCommand.HologramNearSub());
        this.addSubCommand(new HologramSubCommand.HologramTeleportSub());
        this.addSubCommand(new HologramSubCommand.HologramMoveSub());
        this.addSubCommand(new HologramSubCommand.HologramMovehereSub());
    }

    @Override
    public CommandHandler getCommandHandler() {
        return (sender, args) -> {
            if (sender.hasPermission("dh.admin")) {
                if (args.length == 0) {
                    Lang.USE_HELP.send(sender);
                    return true;
                }
                Lang.UNKNOWN_SUB_COMMAND.send(sender);
                Lang.USE_HELP.send(sender);
            } else {
                Lang.sendVersionMessage(sender);
            }
            return true;
        };
    }

    @Override
    public TabCompleteHandler getTabCompleteHandler() {
        return null;
    }

    @CommandInfo(permission="dh.admin", usage="/dh help", description="Show general help.", aliases={"?"})
    public static class HelpSubCommand
    extends DecentCommand {
        public HelpSubCommand() {
            super("help");
        }

        @Override
        public CommandHandler getCommandHandler() {
            return (sender, args) -> {
                sender.sendMessage("");
                Common.tell(sender, " &3&lDECENT HOLOGRAMS HELP");
                Common.tell(sender, " All general commands.");
                sender.sendMessage("");
                DecentCommand command = PLUGIN.getCommandManager().getMainCommand();
                ArrayList subCommands = Lists.newArrayList(command.getSubCommands());
                for (CommandBase subCommand : subCommands) {
                    if (subCommand.getClass().toString().contains("HologramSubCommand")) continue;
                    Common.tell(sender, " &8\u2022 &b%s &8- &7%s", subCommand.getUsage(), subCommand.getDescription());
                }
                sender.sendMessage("");
                Common.tell(sender, " &7Aliases: &b%s%s", command.getName(), command.getAliases().size() > 1 ? ", " + String.join((CharSequence)", ", command.getAliases()) : "");
                sender.sendMessage("");
                return true;
            };
        }

        @Override
        public TabCompleteHandler getTabCompleteHandler() {
            return null;
        }
    }

    @CommandInfo(permission="dh.admin", usage="/dh reload", description="Reload the plugin.")
    public static class ReloadSubCommand
    extends DecentCommand {
        public ReloadSubCommand() {
            super("reload");
        }

        @Override
        public CommandHandler getCommandHandler() {
            return (sender, args) -> {
                S.async(() -> {
                    long start = System.currentTimeMillis();
                    PLUGIN.reload();
                    long end = System.currentTimeMillis();
                    Lang.RELOADED.send(sender, end - start);
                });
                return true;
            };
        }

        @Override
        public TabCompleteHandler getTabCompleteHandler() {
            return null;
        }
    }

    @CommandInfo(permission="dh.admin", usage="/dh list [page]", description="Show list of all Holograms.", playerOnly=true)
    public static class ListSubCommand
    extends DecentCommand {
        public ListSubCommand() {
            super("list");
        }

        @Override
        public CommandHandler getCommandHandler() {
            return (sender, args) -> {
                ArrayList holograms = Lists.newArrayList(PLUGIN.getHologramManager().getHolograms());
                if (holograms.isEmpty()) {
                    Common.tell(sender, "%sThere are currently no holograms.", Common.PREFIX);
                    return true;
                }
                int currentPage = args.length >= 1 ? Validator.getInteger(args[0], "Page must be a valid integer.") - 1 : 0;
                ArrayList header = Lists.newArrayList((Object[])new String[]{"", " &3&lHOLOGRAM LIST - #" + (currentPage + 1), " &fList of all existing holograms.", ""});
                Function<Hologram, String> parseItem = hologram -> {
                    Location l = hologram.getLocation();
                    String name = (hologram.isEnabled() ? "" : "&c") + hologram.getName();
                    return String.format(" &8\u2022 &b%s &8| &7%s, %.2f, %.2f, %.2f", name, l.getWorld().getName(), l.getX(), l.getY(), l.getZ());
                };
                Message.sendPaginatedMessage((Player)sender, currentPage, "/dh list %d", 15, header, null, holograms, parseItem);
                return true;
            };
        }

        @Override
        public TabCompleteHandler getTabCompleteHandler() {
            return (sender, args) -> {
                if (args.length != 1) {
                    return null;
                }
                int holograms = PLUGIN.getHologramManager().getHolograms().size();
                if (holograms == 0) {
                    return null;
                }
                ArrayList<String> pages = new ArrayList<String>();
                int page = 0;
                while (holograms > 0) {
                    pages.add(String.valueOf(++page));
                    holograms -= 15;
                }
                return TabCompleteHandler.getPartialMatches(args[0], pages);
            };
        }
    }

    @CommandInfo(permission="dh.admin", usage="/dh convert <plugin> [file]", description="Convert holograms from given plugin.", minArgs=1)
    public static class ConvertSubCommand
    extends DecentCommand {
        public ConvertSubCommand() {
            super("convert");
        }

        @Override
        public CommandHandler getCommandHandler() {
            return (sender, args) -> {
                ConvertorResult result;
                String path;
                ConvertorType convertorType = ConvertorType.fromString(args[0]);
                String string = path = args.length >= 2 ? args[0] : null;
                if (convertorType == null) {
                    Common.tell(sender, "%s&cCannot convert Holograms! Unknown plugin '%s' provided", Common.PREFIX, args[0]);
                    return true;
                }
                long startTime = System.currentTimeMillis();
                IConvertor convertor = convertorType.getConvertor();
                if (convertor == null) {
                    Common.tell(sender, "%s&cCannot convert Holograms! Unknown plugin '%s' provided", Common.PREFIX, args[0]);
                    return true;
                }
                Common.tell(sender, "%sConverting holograms from %s...", Common.PREFIX, convertorType.getName());
                if (convertorType.isLimited()) {
                    Common.tell(sender, "%s&6NOTE: %s support is limited!", Common.PREFIX, convertorType.getName());
                }
                if (path != null) {
                    File file = new File(path);
                    result = convertor.convert(file);
                } else {
                    result = convertor.convert();
                }
                this.sendResult(sender, startTime, result);
                return true;
            };
        }

        public void sendResult(CommandSender sender, long startTime, ConvertorResult result) {
            Common.tell(sender, "%sConverted %d hologram(s) in %s ms!", Common.PREFIX, result.getTotalCount(), System.currentTimeMillis() - startTime);
            Common.tell(sender, "%s- &a%d successful", Common.PREFIX, result.getSuccessCount());
            Common.tell(sender, "%s- &e%d skipped", Common.PREFIX, result.getSkippedCount());
            Common.tell(sender, "%s- &c%d failed", Common.PREFIX, result.getFailedCount());
        }

        @Override
        public TabCompleteHandler getTabCompleteHandler() {
            return (sender, args) -> {
                if (args.length == 1) {
                    return TabCompleteHandler.getPartialMatches(args[0], Arrays.stream(ConvertorType.values()).map(ConvertorType::getName).collect(Collectors.toList()));
                }
                return null;
            };
        }
    }

    @CommandInfo(permission="dh.admin", aliases={"ver", "about"}, usage="/dh version", description="Shows some info about your current DecentHolograms version.")
    public static class VersionSubCommand
    extends DecentCommand {
        public VersionSubCommand() {
            super("version");
        }

        @Override
        public CommandHandler getCommandHandler() {
            return (sender, args) -> {
                Lang.sendVersionMessage(sender);
                return true;
            };
        }

        @Override
        public TabCompleteHandler getTabCompleteHandler() {
            return null;
        }
    }

    @CommandInfo(permission="dh.admin", usage="/dh test", playerOnly=true, minArgs=1, description="Test command.")
    public static class TestSubCommand
    extends DecentCommand {
        public TestSubCommand() {
            super("test");
        }

        @Override
        public CommandHandler getCommandHandler() {
            return (sender, args) -> true;
        }

        @Override
        public TabCompleteHandler getTabCompleteHandler() {
            return null;
        }
    }
}

