/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.location;

import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class DecentLocation {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @NonNull
    private String worldName;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    @Contract(pure=true)
    public DecentLocation(@NonNull String worldName, double x, double y, double z, float yaw, float pitch) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @Contract(pure=true)
    public DecentLocation(@NonNull String worldName, double x, double y, double z) {
        this(worldName, x, y, z, 0.0f, 0.0f);
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
    }

    public DecentLocation(@NonNull Location location) {
        this(location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
    }

    @NonNull
    public String getWorldName() {
        this.lock.readLock().lock();
        try {
            String string = this.worldName;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public DecentLocation setWorldName(@NonNull String worldName) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        this.lock.writeLock().lock();
        try {
            this.worldName = worldName;
            DecentLocation decentLocation = this;
            return decentLocation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public double getX() {
        this.lock.readLock().lock();
        try {
            double d = this.x;
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecentLocation setX(double x) {
        this.lock.writeLock().lock();
        try {
            this.x = x;
            DecentLocation decentLocation = this;
            return decentLocation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public double getY() {
        this.lock.readLock().lock();
        try {
            double d = this.y;
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecentLocation setY(double y) {
        this.lock.writeLock().lock();
        try {
            this.y = y;
            DecentLocation decentLocation = this;
            return decentLocation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public double getZ() {
        this.lock.readLock().lock();
        try {
            double d = this.z;
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecentLocation setZ(double z) {
        this.lock.writeLock().lock();
        try {
            this.z = z;
            DecentLocation decentLocation = this;
            return decentLocation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public float getYaw() {
        this.lock.readLock().lock();
        try {
            float f = this.yaw;
            return f;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public DecentLocation setYaw(float yaw) {
        this.lock.writeLock().lock();
        try {
            this.yaw = yaw;
            DecentLocation decentLocation = this;
            return decentLocation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public float getPitch() {
        this.lock.readLock().lock();
        try {
            float f = this.pitch;
            return f;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public DecentLocation setPitch(float pitch) {
        this.lock.writeLock().lock();
        try {
            this.pitch = pitch;
            DecentLocation decentLocation = this;
            return decentLocation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecentLocation add(double x, double y, double z) {
        this.lock.writeLock().lock();
        try {
            this.x += x;
            this.y += y;
            this.z += z;
            DecentLocation decentLocation = this;
            return decentLocation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecentLocation subtract(double x, double y, double z) {
        this.lock.writeLock().lock();
        try {
            this.x -= x;
            this.y -= y;
            this.z -= z;
            DecentLocation decentLocation = this;
            return decentLocation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nullable
    public World getWorld() {
        return Bukkit.getWorld((String)this.getWorldName());
    }

    @Nullable
    public Location toBukkitLocation() {
        World world = Bukkit.getWorld((String)this.getWorldName());
        if (world == null) {
            return null;
        }
        return new Location(world, this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    public double distance(@NonNull DecentLocation location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return Math.sqrt(this.distanceSquared(location));
    }

    public double distanceSquared(@NonNull DecentLocation location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (!this.isSameWorld(location)) {
            throw new IllegalArgumentException("Cannot calculate distance between locations in different worlds");
        }
        double dx = this.getX() - location.getX();
        double dy = this.getY() - location.getY();
        double dz = this.getZ() - location.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public boolean isSameWorld(@NonNull DecentLocation location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return this.getWorldName().equals(location.getWorldName());
    }

    public boolean isInWorld(@NonNull World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return this.getWorldName().equals(world.getName());
    }

    public DecentLocation clone() {
        return new DecentLocation(this.getWorldName(), this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(Object obj) {
        if (!(obj instanceof DecentLocation)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        DecentLocation other = (DecentLocation)obj;
        return this.getWorldName().equals(other.getWorldName()) && this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ() && this.getYaw() == other.getYaw() && this.getPitch() == other.getPitch();
    }

    public int hashCode() {
        return Objects.hash(this.getWorldName(), this.getX(), this.getY(), this.getZ(), Float.valueOf(this.getYaw()), Float.valueOf(this.getPitch()));
    }

    public String toString() {
        return "ThreadSafeLocation{world=" + this.getWorldName() + ",x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + ",yaw=" + this.getYaw() + ",pitch=" + this.getPitch() + "}";
    }
}

