/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.config;

import eu.decentsoftware.holograms.api.utils.Common;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class FileConfig
extends YamlConfiguration {
    @NotNull
    protected final JavaPlugin plugin;
    @NotNull
    protected final String path;
    @NotNull
    protected final File file;

    public FileConfig(@NotNull JavaPlugin plugin, @NotNull String path) {
        this.plugin = plugin;
        this.path = path;
        this.file = new File(plugin.getDataFolder(), path);
        this.createFile();
        this.reload();
    }

    public FileConfig(@NotNull JavaPlugin plugin, @NotNull File file) {
        this.plugin = plugin;
        this.path = file.getName();
        this.file = file;
        this.createFile();
        this.reload();
    }

    public void createFile() {
        if (!this.file.exists()) {
            this.plugin.getDataFolder().mkdirs();
            if (this.plugin.getResource(this.path) == null) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.plugin.saveResource(this.path, false);
            }
        }
    }

    public void saveData() {
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        try {
            this.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void delete() {
        if (this.file.exists() && !this.file.delete()) {
            Common.log(Level.WARNING, "Cannot delete existing file '%s' (Permission issue?)", this.file.getName());
        }
    }

    @NotNull
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public File getFile() {
        return this.file;
    }
}

