/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils;

import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.collection.DList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.jetbrains.annotations.Contract;

public class DExecutor {
    private static boolean initialized = false;
    private static ExecutorService service;
    @NonNull
    private final ExecutorService executor;
    @NonNull
    private final DList<CompletableFuture<Void>> running;

    public static void init(int threads) {
        if (!initialized) {
            AtomicInteger threadId = new AtomicInteger(0);
            service = Executors.newFixedThreadPool(threads, runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName("DecentHolograms Thread #" + threadId.incrementAndGet());
                thread.setPriority(5);
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler((t, ex) -> {
                    Common.log("Exception encountered in " + t.getName());
                    ex.printStackTrace();
                });
                return thread;
            });
            initialized = true;
        }
    }

    public static void shutdown() {
        service.shutdown();
        initialized = false;
    }

    public static void shutdownNow() {
        service.shutdownNow();
        initialized = false;
    }

    public static void schedule(Runnable ... runnables) {
        if (!initialized) {
            throw new IllegalStateException("DExecutor is not initialized!");
        }
        if (runnables == null || runnables.length == 0) {
            return;
        }
        DExecutor.create(runnables.length).queue(runnables).complete();
    }

    @NonNull
    @Contract(value="_ -> new")
    public static DExecutor create(int estimate) {
        if (!initialized) {
            throw new IllegalStateException("DExecutor is not initialized!");
        }
        return new DExecutor(service, estimate);
    }

    public static void execute(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        service.execute(runnable);
    }

    DExecutor(@NonNull ExecutorService executor, int estimate) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.executor = executor;
        this.running = new DList(estimate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> queue(@NonNull Runnable r) {
        if (r == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        DList<CompletableFuture<Void>> dList = this.running;
        synchronized (dList) {
            CompletableFuture<Void> c = CompletableFuture.runAsync(r, this.executor);
            this.running.add(c);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DExecutor queue(Runnable ... runnables) {
        if (runnables == null || runnables.length == 0) {
            return this;
        }
        DList<CompletableFuture<Void>> dList = this.running;
        synchronized (dList) {
            for (Runnable runnable : runnables) {
                CompletableFuture<Void> future = CompletableFuture.runAsync(runnable, this.executor);
                this.running.add(future);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        DList<CompletableFuture<Void>> dList = this.running;
        synchronized (dList) {
            try {
                CompletableFuture.allOf(this.running.toArray(new CompletableFuture[0])).get();
                this.running.clear();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

