/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils;

import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.utils.color.IridiumColorAPI;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public final class Common {
    public static final String NAME_REGEX = "[a-zA-Z0-9_-]+";
    private static final Pattern SPACING_CHARS_REGEX = Pattern.compile("[_ \\-]+");
    public static String PREFIX = "&8[&3DecentHolograms&8] &7";

    public static String colorize(String string) {
        return IridiumColorAPI.process(string);
    }

    public static List<String> colorize(List<String> list) {
        list.replaceAll(Common::colorize);
        return list;
    }

    public static String stripColors(String string) {
        return ChatColor.stripColor((String)IridiumColorAPI.stripColorFormatting(string));
    }

    public static void log(String message) {
        Common.log(Level.INFO, message);
    }

    public static void log(String message, Object ... args) {
        Common.log(String.format(message, args));
    }

    public static void log(Level level, String message) {
        Bukkit.getServer().getLogger().log(level, "[DecentHolograms] {0}", message);
    }

    public static void log(Level level, String message, Object ... args) {
        Common.log(level, String.format(message, args));
    }

    public static void tell(CommandSender player, String message) {
        player.sendMessage(Common.colorize(message));
    }

    public static void tell(CommandSender player, String message, Object ... args) {
        Common.tell(player, String.format(message, args));
    }

    public static String removeSpacingChars(String string) {
        return SPACING_CHARS_REGEX.matcher(string).replaceAll("");
    }

    public static boolean isVersionHigher(String version) {
        if (version == null || !version.matches("(\\d+)\\.(\\d+)\\.(\\d+)(\\.(\\d+))?")) {
            return false;
        }
        String current = DecentHologramsAPI.get().getPlugin().getDescription().getVersion();
        int[] i1 = Common.splitVersion(version);
        int[] i2 = Common.splitVersion(current);
        if (i1.length < 3 || i2.length < 3) {
            return false;
        }
        return i1[0] > i2[0] || i1[0] == i2[0] && i1[1] > i2[1] || i1[0] == i2[0] && i1[1] == i2[1] && i1[2] > i2[2];
    }

    private static int[] splitVersion(String version) {
        String[] spl;
        String[] stringArray = spl = version == null ? null : version.split("\\.");
        if (spl == null || spl.length < 3) {
            return new int[0];
        }
        int[] arr = new int[spl.length];
        for (int i = 0; i < spl.length; ++i) {
            arr[i] = Common.parseInt(spl[i]);
        }
        return arr;
    }

    private static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static boolean isPluginEnabled(String name) {
        return Bukkit.getPluginManager().isPluginEnabled(name);
    }

    private Common() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

