/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.nms.versions;

import com.google.common.collect.Lists;
import eu.decentsoftware.holograms.api.nms.NMS;
import eu.decentsoftware.holograms.api.utils.RandomUtils;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectConstructor;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectField;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectMethod;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectionUtil;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NMS_1_9
extends NMS {
    private static final int ARMOR_STAND_ID = Version.before(13) ? 30 : 1;
    private static int DROPPED_ITEM_ID = 2;
    private static final Class<?> ENTITY_CLASS;
    private static final Class<?> ITEM_STACK_CLASS;
    private static final Class<?> ENTITY_ARMOR_STAND_CLASS;
    private static final Class<?> ENTITY_ITEM_CLASS;
    private static final Class<?> ENUM_ITEM_SLOT_CLASS;
    private static final ReflectMethod ENUM_ITEM_SLOT_FROM_NAME_METHOD;
    private static final ReflectMethod CRAFT_ITEM_NMS_COPY_METHOD;
    private static final ReflectMethod CRAFT_CHAT_MESSAGE_FROM_STRING_METHOD;
    private static final ReflectMethod PAIR_OF_METHOD;
    private static final Class<?> DATA_WATCHER_CLASS;
    private static final ReflectConstructor DATA_WATCHER_CONSTRUCTOR;
    private static final ReflectMethod DATA_WATCHER_REGISTER_METHOD;
    private static final Class<?> MATH_HELPER_CLASS;
    private static final ReflectMethod MATH_HELPER_D_METHOD;
    private static final ReflectMethod MATH_HELPER_A_METHOD;
    private static final ReflectConstructor PACKET_SPAWN_ENTITY_CONSTRUCTOR;
    private static final ReflectConstructor PACKET_SPAWN_ENTITY_LIVING_CONSTRUCTOR;
    private static final ReflectConstructor PACKET_ENTITY_METADATA_CONSTRUCTOR;
    private static final ReflectConstructor PACKET_ENTITY_TELEPORT_CONSTRUCTOR;
    private static final ReflectConstructor PACKET_MOUNT_CONSTRUCTOR;
    private static final ReflectConstructor PACKET_ENTITY_EQUIPMENT_CONSTRUCTOR;
    private static final ReflectConstructor PACKET_ENTITY_DESTROY_CONSTRUCTOR;
    private static final Class<?> DWO_CLASS;
    private static final Object DWO_CUSTOM_NAME;
    private static final Object DWO_CUSTOM_NAME_VISIBLE;
    private static final Object DWO_ENTITY_DATA;
    private static final Object DWO_ARMOR_STAND_DATA;
    private static final Object DWO_ITEM;
    private static Class<?> ENTITY_TYPES_CLASS;
    private static ReflectField<?> I_REGISTRY_ENTITY_TYPE_FIELD;
    private static ReflectMethod ENTITY_TYPES_A_METHOD;
    private static ReflectMethod ENTITY_TYPE_GET_KEY_METHOD;
    private static ReflectMethod REGISTRY_BLOCKS_GET_ID_METHOD;
    private static ReflectMethod REGISTRY_BLOCKS_FROM_ID_METHOD;
    private static ReflectMethod NAMESPACED_KEY_GET_KEY_METHOD;
    private static ReflectMethod ENTITY_TYPES_GET_SIZE_METHOD;
    private static ReflectField<Float> ENTITY_SIZE_HEIGHT_FIELD;
    private static final ReflectField<Object> ENTITY_COUNTER_FIELD;
    private static Object ENUM_ITEM_SLOT_HEAD;

    @Override
    public int getFreeEntityId() {
        Object entityCounter = ENTITY_COUNTER_FIELD.getValue(null);
        if (entityCounter instanceof AtomicInteger) {
            return ((AtomicInteger)ENTITY_COUNTER_FIELD.getValue(null)).addAndGet(1);
        }
        ENTITY_COUNTER_FIELD.setValue(null, (Integer)entityCounter + 1);
        return (Integer)entityCounter;
    }

    @Override
    public int getEntityTypeId(EntityType type) {
        if (Version.before(14)) {
            return super.getEntityTypeId(type);
        }
        if (type == null) {
            return -1;
        }
        Object namespacedKey = ENTITY_TYPE_GET_KEY_METHOD.invoke(type, new Object[0]);
        String key = (String)NAMESPACED_KEY_GET_KEY_METHOD.invoke(namespacedKey, new Object[0]);
        Optional entityTypes = (Optional)ENTITY_TYPES_A_METHOD.invokeStatic(key.toLowerCase());
        return entityTypes.map(entityType -> {
            Object registryBlocks = I_REGISTRY_ENTITY_TYPE_FIELD.getValue(null);
            return (Integer)REGISTRY_BLOCKS_GET_ID_METHOD.invoke(registryBlocks, entityType);
        }).orElse(-1);
    }

    @Override
    public float getEntityHeight(EntityType type) {
        if (Version.before(14)) {
            return super.getEntityHeight(type);
        }
        if (type == null) {
            return 0.0f;
        }
        Object namespacedKey = ENTITY_TYPE_GET_KEY_METHOD.invoke(type, new Object[0]);
        String key = (String)NAMESPACED_KEY_GET_KEY_METHOD.invoke(namespacedKey, new Object[0]);
        Optional entityTypes = (Optional)ENTITY_TYPES_A_METHOD.invokeStatic(key.toLowerCase());
        return entityTypes.map(entityType -> {
            Object entitySize = ENTITY_TYPES_GET_SIZE_METHOD.invoke(entityType, new Object[0]);
            return ENTITY_SIZE_HEIGHT_FIELD.getValue(entitySize);
        }).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void showFakeEntity(Player player, Location location, EntityType entityType, int entityId) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)location);
        Validate.notNull((Object)entityType);
        this.showFakeEntity(player, location, this.getEntityTypeId(entityType), entityId);
    }

    @Override
    public void showFakeEntityLiving(Player player, Location location, EntityType entityType, int entityId) {
        Object dataWatcher = DATA_WATCHER_CONSTRUCTOR.newInstance(ENTITY_CLASS.cast(null));
        DATA_WATCHER_REGISTER_METHOD.invoke(dataWatcher, DWO_ENTITY_DATA, (byte)0);
        this.showFakeEntityLiving(player, location, this.getEntityTypeId(entityType), entityId, dataWatcher);
    }

    @Override
    public void showFakeEntityArmorStand(Player player, Location location, int entityId, boolean invisible, boolean small, boolean clickable) {
        Object dataWatcher = DATA_WATCHER_CONSTRUCTOR.newInstance(ENTITY_CLASS.cast(null));
        DATA_WATCHER_REGISTER_METHOD.invoke(dataWatcher, DWO_ENTITY_DATA, (byte)(invisible ? 32 : 0));
        byte data = 8;
        if (small) {
            data = (byte)(data + 1);
        }
        if (!clickable) {
            data = (byte)(data + 16);
        }
        DATA_WATCHER_REGISTER_METHOD.invoke(dataWatcher, DWO_ARMOR_STAND_DATA, data);
        this.showFakeEntityLiving(player, location, ARMOR_STAND_ID, entityId, dataWatcher);
        this.sendPacket(player, PACKET_ENTITY_METADATA_CONSTRUCTOR.newInstance(entityId, dataWatcher, true));
    }

    @Override
    public void showFakeEntityItem(Player player, Location location, ItemStack itemStack, int entityId) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)location);
        Validate.notNull((Object)itemStack);
        Object nmsItemStack = CRAFT_ITEM_NMS_COPY_METHOD.invokeStatic(itemStack);
        Object dataWatcher = DATA_WATCHER_CONSTRUCTOR.newInstance(ENTITY_CLASS.cast(null));
        if (nmsItemStack == null || dataWatcher == null) {
            return;
        }
        if (Version.before(11)) {
            DATA_WATCHER_REGISTER_METHOD.invoke(dataWatcher, DWO_ITEM, com.google.common.base.Optional.fromNullable(nmsItemStack));
        } else {
            DATA_WATCHER_REGISTER_METHOD.invoke(dataWatcher, DWO_ITEM, nmsItemStack);
        }
        this.showFakeEntity(player, location, DROPPED_ITEM_ID, entityId);
        this.sendPacket(player, PACKET_ENTITY_METADATA_CONSTRUCTOR.newInstance(entityId, dataWatcher, true));
        this.teleportFakeEntity(player, location, entityId);
    }

    @Override
    public void updateFakeEntityCustomName(Player player, String name, int entityId) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)name);
        Object dataWatcher = DATA_WATCHER_CONSTRUCTOR.newInstance(ENTITY_CLASS.cast(null));
        if (Version.before(13)) {
            DATA_WATCHER_REGISTER_METHOD.invoke(dataWatcher, DWO_CUSTOM_NAME, name);
        } else {
            DATA_WATCHER_REGISTER_METHOD.invoke(dataWatcher, DWO_CUSTOM_NAME, Optional.ofNullable(CRAFT_CHAT_MESSAGE_FROM_STRING_METHOD.invokeStatic(name)));
        }
        DATA_WATCHER_REGISTER_METHOD.invoke(dataWatcher, DWO_CUSTOM_NAME_VISIBLE, !ChatColor.stripColor((String)name).isEmpty());
        this.sendPacket(player, PACKET_ENTITY_METADATA_CONSTRUCTOR.newInstance(entityId, dataWatcher, true));
    }

    @Override
    public void teleportFakeEntity(Player player, Location location, int entityId) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)location);
        Object teleport = PACKET_ENTITY_TELEPORT_CONSTRUCTOR.newInstance(new Object[0]);
        if (teleport == null) {
            return;
        }
        ReflectionUtil.setFieldValue(teleport, "a", entityId);
        ReflectionUtil.setFieldValue(teleport, "b", location.getX());
        ReflectionUtil.setFieldValue(teleport, "c", location.getY());
        ReflectionUtil.setFieldValue(teleport, "d", location.getZ());
        ReflectionUtil.setFieldValue(teleport, "e", (byte)(location.getYaw() * 256.0f / 360.0f));
        ReflectionUtil.setFieldValue(teleport, "f", (byte)(location.getPitch() * 256.0f / 360.0f));
        ReflectionUtil.setFieldValue(teleport, "g", false);
        this.sendPacket(player, teleport);
    }

    @Override
    public void helmetFakeEntity(Player player, ItemStack itemStack, int entityId) {
        Object packet;
        Validate.notNull((Object)player);
        Validate.notNull((Object)itemStack);
        if (ENUM_ITEM_SLOT_HEAD == null) {
            ENUM_ITEM_SLOT_HEAD = ENUM_ITEM_SLOT_FROM_NAME_METHOD.invokeStatic("head");
        }
        Object nmsItemStack = CRAFT_ITEM_NMS_COPY_METHOD.invokeStatic(itemStack);
        if (Version.afterOrEqual(16)) {
            Object pair = PAIR_OF_METHOD.invokeStatic(ENUM_ITEM_SLOT_HEAD, nmsItemStack);
            packet = PACKET_ENTITY_EQUIPMENT_CONSTRUCTOR.newInstance(entityId, Lists.newArrayList((Object[])new Object[]{pair}));
        } else {
            packet = PACKET_ENTITY_EQUIPMENT_CONSTRUCTOR.newInstance(entityId, ENUM_ITEM_SLOT_HEAD, nmsItemStack);
        }
        this.sendPacket(player, packet);
    }

    @Override
    public void attachFakeEntity(Player player, int vehicleId, int entityId) {
        Validate.notNull((Object)player);
        Object packet = PACKET_MOUNT_CONSTRUCTOR.newInstance(new Object[0]);
        if (packet == null) {
            return;
        }
        ReflectionUtil.setFieldValue(packet, "a", vehicleId);
        ReflectionUtil.setFieldValue(packet, "b", new int[]{entityId});
        this.sendPacket(player, packet);
    }

    @Override
    public void hideFakeEntities(Player player, int ... entityIds) {
        Validate.notNull((Object)player);
        this.sendPacket(player, PACKET_ENTITY_DESTROY_CONSTRUCTOR.newInstance(new Object[]{entityIds}));
    }

    private void showFakeEntityLiving(Player player, Location location, int entityTypeId, int entityId, Object dataWatcher) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)location);
        if (dataWatcher == null || !DATA_WATCHER_CLASS.isAssignableFrom(dataWatcher.getClass())) {
            return;
        }
        if (entityTypeId == -1) {
            return;
        }
        Object spawn = PACKET_SPAWN_ENTITY_LIVING_CONSTRUCTOR.newInstance(new Object[0]);
        if (spawn == null) {
            return;
        }
        ReflectionUtil.setFieldValue(spawn, "a", entityId);
        ReflectionUtil.setFieldValue(spawn, "b", MATH_HELPER_A_METHOD.invokeStatic(RandomUtils.RANDOM));
        ReflectionUtil.setFieldValue(spawn, "c", entityTypeId);
        ReflectionUtil.setFieldValue(spawn, "d", location.getX());
        ReflectionUtil.setFieldValue(spawn, "e", location.getY());
        ReflectionUtil.setFieldValue(spawn, "f", location.getZ());
        ReflectionUtil.setFieldValue(spawn, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
        ReflectionUtil.setFieldValue(spawn, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
        ReflectionUtil.setFieldValue(spawn, "l", (byte)(location.getYaw() * 256.0f / 360.0f));
        ReflectionUtil.setFieldValue(spawn, "m", dataWatcher);
        this.sendPacket(player, spawn);
    }

    public void showFakeEntity(Player player, Location location, int entityTypeId, int entityId) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)location);
        if (entityTypeId == -1) {
            return;
        }
        Object spawn = PACKET_SPAWN_ENTITY_CONSTRUCTOR.newInstance(new Object[0]);
        if (spawn == null) {
            return;
        }
        ReflectionUtil.setFieldValue(spawn, "a", entityId);
        ReflectionUtil.setFieldValue(spawn, "b", MATH_HELPER_A_METHOD.invokeStatic(RandomUtils.RANDOM));
        ReflectionUtil.setFieldValue(spawn, "c", location.getX());
        ReflectionUtil.setFieldValue(spawn, "d", location.getY());
        ReflectionUtil.setFieldValue(spawn, "e", location.getZ());
        ReflectionUtil.setFieldValue(spawn, "i", MATH_HELPER_D_METHOD.invokeStatic(Float.valueOf(location.getPitch() * 256.0f / 360.0f)));
        ReflectionUtil.setFieldValue(spawn, "j", MATH_HELPER_D_METHOD.invokeStatic(Float.valueOf(location.getYaw() * 256.0f / 360.0f)));
        ReflectionUtil.setFieldValue(spawn, "k", Version.afterOrEqual(14) ? ENTITY_TYPES_CLASS.cast(REGISTRY_BLOCKS_FROM_ID_METHOD.invoke(I_REGISTRY_ENTITY_TYPE_FIELD.getValue(null), entityTypeId)) : Integer.valueOf(entityTypeId));
        this.sendPacket(player, spawn);
    }

    static {
        DWO_CLASS = ReflectionUtil.getNMSClass("DataWatcherObject");
        ENTITY_CLASS = ReflectionUtil.getNMSClass("Entity");
        ITEM_STACK_CLASS = ReflectionUtil.getNMSClass("ItemStack");
        ENTITY_ARMOR_STAND_CLASS = ReflectionUtil.getNMSClass("EntityArmorStand");
        ENTITY_ITEM_CLASS = ReflectionUtil.getNMSClass("EntityItem");
        ENUM_ITEM_SLOT_CLASS = ReflectionUtil.getNMSClass("EnumItemSlot");
        ENUM_ITEM_SLOT_FROM_NAME_METHOD = new ReflectMethod(ENUM_ITEM_SLOT_CLASS, Version.afterOrEqual(14) ? "fromName" : "a", String.class);
        CRAFT_ITEM_NMS_COPY_METHOD = new ReflectMethod(ReflectionUtil.getObcClass("inventory.CraftItemStack"), "asNMSCopy", ItemStack.class);
        CRAFT_CHAT_MESSAGE_FROM_STRING_METHOD = new ReflectMethod(ReflectionUtil.getObcClass("util.CraftChatMessage"), "fromStringOrNull", String.class);
        DATA_WATCHER_CLASS = ReflectionUtil.getNMSClass("DataWatcher");
        DATA_WATCHER_CONSTRUCTOR = new ReflectConstructor(DATA_WATCHER_CLASS, ENTITY_CLASS);
        DATA_WATCHER_REGISTER_METHOD = new ReflectMethod(DATA_WATCHER_CLASS, "register", DWO_CLASS, Object.class);
        MATH_HELPER_CLASS = ReflectionUtil.getNMSClass("MathHelper");
        MATH_HELPER_D_METHOD = new ReflectMethod(MATH_HELPER_CLASS, "d", Float.TYPE);
        MATH_HELPER_A_METHOD = new ReflectMethod(MATH_HELPER_CLASS, "a", Random.class);
        PACKET_SPAWN_ENTITY_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutSpawnEntity"), new Class[0]);
        PACKET_SPAWN_ENTITY_LIVING_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutSpawnEntityLiving"), new Class[0]);
        PACKET_ENTITY_METADATA_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutEntityMetadata"), Integer.TYPE, DATA_WATCHER_CLASS, Boolean.TYPE);
        PACKET_ENTITY_TELEPORT_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutEntityTeleport"), new Class[0]);
        PACKET_MOUNT_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutMount"), new Class[0]);
        if (Version.afterOrEqual(16)) {
            PACKET_ENTITY_EQUIPMENT_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutEntityEquipment"), Integer.TYPE, List.class);
            PAIR_OF_METHOD = new ReflectMethod(ReflectionUtil.getClass("com.mojang.datafixers.util.Pair"), "of", Object.class, Object.class);
        } else {
            PACKET_ENTITY_EQUIPMENT_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutEntityEquipment"), Integer.TYPE, ENUM_ITEM_SLOT_CLASS, ITEM_STACK_CLASS);
            PAIR_OF_METHOD = null;
        }
        PACKET_ENTITY_DESTROY_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutEntityDestroy"), int[].class);
        switch (Version.CURRENT) {
            case v1_9_R1: {
                DWO_ENTITY_DATA = new ReflectField(ENTITY_CLASS, "ax").getValue(null);
                DWO_CUSTOM_NAME = new ReflectField(ENTITY_CLASS, "az").getValue(null);
                DWO_CUSTOM_NAME_VISIBLE = new ReflectField(ENTITY_CLASS, "aA").getValue(null);
                break;
            }
            case v1_9_R2: {
                DWO_ENTITY_DATA = new ReflectField(ENTITY_CLASS, "ay").getValue(null);
                DWO_CUSTOM_NAME = new ReflectField(ENTITY_CLASS, "aA").getValue(null);
                DWO_CUSTOM_NAME_VISIBLE = new ReflectField(ENTITY_CLASS, "aB").getValue(null);
                break;
            }
            case v1_10_R1: {
                DWO_ENTITY_DATA = new ReflectField(ENTITY_CLASS, "aa").getValue(null);
                DWO_CUSTOM_NAME = new ReflectField(ENTITY_CLASS, "aA").getValue(null);
                DWO_CUSTOM_NAME_VISIBLE = new ReflectField(ENTITY_CLASS, "aB").getValue(null);
                break;
            }
            case v1_11_R1: {
                DWO_ENTITY_DATA = new ReflectField(ENTITY_CLASS, "Z").getValue(null);
                DWO_CUSTOM_NAME = new ReflectField(ENTITY_CLASS, "aA").getValue(null);
                DWO_CUSTOM_NAME_VISIBLE = new ReflectField(ENTITY_CLASS, "aB").getValue(null);
                break;
            }
            case v1_12_R1: {
                DWO_ENTITY_DATA = new ReflectField(ENTITY_CLASS, "Z").getValue(null);
                DWO_CUSTOM_NAME = new ReflectField(ENTITY_CLASS, "aB").getValue(null);
                DWO_CUSTOM_NAME_VISIBLE = new ReflectField(ENTITY_CLASS, "aC").getValue(null);
                break;
            }
            case v1_13_R1: 
            case v1_13_R2: {
                DWO_ENTITY_DATA = new ReflectField(ENTITY_CLASS, "ac").getValue(null);
                DWO_CUSTOM_NAME = new ReflectField(ENTITY_CLASS, "aE").getValue(null);
                DWO_CUSTOM_NAME_VISIBLE = new ReflectField(ENTITY_CLASS, "aF").getValue(null);
                DROPPED_ITEM_ID = 34;
                break;
            }
            case v1_14_R1: {
                DWO_ENTITY_DATA = new ReflectField(ENTITY_CLASS, "W").getValue(null);
                DWO_CUSTOM_NAME = new ReflectField(ENTITY_CLASS, "az").getValue(null);
                DWO_CUSTOM_NAME_VISIBLE = new ReflectField(ENTITY_CLASS, "aA").getValue(null);
                DROPPED_ITEM_ID = 34;
                break;
            }
            case v1_15_R1: {
                DWO_ENTITY_DATA = new ReflectField(ENTITY_CLASS, "T").getValue(null);
                DWO_CUSTOM_NAME = new ReflectField(ENTITY_CLASS, "az").getValue(null);
                DWO_CUSTOM_NAME_VISIBLE = new ReflectField(ENTITY_CLASS, "aA").getValue(null);
                DROPPED_ITEM_ID = 35;
                break;
            }
            case v1_16_R1: {
                DWO_ENTITY_DATA = new ReflectField(ENTITY_CLASS, "T").getValue(null);
                DWO_CUSTOM_NAME = new ReflectField(ENTITY_CLASS, "ax").getValue(null);
                DWO_CUSTOM_NAME_VISIBLE = new ReflectField(ENTITY_CLASS, "ay").getValue(null);
                DROPPED_ITEM_ID = 37;
                break;
            }
            case v1_16_R2: 
            case v1_16_R3: {
                DWO_ENTITY_DATA = new ReflectField(ENTITY_CLASS, "S").getValue(null);
                DWO_CUSTOM_NAME = new ReflectField(ENTITY_CLASS, "aq").getValue(null);
                DWO_CUSTOM_NAME_VISIBLE = new ReflectField(ENTITY_CLASS, "ar").getValue(null);
                DROPPED_ITEM_ID = 37;
                break;
            }
            default: {
                DWO_ENTITY_DATA = null;
                DWO_CUSTOM_NAME = null;
                DWO_CUSTOM_NAME_VISIBLE = null;
            }
        }
        if (Version.before(13)) {
            DWO_ARMOR_STAND_DATA = new ReflectField(ENTITY_ARMOR_STAND_CLASS, "a").getValue(null);
            DWO_ITEM = new ReflectField(ENTITY_ITEM_CLASS, "c").getValue(null);
        } else if (Version.before(14)) {
            DWO_ARMOR_STAND_DATA = new ReflectField(ENTITY_ARMOR_STAND_CLASS, "a").getValue(null);
            DWO_ITEM = new ReflectField(ENTITY_ITEM_CLASS, "b").getValue(null);
        } else {
            DWO_ARMOR_STAND_DATA = new ReflectField(ENTITY_ARMOR_STAND_CLASS, "b").getValue(null);
            DWO_ITEM = new ReflectField(ENTITY_ITEM_CLASS, "ITEM").getValue(null);
            Class<?> registryBlocksClass = ReflectionUtil.getNMSClass("RegistryBlocks");
            ENTITY_TYPES_CLASS = ReflectionUtil.getNMSClass("EntityTypes");
            I_REGISTRY_ENTITY_TYPE_FIELD = new ReflectField(ReflectionUtil.getNMSClass("IRegistry"), "ENTITY_TYPE");
            ENTITY_TYPES_A_METHOD = new ReflectMethod(ENTITY_TYPES_CLASS, "a", String.class);
            ENTITY_TYPE_GET_KEY_METHOD = new ReflectMethod(EntityType.class, "getKey", new Class[0]);
            REGISTRY_BLOCKS_GET_ID_METHOD = new ReflectMethod(registryBlocksClass, "a", Object.class);
            REGISTRY_BLOCKS_FROM_ID_METHOD = new ReflectMethod(registryBlocksClass, "fromId", Integer.TYPE);
            NAMESPACED_KEY_GET_KEY_METHOD = new ReflectMethod(ReflectionUtil.getClass("org.bukkit.NamespacedKey"), "getKey", new Class[0]);
            for (Method method : ENTITY_TYPES_CLASS.getMethods()) {
                if (!method.getReturnType().getName().contains("EntitySize")) continue;
                ENTITY_TYPES_GET_SIZE_METHOD = new ReflectMethod(ENTITY_TYPES_CLASS, method.getName(), new Class[0]);
            }
            ENTITY_SIZE_HEIGHT_FIELD = new ReflectField(ReflectionUtil.getNMSClass("EntitySize"), "height");
        }
        ENTITY_COUNTER_FIELD = new ReflectField(ENTITY_CLASS, "entityCount");
    }
}

