/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.nms.versions;

import eu.decentsoftware.holograms.api.nms.NMS;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectConstructor;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectField;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectMethod;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectionUtil;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NMS_1_8
extends NMS {
    private static final Class<?> ENTITY_CLASS = ReflectionUtil.getNMSClass("Entity");
    private static final Class<?> ITEM_STACK_CLASS = ReflectionUtil.getNMSClass("ItemStack");
    private static final ReflectMethod CRAFT_ITEM_NMS_COPY_METHOD = new ReflectMethod(ReflectionUtil.getObcClass("inventory.CraftItemStack"), "asNMSCopy", ItemStack.class);
    private static final Class<?> DATA_WATCHER_CLASS = ReflectionUtil.getNMSClass("DataWatcher");
    private static final ReflectConstructor DATA_WATCHER_CONSTRUCTOR = new ReflectConstructor(DATA_WATCHER_CLASS, ENTITY_CLASS);
    private static final ReflectMethod DATA_WATCHER_A_METHOD = new ReflectMethod(DATA_WATCHER_CLASS, "a", Integer.TYPE, Object.class);
    private static final Class<?> MATH_HELPER_CLASS = ReflectionUtil.getNMSClass("MathHelper");
    private static final ReflectMethod MATH_HELPER_FLOOR_METHOD = new ReflectMethod(MATH_HELPER_CLASS, "floor", Double.TYPE);
    private static final ReflectMethod MATH_HELPER_D_METHOD = new ReflectMethod(MATH_HELPER_CLASS, "d", Float.TYPE);
    private static final ReflectConstructor PACKET_SPAWN_ENTITY_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutSpawnEntity"), new Class[0]);
    private static final ReflectConstructor PACKET_SPAWN_ENTITY_LIVING_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutSpawnEntityLiving"), new Class[0]);
    private static final ReflectConstructor PACKET_ENTITY_METADATA_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutEntityMetadata"), Integer.TYPE, DATA_WATCHER_CLASS, Boolean.TYPE);
    private static final ReflectConstructor PACKET_ENTITY_TELEPORT_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutEntityTeleport"), new Class[0]);
    private static final ReflectConstructor PACKET_ATTACH_ENTITY_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutAttachEntity"), new Class[0]);
    private static final ReflectConstructor PACKET_ENTITY_EQUIPMENT_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutEntityEquipment"), Integer.TYPE, Integer.TYPE, ITEM_STACK_CLASS);
    private static final ReflectConstructor PACKET_ENTITY_DESTROY_CONSTRUCTOR = new ReflectConstructor(ReflectionUtil.getNMSClass("PacketPlayOutEntityDestroy"), int[].class);
    private static final ReflectField<Integer> ENTITY_COUNTER_FIELD = new ReflectField(ENTITY_CLASS, "entityCount");

    @Override
    public int getFreeEntityId() {
        int entityCount = ENTITY_COUNTER_FIELD.getValue(null);
        ENTITY_COUNTER_FIELD.setValue(null, entityCount + 1);
        return entityCount;
    }

    @Override
    public void showFakeEntity(Player player, Location location, EntityType entityType, int entityId) {
        Validate.notNull((Object)entityType);
        this.showFakeEntity(player, location, this.getEntityTypeId(entityType), entityId);
    }

    @Override
    public void showFakeEntityLiving(Player player, Location location, EntityType entityType, int entityId) {
        Object dataWatcher = DATA_WATCHER_CONSTRUCTOR.newInstance(ENTITY_CLASS.cast(null));
        DATA_WATCHER_A_METHOD.invoke(dataWatcher, 15, (byte)0);
        this.showFakeEntityLiving(player, location, this.getEntityTypeId(entityType), entityId, dataWatcher);
    }

    @Override
    public void showFakeEntityArmorStand(Player player, Location location, int entityId, boolean invisible, boolean small, boolean clickable) {
        Object dataWatcher = DATA_WATCHER_CONSTRUCTOR.newInstance(ENTITY_CLASS.cast(null));
        DATA_WATCHER_A_METHOD.invoke(dataWatcher, 0, (byte)(invisible ? 32 : 0));
        byte data = 8;
        if (small) {
            data = (byte)(data + 1);
        }
        if (!clickable) {
            data = (byte)(data + 16);
        }
        DATA_WATCHER_A_METHOD.invoke(dataWatcher, 10, data);
        this.showFakeEntityLiving(player, location, 30, entityId, dataWatcher);
    }

    @Override
    public void showFakeEntityItem(Player player, Location location, ItemStack itemStack, int entityId) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)location);
        Validate.notNull((Object)itemStack);
        Object nmsItemStack = CRAFT_ITEM_NMS_COPY_METHOD.invokeStatic(itemStack);
        Object dataWatcher = DATA_WATCHER_CONSTRUCTOR.newInstance(ENTITY_CLASS.cast(null));
        if (nmsItemStack == null || dataWatcher == null) {
            return;
        }
        DATA_WATCHER_A_METHOD.invoke(dataWatcher, 10, nmsItemStack);
        this.showFakeEntity(player, location, 2, entityId);
        this.sendPacket(player, PACKET_ENTITY_METADATA_CONSTRUCTOR.newInstance(entityId, dataWatcher, true));
        this.teleportFakeEntity(player, location, entityId);
    }

    @Override
    public void updateFakeEntityCustomName(Player player, String name, int entityId) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)name);
        Object dataWatcher = DATA_WATCHER_CONSTRUCTOR.newInstance(ENTITY_CLASS.cast(null));
        DATA_WATCHER_A_METHOD.invoke(dataWatcher, 2, name);
        DATA_WATCHER_A_METHOD.invoke(dataWatcher, 3, (byte)(!ChatColor.stripColor((String)name).isEmpty() ? 1 : 0));
        this.sendPacket(player, PACKET_ENTITY_METADATA_CONSTRUCTOR.newInstance(entityId, dataWatcher, true));
    }

    @Override
    public void teleportFakeEntity(Player player, Location location, int entityId) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)location);
        Object teleport = PACKET_ENTITY_TELEPORT_CONSTRUCTOR.newInstance(new Object[0]);
        if (teleport == null) {
            return;
        }
        ReflectionUtil.setFieldValue(teleport, "a", entityId);
        ReflectionUtil.setFieldValue(teleport, "b", MATH_HELPER_FLOOR_METHOD.invokeStatic(location.getX() * 32.0));
        ReflectionUtil.setFieldValue(teleport, "c", MATH_HELPER_FLOOR_METHOD.invokeStatic(location.getY() * 32.0));
        ReflectionUtil.setFieldValue(teleport, "d", MATH_HELPER_FLOOR_METHOD.invokeStatic(location.getZ() * 32.0));
        ReflectionUtil.setFieldValue(teleport, "e", (byte)(location.getYaw() * 256.0f / 360.0f));
        ReflectionUtil.setFieldValue(teleport, "f", (byte)(location.getPitch() * 256.0f / 360.0f));
        ReflectionUtil.setFieldValue(teleport, "g", false);
        this.sendPacket(player, teleport);
    }

    @Override
    public void helmetFakeEntity(Player player, ItemStack itemStack, int entityId) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)itemStack);
        Object nmsItemStack = CRAFT_ITEM_NMS_COPY_METHOD.invokeStatic(itemStack);
        if (nmsItemStack == null) {
            return;
        }
        Object packet = PACKET_ENTITY_EQUIPMENT_CONSTRUCTOR.newInstance(entityId, 4, nmsItemStack);
        if (packet == null) {
            return;
        }
        this.sendPacket(player, packet);
    }

    @Override
    public void attachFakeEntity(Player player, int vehicleId, int entityId) {
        Validate.notNull((Object)player);
        Object packet = PACKET_ATTACH_ENTITY_CONSTRUCTOR.newInstance(new Object[0]);
        if (packet == null) {
            return;
        }
        ReflectionUtil.setFieldValue(packet, "a", 0);
        ReflectionUtil.setFieldValue(packet, "b", entityId);
        ReflectionUtil.setFieldValue(packet, "c", vehicleId);
        this.sendPacket(player, packet);
    }

    @Override
    public void hideFakeEntities(Player player, int ... entityIds) {
        Validate.notNull((Object)player);
        this.sendPacket(player, PACKET_ENTITY_DESTROY_CONSTRUCTOR.newInstance(new Object[]{entityIds}));
    }

    public void showFakeEntity(Player player, Location location, int entityTypeId, int entityId) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)location);
        Object spawn = PACKET_SPAWN_ENTITY_CONSTRUCTOR.newInstance(new Object[0]);
        if (spawn == null) {
            return;
        }
        ReflectionUtil.setFieldValue(spawn, "a", entityId);
        ReflectionUtil.setFieldValue(spawn, "b", MATH_HELPER_FLOOR_METHOD.invokeStatic(location.getX() * 32.0));
        ReflectionUtil.setFieldValue(spawn, "c", MATH_HELPER_FLOOR_METHOD.invokeStatic(location.getY() * 32.0));
        ReflectionUtil.setFieldValue(spawn, "d", MATH_HELPER_FLOOR_METHOD.invokeStatic(location.getZ() * 32.0));
        ReflectionUtil.setFieldValue(spawn, "h", MATH_HELPER_D_METHOD.invokeStatic(Float.valueOf(location.getPitch() * 256.0f / 360.0f)));
        ReflectionUtil.setFieldValue(spawn, "i", MATH_HELPER_D_METHOD.invokeStatic(Float.valueOf(location.getYaw() * 256.0f / 360.0f)));
        ReflectionUtil.setFieldValue(spawn, "j", entityTypeId);
        this.sendPacket(player, spawn);
    }

    private void showFakeEntityLiving(Player player, Location location, int entityTypeId, int entityId, Object dataWatcher) {
        Validate.notNull((Object)player);
        Validate.notNull((Object)location);
        if (dataWatcher == null || !DATA_WATCHER_CLASS.isAssignableFrom(dataWatcher.getClass())) {
            return;
        }
        Object spawn = PACKET_SPAWN_ENTITY_LIVING_CONSTRUCTOR.newInstance(new Object[0]);
        if (spawn == null) {
            return;
        }
        ReflectionUtil.setFieldValue(spawn, "a", entityId);
        ReflectionUtil.setFieldValue(spawn, "b", entityTypeId);
        ReflectionUtil.setFieldValue(spawn, "c", MATH_HELPER_FLOOR_METHOD.invokeStatic(location.getX() * 32.0));
        ReflectionUtil.setFieldValue(spawn, "d", MATH_HELPER_FLOOR_METHOD.invokeStatic(location.getY() * 32.0));
        ReflectionUtil.setFieldValue(spawn, "e", MATH_HELPER_FLOOR_METHOD.invokeStatic(location.getZ() * 32.0));
        ReflectionUtil.setFieldValue(spawn, "i", (byte)(location.getYaw() * 256.0f / 360.0f));
        ReflectionUtil.setFieldValue(spawn, "j", (byte)(location.getPitch() * 256.0f / 360.0f));
        ReflectionUtil.setFieldValue(spawn, "k", (byte)(location.getYaw() * 256.0f / 360.0f));
        ReflectionUtil.setFieldValue(spawn, "l", dataWatcher);
        this.sendPacket(player, spawn);
    }
}

