/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.nms;

import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.actions.ClickType;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectConstructor;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectField;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectMethod;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectionUtil;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.bukkit.entity.Player;

public final class PacketHandlerCommon {
    protected static final Class<?> ENTITY_USE_PACKET_CLASS;
    protected static final ReflectField<Integer> ENTITY_USE_PACKET_ID_FIELD;
    private static final Class<?> PACKET_DATA_SERIALIZER_CLASS;
    private static final ReflectConstructor PACKET_DATA_SERIALIZER_CONSTRUCTOR;
    private static final ReflectMethod ENTITY_USE_PACKET_A_METHOD;
    private static final ReflectMethod PACKET_DATA_SERIALIZER_READ_INT_METHOD;

    public static boolean handlePacket(Object packet, Player player) {
        if (packet == null || !packet.getClass().isAssignableFrom(ENTITY_USE_PACKET_CLASS)) {
            return false;
        }
        int entityId = ENTITY_USE_PACKET_ID_FIELD.getValue(packet);
        ClickType clickType = PacketHandlerCommon.getClickType(packet, player);
        return DecentHologramsAPI.get().getHologramManager().onClick(player, entityId, clickType);
    }

    private static int getEntityUseActionOrdinal(Object packet) {
        Object packetDataSerializer = PACKET_DATA_SERIALIZER_CONSTRUCTOR.newInstance(Unpooled.buffer());
        ENTITY_USE_PACKET_A_METHOD.invoke(packet, packetDataSerializer);
        PACKET_DATA_SERIALIZER_READ_INT_METHOD.invoke(packetDataSerializer, new Object[0]);
        return (Integer)PACKET_DATA_SERIALIZER_READ_INT_METHOD.invoke(packetDataSerializer, new Object[0]);
    }

    private static ClickType getClickType(Object packet, Player player) {
        int ordinal = PacketHandlerCommon.getEntityUseActionOrdinal(packet);
        if (ordinal == 1) {
            return player.isSneaking() ? ClickType.SHIFT_LEFT : ClickType.LEFT;
        }
        return player.isSneaking() ? ClickType.SHIFT_RIGHT : ClickType.RIGHT;
    }

    private PacketHandlerCommon() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        if (Version.afterOrEqual(17)) {
            ENTITY_USE_PACKET_CLASS = ReflectionUtil.getNMClass("network.protocol.game.PacketPlayInUseEntity");
            PACKET_DATA_SERIALIZER_CLASS = ReflectionUtil.getNMClass("network.PacketDataSerializer");
        } else {
            ENTITY_USE_PACKET_CLASS = ReflectionUtil.getNMSClass("PacketPlayInUseEntity");
            PACKET_DATA_SERIALIZER_CLASS = ReflectionUtil.getNMSClass("PacketDataSerializer");
        }
        ENTITY_USE_PACKET_ID_FIELD = new ReflectField(ENTITY_USE_PACKET_CLASS, "a");
        PACKET_DATA_SERIALIZER_CONSTRUCTOR = new ReflectConstructor(PACKET_DATA_SERIALIZER_CLASS, ByteBuf.class);
        PACKET_DATA_SERIALIZER_READ_INT_METHOD = Version.afterOrEqual(Version.v1_19_R3) ? new ReflectMethod(PACKET_DATA_SERIALIZER_CLASS, "m", new Class[0]) : (Version.afterOrEqual(19) ? new ReflectMethod(PACKET_DATA_SERIALIZER_CLASS, "k", new Class[0]) : (Version.afterOrEqual(17) ? new ReflectMethod(PACKET_DATA_SERIALIZER_CLASS, "j", new Class[0]) : (Version.afterOrEqual(14) ? new ReflectMethod(PACKET_DATA_SERIALIZER_CLASS, "i", new Class[0]) : (Version.afterOrEqual(9) ? new ReflectMethod(PACKET_DATA_SERIALIZER_CLASS, "g", new Class[0]) : new ReflectMethod(PACKET_DATA_SERIALIZER_CLASS, "e", new Class[0])))));
        ENTITY_USE_PACKET_A_METHOD = Version.afterOrEqual(17) ? new ReflectMethod(ENTITY_USE_PACKET_CLASS, "a", PACKET_DATA_SERIALIZER_CLASS) : new ReflectMethod(ENTITY_USE_PACKET_CLASS, "b", PACKET_DATA_SERIALIZER_CLASS);
    }
}

