/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.nms;

import com.google.common.collect.Maps;
import eu.decentsoftware.holograms.api.nms.versions.NMS_1_17;
import eu.decentsoftware.holograms.api.nms.versions.NMS_1_8;
import eu.decentsoftware.holograms.api.nms.versions.NMS_1_9;
import eu.decentsoftware.holograms.api.utils.objects.Pair;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectField;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectMethod;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectionUtil;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class NMS {
    protected static final Map<String, Pair<Integer, Float>> mapEntityTypes;
    protected static final Class<?> PACKET_CLASS;
    protected static final ReflectMethod CRAFT_PLAYER_GET_HANDLE_METHOD;
    protected static final ReflectMethod PLAYER_CONNECTION_SEND_PACKET_METHOD;
    protected static ReflectField<?> ENTITY_PLAYER_CONNECTION_FIELD;
    protected static ReflectField<?> PLAYER_CONNECTION_NETWORK_MANAGER_FIELD;
    protected static ReflectField<?> NETWORK_MANAGER_CHANNEL_FIELD;
    private static NMS instance;

    public static void init() {
        instance = Version.before(9) ? new NMS_1_8() : (Version.before(17) ? new NMS_1_9() : new NMS_1_17());
    }

    protected Object getPlayerConnection(Player player) {
        Object entityPlayer = CRAFT_PLAYER_GET_HANDLE_METHOD.invoke(player, new Object[0]);
        return ENTITY_PLAYER_CONNECTION_FIELD.getValue(entityPlayer);
    }

    public void sendPacket(Player player, Object packet) {
        if (packet == null || !PACKET_CLASS.isAssignableFrom(packet.getClass())) {
            return;
        }
        Object playerConnection = this.getPlayerConnection(player);
        PLAYER_CONNECTION_SEND_PACKET_METHOD.invoke(playerConnection, packet);
    }

    public ChannelPipeline getPipeline(Player player) {
        Object playerConnection = this.getPlayerConnection(player);
        Object networkManager = PLAYER_CONNECTION_NETWORK_MANAGER_FIELD.getValue(playerConnection);
        Channel channel = (Channel)NETWORK_MANAGER_CHANNEL_FIELD.getValue(networkManager);
        return channel.pipeline();
    }

    public int getEntityTypeId(EntityType type) {
        if (type == null) {
            return -1;
        }
        String name = type.name();
        if (mapEntityTypes.containsKey(name)) {
            return mapEntityTypes.get(name).getKey();
        }
        return -1;
    }

    public float getEntityHeight(EntityType type) {
        if (type == null) {
            return 0.0f;
        }
        String name = type.name();
        if (mapEntityTypes.containsKey(name)) {
            return mapEntityTypes.get(name).getValue().floatValue();
        }
        return 0.0f;
    }

    public abstract int getFreeEntityId();

    public abstract void showFakeEntity(Player var1, Location var2, EntityType var3, int var4);

    public abstract void showFakeEntityLiving(Player var1, Location var2, EntityType var3, int var4);

    public abstract void showFakeEntityArmorStand(Player var1, Location var2, int var3, boolean var4, boolean var5, boolean var6);

    public abstract void showFakeEntityItem(Player var1, Location var2, ItemStack var3, int var4);

    public abstract void updateFakeEntityCustomName(Player var1, String var2, int var3);

    public abstract void teleportFakeEntity(Player var1, Location var2, int var3);

    public abstract void helmetFakeEntity(Player var1, ItemStack var2, int var3);

    public abstract void attachFakeEntity(Player var1, int var2, int var3);

    public abstract void hideFakeEntities(Player var1, int ... var2);

    public static NMS getInstance() {
        return instance;
    }

    static {
        Class<?> craftPlayerClass;
        Class<?> playerConnectionClass;
        mapEntityTypes = Maps.newHashMap();
        if (Version.afterOrEqual(17)) {
            Class<?> entityPlayerClass = ReflectionUtil.getNMClass("server.level.EntityPlayer");
            playerConnectionClass = ReflectionUtil.getNMClass("server.network.PlayerConnection");
            craftPlayerClass = ReflectionUtil.getObcClass("entity.CraftPlayer");
            Class<?> networkManagerClass = ReflectionUtil.getNMClass("network.NetworkManager");
            PACKET_CLASS = ReflectionUtil.getNMClass("network.protocol.Packet");
            for (Field field : entityPlayerClass.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(playerConnectionClass)) continue;
                ENTITY_PLAYER_CONNECTION_FIELD = new ReflectField(entityPlayerClass, field.getName());
                break;
            }
            for (Field field : playerConnectionClass.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(networkManagerClass)) continue;
                PLAYER_CONNECTION_NETWORK_MANAGER_FIELD = new ReflectField(playerConnectionClass, field.getName());
                break;
            }
            for (Field field : networkManagerClass.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(Channel.class)) continue;
                NETWORK_MANAGER_CHANNEL_FIELD = new ReflectField(networkManagerClass, field.getName());
                break;
            }
        } else {
            Class<?> entityPlayerClass = ReflectionUtil.getNMSClass("EntityPlayer");
            playerConnectionClass = ReflectionUtil.getNMSClass("PlayerConnection");
            craftPlayerClass = ReflectionUtil.getObcClass("entity.CraftPlayer");
            Class<?> networkManagerClass = ReflectionUtil.getNMSClass("NetworkManager");
            PACKET_CLASS = ReflectionUtil.getNMSClass("Packet");
            ENTITY_PLAYER_CONNECTION_FIELD = new ReflectField(entityPlayerClass, "playerConnection");
            PLAYER_CONNECTION_NETWORK_MANAGER_FIELD = new ReflectField(playerConnectionClass, "networkManager");
            NETWORK_MANAGER_CHANNEL_FIELD = new ReflectField(networkManagerClass, "channel");
        }
        CRAFT_PLAYER_GET_HANDLE_METHOD = new ReflectMethod(craftPlayerClass, "getHandle", new Class[0]);
        PLAYER_CONNECTION_SEND_PACKET_METHOD = Version.afterOrEqual(18) ? new ReflectMethod(playerConnectionClass, "a", PACKET_CLASS) : new ReflectMethod(playerConnectionClass, "sendPacket", PACKET_CLASS);
        if (Version.beforeOrEqual(12)) {
            mapEntityTypes.put("BAT", new Pair<Integer, Float>(65, Float.valueOf(0.9f)));
            mapEntityTypes.put("BLAZE", new Pair<Integer, Float>(61, Float.valueOf(1.8f)));
            mapEntityTypes.put("CAVE_SPIDER", new Pair<Integer, Float>(59, Float.valueOf(0.5f)));
            mapEntityTypes.put("CHICKEN", new Pair<Integer, Float>(93, Float.valueOf(0.7f)));
            mapEntityTypes.put("COW", new Pair<Integer, Float>(92, Float.valueOf(1.4f)));
            mapEntityTypes.put("CREEPER", new Pair<Integer, Float>(50, Float.valueOf(1.7f)));
            mapEntityTypes.put("DONKEY", new Pair<Integer, Float>(31, Float.valueOf(1.39648f)));
            mapEntityTypes.put("ELDER_GUARDIAN", new Pair<Integer, Float>(4, Float.valueOf(2.9f)));
            mapEntityTypes.put("ENDER_DRAGON", new Pair<Integer, Float>(63, Float.valueOf(8.0f)));
            mapEntityTypes.put("ENDERMAN", new Pair<Integer, Float>(58, Float.valueOf(2.9f)));
            mapEntityTypes.put("ENDERMITE", new Pair<Integer, Float>(67, Float.valueOf(0.3f)));
            mapEntityTypes.put("EVOKER", new Pair<Integer, Float>(34, Float.valueOf(1.95f)));
            mapEntityTypes.put("HORSE", new Pair<Integer, Float>(100, Float.valueOf(1.6f)));
            mapEntityTypes.put("HUSK", new Pair<Integer, Float>(23, Float.valueOf(1.95f)));
            mapEntityTypes.put("ILLUSIONER", new Pair<Integer, Float>(37, Float.valueOf(1.95f)));
            mapEntityTypes.put("LLAMA", new Pair<Integer, Float>(103, Float.valueOf(1.87f)));
            mapEntityTypes.put("MAGMA_CUBE", new Pair<Integer, Float>(62, Float.valueOf(0.51000005f)));
            mapEntityTypes.put("MULE", new Pair<Integer, Float>(32, Float.valueOf(1.6f)));
            mapEntityTypes.put("MUSHROOM_COW", new Pair<Integer, Float>(96, Float.valueOf(1.4f)));
            mapEntityTypes.put("OCELOT", new Pair<Integer, Float>(98, Float.valueOf(0.7f)));
            mapEntityTypes.put("PARROT", new Pair<Integer, Float>(105, Float.valueOf(0.9f)));
            mapEntityTypes.put("PIG", new Pair<Integer, Float>(90, Float.valueOf(0.9f)));
            mapEntityTypes.put("PIG_ZOMBIE", new Pair<Integer, Float>(57, Float.valueOf(1.8f)));
            mapEntityTypes.put("POLAR_BEAR", new Pair<Integer, Float>(102, Float.valueOf(1.4f)));
            mapEntityTypes.put("RABBIT", new Pair<Integer, Float>(101, Float.valueOf(0.5f)));
            mapEntityTypes.put("SHEEP", new Pair<Integer, Float>(91, Float.valueOf(1.3f)));
            mapEntityTypes.put("SILVERFISH", new Pair<Integer, Float>(60, Float.valueOf(0.3f)));
            mapEntityTypes.put("SKELETON", new Pair<Integer, Float>(51, Float.valueOf(1.99f)));
            mapEntityTypes.put("SKELETON_HORSE", new Pair<Integer, Float>(28, Float.valueOf(1.6f)));
            mapEntityTypes.put("SLIME", new Pair<Integer, Float>(55, Float.valueOf(0.51000005f)));
            mapEntityTypes.put("SNOWMAN", new Pair<Integer, Float>(97, Float.valueOf(1.9f)));
            mapEntityTypes.put("GUARDIAN", new Pair<Integer, Float>(68, Float.valueOf(0.85f)));
            mapEntityTypes.put("SPIDER", new Pair<Integer, Float>(52, Float.valueOf(0.9f)));
            mapEntityTypes.put("SQUID", new Pair<Integer, Float>(94, Float.valueOf(1.8f)));
            mapEntityTypes.put("STRAY", new Pair<Integer, Float>(6, Float.valueOf(1.99f)));
            mapEntityTypes.put("VEX", new Pair<Integer, Float>(35, Float.valueOf(0.95f)));
            mapEntityTypes.put("VILLAGER", new Pair<Integer, Float>(120, Float.valueOf(1.95f)));
            mapEntityTypes.put("IRON_GOLEM", new Pair<Integer, Float>(99, Float.valueOf(2.7f)));
            mapEntityTypes.put("VINDICATOR", new Pair<Integer, Float>(36, Float.valueOf(1.95f)));
            mapEntityTypes.put("WITCH", new Pair<Integer, Float>(66, Float.valueOf(1.95f)));
            mapEntityTypes.put("WITHER", new Pair<Integer, Float>(64, Float.valueOf(3.5f)));
            mapEntityTypes.put("WITHER_SKELETON", new Pair<Integer, Float>(5, Float.valueOf(2.4f)));
            mapEntityTypes.put("WOLF", new Pair<Integer, Float>(95, Float.valueOf(0.85f)));
            mapEntityTypes.put("ZOMBIE", new Pair<Integer, Float>(54, Float.valueOf(1.95f)));
            mapEntityTypes.put("ZOMBIE_HORSE", new Pair<Integer, Float>(29, Float.valueOf(1.6f)));
            mapEntityTypes.put("ZOMBIE_VILLAGER", new Pair<Integer, Float>(27, Float.valueOf(1.95f)));
            mapEntityTypes.put("ENDER_CRYSTAL", new Pair<Integer, Float>(200, Float.valueOf(2.0f)));
            mapEntityTypes.put("ARROW", new Pair<Integer, Float>(10, Float.valueOf(0.5f)));
            mapEntityTypes.put("SNOWBALL", new Pair<Integer, Float>(11, Float.valueOf(0.25f)));
            mapEntityTypes.put("EGG", new Pair<Integer, Float>(7, Float.valueOf(0.25f)));
            mapEntityTypes.put("FIREBALL", new Pair<Integer, Float>(12, Float.valueOf(1.0f)));
            mapEntityTypes.put("SMALL_FIREBALL", new Pair<Integer, Float>(13, Float.valueOf(0.3125f)));
            mapEntityTypes.put("ENDER_PEARL", new Pair<Integer, Float>(14, Float.valueOf(0.25f)));
            mapEntityTypes.put("ENDER_SIGNAL", new Pair<Integer, Float>(15, Float.valueOf(0.25f)));
            mapEntityTypes.put("FIREWORK", new Pair<Integer, Float>(22, Float.valueOf(0.25f)));
        } else {
            mapEntityTypes.put("BAT", new Pair<Integer, Float>(3, Float.valueOf(0.9f)));
            mapEntityTypes.put("BLAZE", new Pair<Integer, Float>(4, Float.valueOf(1.8f)));
            mapEntityTypes.put("CAVE_SPIDER", new Pair<Integer, Float>(6, Float.valueOf(0.5f)));
            mapEntityTypes.put("CHICKEN", new Pair<Integer, Float>(7, Float.valueOf(0.7f)));
            mapEntityTypes.put("COD", new Pair<Integer, Float>(8, Float.valueOf(0.3f)));
            mapEntityTypes.put("COW", new Pair<Integer, Float>(9, Float.valueOf(1.4f)));
            mapEntityTypes.put("CREEPER", new Pair<Integer, Float>(10, Float.valueOf(1.7f)));
            mapEntityTypes.put("DONKEY", new Pair<Integer, Float>(11, Float.valueOf(1.39648f)));
            mapEntityTypes.put("DOLPHIN", new Pair<Integer, Float>(12, Float.valueOf(0.6f)));
            mapEntityTypes.put("DROWNED", new Pair<Integer, Float>(14, Float.valueOf(1.95f)));
            mapEntityTypes.put("ELDER_GUARDIAN", new Pair<Integer, Float>(15, Float.valueOf(2.9f)));
            mapEntityTypes.put("ENDER_DRAGON", new Pair<Integer, Float>(17, Float.valueOf(8.0f)));
            mapEntityTypes.put("ENDERMAN", new Pair<Integer, Float>(18, Float.valueOf(2.9f)));
            mapEntityTypes.put("ENDERMITE", new Pair<Integer, Float>(19, Float.valueOf(0.3f)));
            mapEntityTypes.put("EVOKER", new Pair<Integer, Float>(21, Float.valueOf(1.95f)));
            mapEntityTypes.put("HORSE", new Pair<Integer, Float>(28, Float.valueOf(1.6f)));
            mapEntityTypes.put("HUSK", new Pair<Integer, Float>(30, Float.valueOf(1.95f)));
            mapEntityTypes.put("ILLUSIONER", new Pair<Integer, Float>(31, Float.valueOf(1.95f)));
            mapEntityTypes.put("LLAMA", new Pair<Integer, Float>(36, Float.valueOf(1.87f)));
            mapEntityTypes.put("MAGMA_CUBE", new Pair<Integer, Float>(38, Float.valueOf(0.51000005f)));
            mapEntityTypes.put("MULE", new Pair<Integer, Float>(46, Float.valueOf(1.6f)));
            mapEntityTypes.put("MUSHROOM_COW", new Pair<Integer, Float>(47, Float.valueOf(1.4f)));
            mapEntityTypes.put("OCELOT", new Pair<Integer, Float>(48, Float.valueOf(0.7f)));
            mapEntityTypes.put("PARROT", new Pair<Integer, Float>(50, Float.valueOf(0.9f)));
            mapEntityTypes.put("PIG", new Pair<Integer, Float>(51, Float.valueOf(0.9f)));
            mapEntityTypes.put("PUFFERFISH", new Pair<Integer, Float>(52, Float.valueOf(0.7f)));
            mapEntityTypes.put("PIG_ZOMBIE", new Pair<Integer, Float>(53, Float.valueOf(1.8f)));
            mapEntityTypes.put("POLAR_BEAR", new Pair<Integer, Float>(54, Float.valueOf(1.4f)));
            mapEntityTypes.put("RABBIT", new Pair<Integer, Float>(56, Float.valueOf(0.5f)));
            mapEntityTypes.put("SALMON", new Pair<Integer, Float>(57, Float.valueOf(0.4f)));
            mapEntityTypes.put("SHEEP", new Pair<Integer, Float>(58, Float.valueOf(1.3f)));
            mapEntityTypes.put("SILVERFISH", new Pair<Integer, Float>(61, Float.valueOf(0.3f)));
            mapEntityTypes.put("SKELETON", new Pair<Integer, Float>(62, Float.valueOf(1.99f)));
            mapEntityTypes.put("SKELETON_HORSE", new Pair<Integer, Float>(63, Float.valueOf(1.6f)));
            mapEntityTypes.put("SLIME", new Pair<Integer, Float>(64, Float.valueOf(0.51000005f)));
            mapEntityTypes.put("SNOWMAN", new Pair<Integer, Float>(66, Float.valueOf(1.9f)));
            mapEntityTypes.put("GUARDIAN", new Pair<Integer, Float>(68, Float.valueOf(0.85f)));
            mapEntityTypes.put("SPIDER", new Pair<Integer, Float>(69, Float.valueOf(0.9f)));
            mapEntityTypes.put("SQUID", new Pair<Integer, Float>(70, Float.valueOf(1.8f)));
            mapEntityTypes.put("STRAY", new Pair<Integer, Float>(71, Float.valueOf(1.99f)));
            mapEntityTypes.put("TROPICAL_FISH", new Pair<Integer, Float>(72, Float.valueOf(0.4f)));
            mapEntityTypes.put("TURTLE", new Pair<Integer, Float>(73, Float.valueOf(0.4f)));
            mapEntityTypes.put("VEX", new Pair<Integer, Float>(78, Float.valueOf(0.95f)));
            mapEntityTypes.put("VILLAGER", new Pair<Integer, Float>(79, Float.valueOf(1.95f)));
            mapEntityTypes.put("IRON_GOLEM", new Pair<Integer, Float>(80, Float.valueOf(2.7f)));
            mapEntityTypes.put("VINDICATOR", new Pair<Integer, Float>(81, Float.valueOf(1.95f)));
            mapEntityTypes.put("WITCH", new Pair<Integer, Float>(82, Float.valueOf(1.95f)));
            mapEntityTypes.put("WITHER", new Pair<Integer, Float>(83, Float.valueOf(3.5f)));
            mapEntityTypes.put("WITHER_SKELETON", new Pair<Integer, Float>(84, Float.valueOf(2.4f)));
            mapEntityTypes.put("WOLF", new Pair<Integer, Float>(86, Float.valueOf(0.85f)));
            mapEntityTypes.put("ZOMBIE", new Pair<Integer, Float>(87, Float.valueOf(1.95f)));
            mapEntityTypes.put("ZOMBIE_HORSE", new Pair<Integer, Float>(88, Float.valueOf(1.6f)));
            mapEntityTypes.put("ZOMBIE_VILLAGER", new Pair<Integer, Float>(89, Float.valueOf(1.95f)));
            mapEntityTypes.put("PHANTOM", new Pair<Integer, Float>(90, Float.valueOf(0.5f)));
            mapEntityTypes.put("ENDER_CRYSTAL", new Pair<Integer, Float>(51, Float.valueOf(2.0f)));
            mapEntityTypes.put("ARROW", new Pair<Integer, Float>(60, Float.valueOf(0.5f)));
            mapEntityTypes.put("SNOWBALL", new Pair<Integer, Float>(61, Float.valueOf(0.25f)));
            mapEntityTypes.put("EGG", new Pair<Integer, Float>(62, Float.valueOf(0.25f)));
            mapEntityTypes.put("FIREBALL", new Pair<Integer, Float>(63, Float.valueOf(1.0f)));
            mapEntityTypes.put("SMALL_FIREBALL", new Pair<Integer, Float>(64, Float.valueOf(0.3125f)));
            mapEntityTypes.put("ENDER_PEARL", new Pair<Integer, Float>(65, Float.valueOf(0.25f)));
            mapEntityTypes.put("ENDER_SIGNAL", new Pair<Integer, Float>(72, Float.valueOf(0.25f)));
            mapEntityTypes.put("FIREWORK", new Pair<Integer, Float>(76, Float.valueOf(0.25f)));
        }
    }
}

