/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.holograms.objects;

import com.google.common.collect.ImmutableSet;
import eu.decentsoftware.holograms.api.holograms.DisableCause;
import eu.decentsoftware.holograms.api.holograms.objects.FlagHolder;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class HologramObject
extends FlagHolder {
    protected boolean enabled = true;
    @NonNull
    protected DisableCause cause = DisableCause.NONE;
    @NonNull
    protected final Set<UUID> viewers = ConcurrentHashMap.newKeySet();
    @NonNull
    protected Location location;
    protected String permission = null;
    protected float facing = 0.0f;

    protected HologramObject(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.location = location;
        this.location.setPitch(0.0f);
    }

    public void destroy() {
        this.disable();
    }

    public void delete() {
        this.destroy();
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public void enable() {
        this.cause = DisableCause.NONE;
        this.enabled = true;
    }

    public void disable() {
        this.disable(DisableCause.API);
    }

    public void disable(@NonNull DisableCause cause) {
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        if (cause == DisableCause.NONE) {
            throw new IllegalArgumentException("Cannot use DisableCause NONE while disabling Hologram!");
        }
        this.cause = cause;
        this.enabled = false;
    }

    @NonNull
    public DisableCause getDisableCause() {
        return this.cause;
    }

    public boolean canShow(Player player) {
        if (this.permission == null || this.permission.trim().isEmpty()) {
            return true;
        }
        return player != null && player.hasPermission(this.permission);
    }

    public void setFacing(float facing) {
        this.facing = facing;
        this.location.setYaw(facing);
    }

    public void setLocation(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.location = location;
        this.location.setYaw(this.facing);
        this.location.setPitch(0.0f);
    }

    @NonNull
    public Set<UUID> getViewers() {
        return ImmutableSet.copyOf(this.viewers);
    }

    @NonNull
    public List<Player> getViewerPlayers() {
        return this.getViewers().stream().map(Bukkit::getPlayer).filter(player -> player != null && player.isOnline()).collect(Collectors.toList());
    }

    public boolean isVisible(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.viewers.contains(player.getUniqueId());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NonNull
    public DisableCause getCause() {
        return this.cause;
    }

    @NonNull
    public Location getLocation() {
        return this.location;
    }

    public String getPermission() {
        return this.permission;
    }

    public float getFacing() {
        return this.facing;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCause(@NonNull DisableCause cause) {
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        this.cause = cause;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }
}

