/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.holograms.objects;

import eu.decentsoftware.holograms.api.holograms.enums.EnumFlag;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public abstract class FlagHolder {
    @NonNull
    protected final Set<EnumFlag> flags = Collections.synchronizedSet(new HashSet());

    public void addFlags(EnumFlag ... flags) {
        if (flags == null) {
            throw new NullPointerException("flags is marked non-null but is null");
        }
        this.flags.addAll(Arrays.asList(flags));
    }

    public void removeFlags(EnumFlag ... flags) {
        if (flags == null) {
            throw new NullPointerException("flags is marked non-null but is null");
        }
        for (EnumFlag flag : flags) {
            this.flags.remove((Object)flag);
        }
    }

    public boolean hasFlag(@NonNull EnumFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return this.flags.contains((Object)flag);
    }

    @NonNull
    public Set<EnumFlag> getFlags() {
        return this.flags;
    }
}

