/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.holograms;

import com.google.common.util.concurrent.AtomicDouble;
import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.Settings;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.api.holograms.enums.EnumFlag;
import eu.decentsoftware.holograms.api.holograms.enums.HologramLineType;
import eu.decentsoftware.holograms.api.holograms.objects.HologramObject;
import eu.decentsoftware.holograms.api.nms.NMS;
import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.PAPI;
import eu.decentsoftware.holograms.api.utils.entity.DecentEntityType;
import eu.decentsoftware.holograms.api.utils.entity.HologramEntity;
import eu.decentsoftware.holograms.api.utils.items.HologramItem;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HologramLine
extends HologramObject {
    protected static final DecentHolograms DECENT_HOLOGRAMS = DecentHologramsAPI.get();
    @Nullable
    private final HologramPage parent;
    @NonNull
    private final Map<UUID, String> playerTextMap = new ConcurrentHashMap<UUID, String>();
    @NonNull
    private final Map<UUID, String> lastTextMap = new ConcurrentHashMap<UUID, String>();
    private HologramLineType type;
    private int[] entityIds = new int[2];
    @NonNull
    private final AtomicDouble offsetX = new AtomicDouble(0.0);
    @NonNull
    private final AtomicDouble offsetY = new AtomicDouble(0.0);
    @NonNull
    private final AtomicDouble offsetZ = new AtomicDouble(0.0);
    private double height;
    @NonNull
    private String content;
    private String text;
    private HologramItem item;
    private HologramEntity entity;
    private volatile boolean containsAnimations;
    private volatile boolean containsPlaceholders;

    @NonNull
    public static HologramLine fromFile(@NonNull ConfigurationSection config, @Nullable HologramPage parent, @NonNull Location location) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        HologramLine line = new HologramLine(parent, location, config.getString("content", Settings.DEFAULT_TEXT));
        if (config.isString("permission")) {
            line.setPermission(config.getString("permission", null));
        }
        if (config.isList("flags")) {
            line.addFlags((EnumFlag[])config.getStringList("flags").stream().map(EnumFlag::valueOf).toArray(EnumFlag[]::new));
        }
        if (config.isDouble("height")) {
            line.setHeight(config.getDouble("height"));
        }
        if (config.isDouble("offsetX")) {
            line.setOffsetX(config.getDouble("offsetX"));
        }
        if (config.isDouble("offsetZ")) {
            line.setOffsetZ(config.getDouble("offsetZ"));
        }
        if (config.isDouble("facing")) {
            line.setFacing((float)config.getDouble("facing"));
        }
        return line;
    }

    @NonNull
    public static HologramLine fromMap(@NonNull Map<String, Object> map, @Nullable HologramPage parent, @NonNull Location location) {
        Object facing;
        Object offsetZ;
        Object offsetX;
        Object permission;
        Object flags;
        Object height;
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        String content = (String)map.getOrDefault("content", Settings.DEFAULT_TEXT);
        HologramLine line = new HologramLine(parent, location, content);
        if (map.containsKey("height") && (height = map.get("height")) instanceof Double) {
            line.setHeight((Double)height);
        }
        if (map.containsKey("flags") && (flags = map.get("flags")) instanceof List) {
            try {
                line.addFlags((EnumFlag[])((List)flags).stream().map(EnumFlag::valueOf).toArray(EnumFlag[]::new));
            }
            catch (Exception e) {
                DECENT_HOLOGRAMS.getPlugin().getLogger().warning(String.format("Flags for line %s seem to be invalid!", content));
            }
        }
        if (map.containsKey("permission") && (permission = map.get("permission")) instanceof String) {
            line.setPermission((String)permission);
        }
        if (map.containsKey("offsetX") && (offsetX = map.get("offsetX")) instanceof Double) {
            line.setOffsetX((Double)offsetX);
        }
        if (map.containsKey("offsetZ") && (offsetZ = map.get("offsetZ")) instanceof Double) {
            line.setOffsetZ((Double)offsetZ);
        }
        if (map.containsKey("facing") && (facing = map.get("facing")) instanceof Double) {
            line.setFacing(((Double)facing).floatValue());
        }
        return line;
    }

    public HologramLine(@Nullable HologramPage parent, @NonNull Location location, @NotNull String content) {
        super(location);
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.parent = parent;
        NMS nms = NMS.getInstance();
        this.entityIds[0] = nms.getFreeEntityId();
        this.entityIds[1] = nms.getFreeEntityId();
        this.content = content;
        this.type = HologramLineType.UNKNOWN;
        this.height = Settings.DEFAULT_HEIGHT_TEXT;
        this.parseContent();
    }

    public String toString() {
        return "DefaultHologramLine{content=" + this.content + "} " + super.toString();
    }

    public void setContent(@Nullable String content) {
        this.content = content == null ? "" : content;
        this.parseContent();
        this.update(new Player[0]);
    }

    @Override
    public void enable() {
        super.enable();
        this.show(new Player[0]);
    }

    @Override
    public void disable() {
        super.disable();
        this.hide(new Player[0]);
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void parseContent() {
        HologramLineType prevType = this.type;
        String contentU = this.content.toUpperCase(Locale.ROOT);
        if (contentU.startsWith("#ICON:")) {
            this.type = HologramLineType.ICON;
            if (prevType != this.type) {
                this.height = Settings.DEFAULT_HEIGHT_ICON;
            }
            this.item = new HologramItem(this.content.substring("#ICON:".length()));
            this.containsPlaceholders = PAPI.containsPlaceholders(this.item.getContent());
        } else if (contentU.startsWith("#SMALLHEAD:")) {
            this.type = HologramLineType.SMALLHEAD;
            if (prevType != this.type) {
                this.height = Settings.DEFAULT_HEIGHT_SMALLHEAD;
            }
            this.item = new HologramItem(this.content.substring("#SMALLHEAD:".length()));
        } else if (contentU.startsWith("#HEAD:")) {
            this.type = HologramLineType.HEAD;
            if (prevType != this.type) {
                this.height = Settings.DEFAULT_HEIGHT_HEAD;
            }
            this.item = new HologramItem(this.content.substring("#HEAD:".length()));
        } else {
            if (contentU.startsWith("#ENTITY:")) {
                this.type = HologramLineType.ENTITY;
                this.entity = new HologramEntity(this.content.substring("#ENTITY:".length()));
                this.height = (double)NMS.getInstance().getEntityHeight(this.entity.getType()) + 0.15;
                this.setOffsetY(-(this.height + (Version.afterOrEqual(13) ? 0.1 : 0.2)));
                return;
            }
            this.type = HologramLineType.TEXT;
            if (prevType != this.type) {
                this.height = Settings.DEFAULT_HEIGHT_TEXT;
            }
            this.text = this.parseCustomReplacements();
            this.containsAnimations = DECENT_HOLOGRAMS.getAnimationManager().containsAnimations(this.text);
            this.containsPlaceholders = PAPI.containsPlaceholders(this.text);
        }
        this.setOffsetY(this.type.getOffsetY());
    }

    @NonNull
    public Map<String, Object> serializeToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("content", this.content);
        map.put("height", this.height);
        if (!this.flags.isEmpty()) {
            map.put("flags", this.flags.stream().map(Enum::name).collect(Collectors.toList()));
        }
        if (this.permission != null && !this.permission.trim().isEmpty()) {
            map.put("permission", this.permission);
        }
        if (this.getOffsetX() != 0.0) {
            map.put("offsetX", this.offsetX);
        }
        if (this.getOffsetZ() != 0.0) {
            map.put("offsetZ", this.offsetZ);
        }
        if (this.parent == null || this.getFacing() != this.parent.getParent().getFacing()) {
            map.put("facing", Float.valueOf(this.facing));
        }
        return map;
    }

    @NonNull
    public HologramLine clone(@Nullable HologramPage parent, @NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        HologramLine line = new HologramLine(parent, location, this.getContent());
        line.setHeight(this.getHeight());
        line.setOffsetY(this.getOffsetY());
        line.setOffsetX(this.getOffsetX());
        line.setOffsetZ(this.getOffsetZ());
        line.setFacing(this.getFacing());
        line.setPermission(this.getPermission());
        line.addFlags(this.getFlags().toArray(new EnumFlag[0]));
        return line;
    }

    @NonNull
    public HologramLineType getType() {
        return this.type != null ? this.type : HologramLineType.UNKNOWN;
    }

    @NotNull
    private String getText(@NonNull Player player, boolean update) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.type != HologramLineType.TEXT) {
            return "";
        }
        UUID uuid = player.getUniqueId();
        String string = this.playerTextMap.get(uuid);
        if (update || string == null) {
            String string2 = string = this.text == null ? "" : this.text;
            if (!this.hasFlag(EnumFlag.DISABLE_PLACEHOLDERS)) {
                string = this.parsePlaceholders(string, player, this.containsPlaceholders);
            }
            this.playerTextMap.put(uuid, string);
        }
        if (this.containsAnimations && !this.hasFlag(EnumFlag.DISABLE_ANIMATIONS)) {
            string = DECENT_HOLOGRAMS.getAnimationManager().parseTextAnimations(string);
            if (Settings.ALLOW_PLACEHOLDERS_INSIDE_ANIMATIONS && !this.hasFlag(EnumFlag.DISABLE_PLACEHOLDERS)) {
                string = this.parsePlaceholders(string, player, true);
            }
        }
        return Common.colorize(string);
    }

    @NonNull
    private List<Player> getPlayers(boolean onlyViewers, Player ... players) {
        ArrayList<Player> playerList = players == null || players.length == 0 ? (onlyViewers ? this.getViewerPlayers() : new ArrayList<Player>(Bukkit.getOnlinePlayers())) : Arrays.asList(players);
        return playerList;
    }

    @NotNull
    private String parsePlaceholders(@NotNull String string, @NonNull Player player, boolean papi) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        string = string.replace("{player}", player.getName());
        string = string.replace("{page}", String.valueOf(this.hasParent() ? this.parent.getIndex() + 1 : 1));
        string = string.replace("{pages}", String.valueOf(this.hasParent() ? this.parent.getParent().size() : 1));
        if (papi && (string = PAPI.setPlaceholders(player, string)) == null) {
            string = "";
        }
        return string;
    }

    @NonNull
    private String parseCustomReplacements() {
        if (this.content != null && !this.content.isEmpty()) {
            for (Map.Entry<String, String> replacement : Settings.CUSTOM_REPLACEMENTS.entrySet()) {
                this.content = this.content.replace(replacement.getKey(), replacement.getValue());
            }
        }
        return this.content;
    }

    public boolean hasPermission(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.permission == null || this.permission.isEmpty() || player.hasPermission(this.permission);
    }

    public void updateVisibility(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (!(!this.isVisible(player) || this.hasPermission(player) && this.isInDisplayRange(player))) {
            this.hide(player);
        } else if (!this.isVisible(player) && this.hasPermission(player) && this.isInDisplayRange(player)) {
            this.show(player);
        }
    }

    public void show(Player ... players) {
        if (this.isDisabled()) {
            return;
        }
        List<Player> playerList = this.getPlayers(false, players);
        NMS nms = NMS.getInstance();
        for (Player player : playerList) {
            if (player == null || this.parent != null && this.parent.getParent().isHideState(player) || this.isVisible(player) || !this.canShow(player) || !this.isInDisplayRange(player)) continue;
            switch (this.type) {
                case TEXT: {
                    nms.showFakeEntityArmorStand(player, this.getLocation(), this.entityIds[0], true, true, false);
                    nms.updateFakeEntityCustomName(player, this.getText(player, true), this.entityIds[0]);
                    break;
                }
                case HEAD: 
                case SMALLHEAD: {
                    nms.showFakeEntityArmorStand(player, this.getLocation(), this.entityIds[0], true, HologramLineType.HEAD != this.type, false);
                    ItemStack itemStack = this.containsPlaceholders ? HologramItem.parseItemStack(this.item.getContent(), player) : this.item.parse();
                    nms.helmetFakeEntity(player, itemStack, this.entityIds[0]);
                    break;
                }
                case ICON: {
                    nms.showFakeEntityArmorStand(player, this.getLocation(), this.entityIds[0], true, true, false);
                    ItemStack itemStack1 = this.containsPlaceholders ? HologramItem.parseItemStack(this.item.getContent(), player) : this.item.parse();
                    nms.showFakeEntityItem(player, this.getLocation(), itemStack1, this.entityIds[1]);
                    nms.attachFakeEntity(player, this.entityIds[0], this.entityIds[1]);
                    break;
                }
                case ENTITY: {
                    EntityType entityType = new HologramEntity(PAPI.setPlaceholders(player, this.getEntity().getContent())).getType();
                    if (entityType == null || !DecentEntityType.isAllowed(entityType)) break;
                    nms.showFakeEntityArmorStand(player, this.getLocation(), this.entityIds[0], true, true, false);
                    if (this.entity.getType().isAlive()) {
                        nms.showFakeEntityLiving(player, this.getLocation(), entityType, this.entityIds[1]);
                    } else {
                        nms.showFakeEntity(player, this.getLocation(), entityType, this.entityIds[1]);
                    }
                    nms.attachFakeEntity(player, this.entityIds[0], this.entityIds[1]);
                    break;
                }
            }
            this.viewers.add(player.getUniqueId());
        }
    }

    public void update(Player ... players) {
        if (this.isDisabled() || this.hasFlag(EnumFlag.DISABLE_UPDATING)) {
            return;
        }
        List<Player> playerList = this.getPlayers(true, players);
        NMS nms = NMS.getInstance();
        for (Player player : playerList) {
            if (this.type == HologramLineType.TEXT) {
                UUID uuid = player.getUniqueId();
                String lastText = this.lastTextMap.get(uuid);
                String updatedText = this.getText(player, true);
                if (updatedText.equals(lastText)) continue;
                this.lastTextMap.put(uuid, updatedText);
                nms.updateFakeEntityCustomName(player, updatedText, this.entityIds[0]);
                continue;
            }
            if (this.type != HologramLineType.HEAD && this.type != HologramLineType.SMALLHEAD) continue;
            nms.helmetFakeEntity(player, HologramItem.parseItemStack(this.getItem().getContent(), player), this.entityIds[0]);
        }
    }

    public void updateLocation(boolean updateRotation, Player ... players) {
        if (this.isDisabled()) {
            return;
        }
        List<Player> playerList = this.getPlayers(true, players);
        for (Player player : playerList) {
            if (this.type == HologramLineType.ENTITY && updateRotation) {
                this.hide(new Player[0]);
                this.show(new Player[0]);
                continue;
            }
            NMS.getInstance().teleportFakeEntity(player, this.getLocation(), this.entityIds[0]);
        }
    }

    public void updateAnimations(Player ... players) {
        if (this.isDisabled() || this.type != HologramLineType.TEXT || this.hasFlag(EnumFlag.DISABLE_ANIMATIONS)) {
            return;
        }
        List<Player> playerList = this.getPlayers(true, players);
        NMS nms = NMS.getInstance();
        for (Player player : playerList) {
            UUID uuid = player.getUniqueId();
            String lastText = this.lastTextMap.get(uuid);
            String updatedText = this.getText(player, false);
            if (updatedText.equals(lastText)) continue;
            this.lastTextMap.put(uuid, updatedText);
            nms.updateFakeEntityCustomName(player, updatedText, this.entityIds[0]);
        }
    }

    public void hide(Player ... players) {
        List<Player> playerList = this.getPlayers(true, players);
        for (Player player : playerList) {
            NMS.getInstance().hideFakeEntities(player, this.entityIds[0], this.entityIds[1]);
            this.viewers.remove(player.getUniqueId());
        }
    }

    public boolean isInDisplayRange(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.parent == null || this.parent.getParent().isInDisplayRange(player);
    }

    public boolean isInUpdateRange(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.parent == null || this.parent.getParent().isInDisplayRange(player);
    }

    public double getOffsetX() {
        return this.offsetX.get();
    }

    public double getOffsetY() {
        return this.offsetY.get();
    }

    public double getOffsetZ() {
        return this.offsetZ.get();
    }

    public void setOffsetX(double offsetX) {
        this.offsetX.set(offsetX);
    }

    public void setOffsetY(double offsetY) {
        this.offsetY.set(offsetY);
    }

    public void setOffsetZ(double offsetZ) {
        this.offsetZ.set(offsetZ);
    }

    @Override
    public boolean hasFlag(@NonNull EnumFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return super.hasFlag(flag) || this.parent != null && this.parent.getParent().hasFlag(flag);
    }

    @Override
    public boolean canShow(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return super.canShow(player) && (this.parent == null || this.parent.getParent().canShow(player));
    }

    @Nullable
    public HologramPage getParent() {
        return this.parent;
    }

    @NonNull
    public Map<UUID, String> getPlayerTextMap() {
        return this.playerTextMap;
    }

    @NonNull
    public Map<UUID, String> getLastTextMap() {
        return this.lastTextMap;
    }

    public int[] getEntityIds() {
        return this.entityIds;
    }

    public double getHeight() {
        return this.height;
    }

    @NonNull
    public String getContent() {
        return this.content;
    }

    public String getText() {
        return this.text;
    }

    public HologramItem getItem() {
        return this.item;
    }

    public HologramEntity getEntity() {
        return this.entity;
    }

    public boolean isContainsAnimations() {
        return this.containsAnimations;
    }

    public boolean isContainsPlaceholders() {
        return this.containsPlaceholders;
    }

    public void setType(HologramLineType type) {
        this.type = type;
    }

    public void setEntityIds(int[] entityIds) {
        this.entityIds = entityIds;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setItem(HologramItem item) {
        this.item = item;
    }

    public void setEntity(HologramEntity entity) {
        this.entity = entity;
    }

    public void setContainsAnimations(boolean containsAnimations) {
        this.containsAnimations = containsAnimations;
    }

    public void setContainsPlaceholders(boolean containsPlaceholders) {
        this.containsPlaceholders = containsPlaceholders;
    }
}

