/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.animations.text;

import com.google.common.collect.Lists;
import eu.decentsoftware.holograms.api.animations.TextAnimation;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public class ColorsAnimation
extends TextAnimation {
    private static final List<String> DEFAULT_COLORS = Lists.newArrayList((Object[])new String[]{"&c", "&6", "&e", "&a", "&b", "&d"});

    public ColorsAnimation() {
        super("colors", 4, 0, "colours");
    }

    @Override
    public String animate(@NonNull String string, long step, String ... args) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        List<String> colors = DEFAULT_COLORS;
        if (args != null && args.length > 0) {
            colors.clear();
            colors.addAll(Arrays.asList(args));
        }
        int currentStep = this.getCurrentStep(step, colors.size());
        return colors.get(currentStep) + string;
    }
}

