/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.actions;

import eu.decentsoftware.holograms.api.actions.ActionType;
import lombok.NonNull;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Action {
    @NonNull
    private final ActionType type;
    @Nullable
    private String data;

    public Action(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        if (string.contains(":")) {
            String[] spl = string.split(":", 2);
            this.type = ActionType.getByName(spl[0]);
            this.data = spl.length > 1 ? spl[1] : "";
        } else {
            this.type = ActionType.getByName(string);
            this.data = null;
        }
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid action type in action: " + string);
        }
    }

    public Action(@NonNull ActionType type, @Nullable String data) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.data = data;
    }

    public boolean execute(Player player) {
        return this.type.execute(player, this.data);
    }

    public boolean isValid() {
        return this.type != null;
    }

    public String toString() {
        return this.data == null ? this.type.getName() : String.format("%s:%s", this.type.getName(), this.data);
    }

    @NonNull
    public ActionType getType() {
        return this.type;
    }

    @Nullable
    public String getData() {
        return this.data;
    }

    public void setData(@Nullable String data) {
        this.data = data;
    }
}

